/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.api.leveling;

import it.hurts.sskirillss.relics.configs.data.relics.RelicLevelingData;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.item.ItemStack;

public interface ILeveledItem {
    public static final String TAG_EXPERIENCE = "experience";
    public static final String TAG_LEVEL = "level";

    public RelicLevelingData getLevelingData();

    default public int getLevel(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_LEVEL, 0);
    }

    default public int getLevelFromExperience(int experience) {
        RelicLevelingData data = this.getLevelingData();
        int min = 0;
        int max = data.getMaxLevel();
        while (min <= max) {
            int mid = (min + max) / 2;
            int exp = this.getTotalExperienceForLevel(mid);
            if (exp > experience) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return max;
    }

    default public void setLevel(ItemStack stack, int level) {
        this.setExperience(stack, this.getTotalExperienceForLevel(level));
    }

    default public void addLevel(ItemStack stack, int level) {
        this.setLevel(stack, this.getLevel(stack) + level);
    }

    default public void takeLevel(ItemStack stack, int level) {
        this.setLevel(stack, this.getLevel(stack) - level);
    }

    default public int getExperience(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_EXPERIENCE, 0);
    }

    default public int getExperienceForLevel(int level) {
        return this.getTotalExperienceForLevel(level + 1) - this.getTotalExperienceForLevel(level);
    }

    default public int getTotalExperienceForLevel(int level) {
        return this.getTotalExperienceForLevel(this.getLevelingData(), level);
    }

    default public int getTotalExperienceForLevel(RelicLevelingData data, int level) {
        return (2 * data.getInitialCost() + data.getCostRatio() * (level - 1)) * level / 2;
    }

    default public void setExperience(ItemStack stack, int experience) {
        RelicLevelingData data = this.getLevelingData();
        experience = Math.max(0, Math.min(this.getMaxExperience(), experience));
        NBTUtils.setInt(stack, TAG_LEVEL, Math.max(0, Math.min(data.getMaxLevel(), this.getLevelFromExperience(experience))));
        NBTUtils.setInt(stack, TAG_EXPERIENCE, experience);
    }

    default public void addExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) + experience);
    }

    default public void takeExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) - experience);
    }

    default public int getMaxExperience() {
        return this.getTotalExperienceForLevel(this.getLevelingData().getMaxLevel());
    }
}

