/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.hud;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.PacketRelicAbility;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
public class HUDEventHandler {
    private static final List<KeyBinding> keyBindings = Arrays.asList(HotkeyRegistry.HUD_FIRST.getKeyBinding(), HotkeyRegistry.HUD_SECOND.getKeyBinding(), HotkeyRegistry.HUD_THIRD.getKeyBinding(), HotkeyRegistry.HUD_FOURTH.getKeyBinding(), HotkeyRegistry.HUD_FIFTH.getKeyBinding());
    static List<ImmutablePair<ItemStack, Integer>> relics = new ArrayList<ImmutablePair<ItemStack, Integer>>();
    static int offset = 0;
    static int slots = 5;
    static float animation = 0.0f;
    static long prevTime = System.currentTimeMillis();
    static boolean locked = false;
    private static final ResourceLocation SLOT = new ResourceLocation("relics", "textures/hud/slot.png");
    private static final ResourceLocation ARROW_UP = new ResourceLocation("relics", "textures/hud/arrow_up.png");
    private static final ResourceLocation ARROW_DOWN = new ResourceLocation("relics", "textures/hud/arrow_down.png");

    @SubscribeEvent
    public static void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR || !(Minecraft.func_71410_x().func_175606_aa() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)Minecraft.func_71410_x().func_175606_aa();
        if (player == null || relics.isEmpty()) {
            return;
        }
        float multiplier = (float)(System.currentTimeMillis() - prevTime) / 11.0f;
        prevTime = System.currentTimeMillis();
        if (Screen.func_231174_t_()) {
            if (!locked) {
                animation = Math.min(44.0f, animation + multiplier);
            }
        } else {
            if (locked && animation < 500.0f) {
                animation += multiplier;
            }
            if (animation >= 500.0f) {
                locked = false;
            }
            if (!locked) {
                animation = Math.max(0.0f, animation - multiplier);
            }
        }
        if (animation == 44.0f) {
            locked = true;
        }
        if (animation == 0.0f) {
            return;
        }
        int x = (int)((float)(event.getWindow().func_198107_o() + 5) - Math.min(44.0f, animation));
        int y = 29;
        TextureManager manager = Minecraft.func_71410_x().func_110434_K();
        MatrixStack matrix = event.getMatrixStack();
        RenderSystem.enableBlend();
        if (relics.size() > slots) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, animation * 0.025f));
            manager.func_110577_a(ARROW_UP);
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x - 3), (int)y, (int)22, (int)22, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            RenderSystem.disableBlend();
            y += 29;
        }
        for (int i = offset; i < Math.min(relics.size(), slots) + offset && i < relics.size() && i >= 0; ++i) {
            HUDEventHandler.drawRelic(matrix, manager, ((ItemStack)relics.get(i).getKey()).func_77973_b(), keyBindings.get(i - offset), player, x, y);
            y += 33;
        }
        if (relics.size() > slots) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, animation * 0.025f));
            manager.func_110577_a(ARROW_DOWN);
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x - 3), (int)y, (int)22, (int)22, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            RenderSystem.disableBlend();
        }
        manager.func_110577_a(AbstractGui.field_230665_h_);
    }

    private static void drawRelic(MatrixStack matrix, TextureManager manager, Item item, KeyBinding key, PlayerEntity player, int x, int y) {
        String path = item.getRegistryName().func_110623_a();
        if (path.equals(Items.field_190931_a.getRegistryName().func_110623_a())) {
            return;
        }
        matrix.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, animation * 0.025f));
        manager.func_110577_a(SLOT);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x - 4), (int)(y - 4), (int)24, (int)32, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        Minecraft.func_71410_x().func_175599_af().func_239390_c_(new ItemStack((IItemProvider)item), x, y);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        float yOff = y + MathHelper.func_76141_d((float)(16.0f * (1.0f - player.func_184811_cZ().func_185143_a(item, Minecraft.func_71410_x().func_184121_ak()))));
        float offset = MathHelper.func_76123_f((float)(16.0f * player.func_184811_cZ().func_185143_a(item, Minecraft.func_71410_x().func_184121_ak())));
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_225582_a_((double)x, (double)(yOff + 0.0f), 0.0).func_225586_a_(255, 255, 255, 127).func_181675_d();
        builder.func_225582_a_((double)x, (double)(yOff + offset), 0.0).func_225586_a_(255, 255, 255, 127).func_181675_d();
        builder.func_225582_a_((double)(x + 16), (double)(yOff + offset), 0.0).func_225586_a_(255, 255, 255, 127).func_181675_d();
        builder.func_225582_a_((double)(x + 16), (double)(yOff + 0.0f), 0.0).func_225586_a_(255, 255, 255, 127).func_181675_d();
        tessellator.func_78381_a();
        matrix.func_227862_a_(0.5f, 0.5f, 0.5f);
        Minecraft.func_71410_x().field_71466_p.func_243248_b(matrix, key.getKeyModifier().getCombinedName(key.getKey(), () -> key.getKey().func_237520_d_()), (float)x * 2.0f - 2.0f, (float)(y + 21) * 2.0f, 0xFFFFFF);
        RenderSystem.disableBlend();
        matrix.func_227865_b_();
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!player.func_130014_f_().func_201670_d() || player.field_70173_aa % 10 != 0) {
            return;
        }
        CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).ifPresent(handler -> {
            relics.clear();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof RelicItem)) continue;
                RelicItem relic = (RelicItem)stack.func_77973_b();
                if (DurabilityUtils.isBroken(stack) || !relic.getData().hasAbility()) continue;
                relics.add((ImmutablePair<ItemStack, Integer>)new ImmutablePair((Object)stack, (Object)i));
            }
            if ((offset = offset / slots * slots) == relics.size()) {
                offset = Math.max(0, offset - 1) / slots * slots;
            }
        });
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (relics.size() > slots) {
            if (HotkeyRegistry.HUD_UP.func_151470_d()) {
                animation = 500.0f;
                if ((offset -= slots) < 0) {
                    offset = (relics.size() - 1) / slots * slots;
                }
                player.func_130014_f_().func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.MASTER, 1.0f, 1.0f);
            } else if (HotkeyRegistry.HUD_DOWN.func_151470_d()) {
                animation = 500.0f;
                if ((offset += slots) >= relics.size()) {
                    offset = 0;
                }
                player.func_130014_f_().func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187909_gi, SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        for (int i = 0; i < keyBindings.size(); ++i) {
            RelicItem relic;
            ImmutablePair<ItemStack, Integer> pair;
            ItemStack stack;
            KeyBinding key = keyBindings.get(i);
            if (!key.func_151470_d()) continue;
            animation = 500.0f;
            int id = i + offset;
            if (id >= relics.size() || !((stack = (ItemStack)(pair = relics.get(i + offset)).getLeft()).func_77973_b() instanceof RelicItem) || !(relic = (RelicItem)stack.func_77973_b()).getData().hasAbility()) continue;
            NetworkHandler.sendToServer(new PacketRelicAbility((Integer)pair.getRight()));
            relic.castAbility((PlayerEntity)player, stack);
        }
    }
}

