/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="relics", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipBorderHandler {
    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        ItemStack stack = event.getStack();
        if (!(stack.func_77973_b() instanceof RelicItem)) {
            return;
        }
        Pair<String, String> colors = TooltipBorderHandler.getBorderColors(stack);
        Color color = new Color(stack.func_77953_t().field_77937_e.func_211163_e()).darker();
        int top = colors == null ? color.getRGB() : Color.decode((String)colors.getLeft()).getRGB();
        int bottom = colors == null ? color.darker().darker().getRGB() : Color.decode((String)colors.getRight()).getRGB();
        event.setBorderStart(top);
        event.setBorderEnd(bottom);
    }

    @SubscribeEvent
    public static void onPostTooltipEvent(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (TooltipBorderHandler.getBorderColors(stack) == null) {
            return;
        }
        int x = event.getX();
        int y = event.getY();
        int width = event.getWidth();
        int height = event.getHeight();
        MatrixStack matrix = event.getMatrixStack();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("relics", "textures/gui/tooltip/" + stack.func_77973_b().getRegistryName().func_110623_a() + ".png"));
        int texWidth = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4096);
        int texHeight = GlStateManager.func_227692_c_((int)3553, (int)0, (int)4097);
        if (texHeight == 0 || texWidth == 0) {
            return;
        }
        matrix.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        matrix.func_227861_a_(0.0, 0.0, 410.0);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x - 14), (int)(y - 14), (int)16, (int)16, (float)1.0f, (float)texHeight, (int)16, (int)16, (int)texWidth, (int)texHeight);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + width - 2), (int)(y - 14), (int)16, (int)16, (float)(texWidth - 16 - 1), (float)texHeight, (int)16, (int)16, (int)texWidth, (int)texHeight);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x - 14), (int)(y + height - 4), (int)16, (int)16, (float)1.0f, (float)(texHeight + 16), (int)16, (int)16, (int)texWidth, (int)texHeight);
        AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + width - 2), (int)(y + height - 4), (int)16, (int)16, (float)(texWidth - 16 - 1), (float)(texHeight + 16), (int)16, (int)16, (int)texWidth, (int)texHeight);
        if (width >= 94) {
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + width / 2 - 47), (int)(y - 16), (int)94, (int)16, (float)(16 + 2 * texWidth + 1), (float)texHeight, (int)94, (int)16, (int)texWidth, (int)texHeight);
            AbstractGui.func_238466_a_((MatrixStack)matrix, (int)(x + width / 2 - 47), (int)(y + height), (int)94, (int)16, (float)(16 + 2 * texWidth + 1), (float)(texHeight + 16), (int)94, (int)16, (int)texWidth, (int)texHeight);
        }
        RenderSystem.disableBlend();
        matrix.func_227865_b_();
    }

    @Nullable
    private static Pair<String, String> getBorderColors(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof RelicItem)) {
            return null;
        }
        RelicItem relic = (RelicItem)stack.func_77973_b();
        RelicTooltip tooltip = relic.getTooltip(stack);
        if (tooltip == null) {
            return null;
        }
        return tooltip.getBorders();
    }
}

