/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.entities.ShadowGlaiveEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.RelicsTab;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.world.World;
import top.theillusivec4.curios.api.SlotContext;

public class ShadowGlaiveItem
extends RelicItem<Stats> {
    public static final String TAG_CHARGES = "charges";
    private static final String TAG_TIME = "time";
    public static ShadowGlaiveItem INSTANCE;

    public ShadowGlaiveItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#cd8aea", "#682a82").ability(AbilityTooltip.builder().arg(((Stats)this.stats).maxBounces).arg(((Stats)this.stats).damage).arg(((Stats)this.stats).chargeRegenerationTime).active(Minecraft.func_71410_x().field_71474_y.field_74313_G).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group != RelicsTab.RELICS_TAB) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)ItemRegistry.SHADOW_GLAIVE.get());
        NBTUtils.setInt(stack, TAG_CHARGES, ((Stats)this.stats).maxCharges);
        items.add((Object)stack);
        super.func_150895_a(group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        int charges = NBTUtils.getInt(stack, TAG_CHARGES, 0);
        if (DurabilityUtils.isBroken(stack) || entityIn.field_70173_aa % 20 != 0 || charges >= ((Stats)this.stats).maxCharges) {
            return;
        }
        int time = NBTUtils.getInt(stack, TAG_TIME, 0);
        if (time >= ((Stats)this.stats).chargeRegenerationTime) {
            NBTUtils.setInt(stack, TAG_CHARGES, charges + 1);
            NBTUtils.setInt(stack, TAG_TIME, 0);
        } else {
            NBTUtils.setInt(stack, TAG_TIME, time + 1);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        Entity target;
        ItemStack stack = playerIn.func_184586_b(handIn);
        int charges = NBTUtils.getInt(stack, TAG_CHARGES, 0);
        if (DurabilityUtils.isBroken(stack) || charges <= 0 || playerIn.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        ShadowGlaiveEntity glaive = new ShadowGlaiveEntity(worldIn, (LivingEntity)playerIn);
        glaive.setOwner(playerIn);
        glaive.func_70634_a(playerIn.func_226277_ct_(), playerIn.func_226278_cu_() + (double)(playerIn.func_213302_cg() * 0.5f), playerIn.func_226281_cx_());
        glaive.func_234612_a_((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, ((Stats)this.stats).projectileSpeed, 1.0f, 0.0f);
        worldIn.func_217376_c((Entity)glaive);
        EntityRayTraceResult result = EntityUtils.rayTraceEntity((Entity)playerIn, EntityPredicates.field_188444_d, 32.0);
        if (result != null && (target = result.func_216348_a()) instanceof LivingEntity) {
            glaive.setTarget((LivingEntity)target);
        }
        worldIn.func_184148_a(null, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), SoundRegistry.THROW, SoundCategory.MASTER, 0.5f, 0.75f + field_77697_d.nextFloat() * 0.5f);
        NBTUtils.setInt(stack, TAG_CHARGES, charges - 1);
        playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).throwCooldown);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }

    public static class Stats
    extends RelicStats {
        public int maxCharges = 8;
        public int chargeRegenerationTime = 10;
        public int damage = 5;
        public int throwCooldown = 5;
        public float bounceChanceMultiplier = 0.015f;
        public int bounceRadius = 7;
        public float projectileSpeed = 0.75f;
        public int maxBounces = 10;
    }
}

