/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.back;

import it.hurts.sskirillss.relics.client.renderer.items.models.MidnightRobeModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.UUID;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class MidnightRobeItem
extends RelicItem<Stats>
implements ICurioItem {
    public static MidnightRobeItem INSTANCE;
    private final MutablePair<String, UUID> SPEED_INFO = new MutablePair((Object)"relics:midnight_robe_movement_speed", (Object)UUID.fromString("21a949be-67d9-43bb-96b8-496782d60933"));

    public MidnightRobeItem() {
        super(RelicData.builder().rarity(Rarity.UNCOMMON).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#00071f", "#001974").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).speedModifier * 100.0f) + "%").build()).ability(AbilityTooltip.builder().arg(((Stats)this.stats).minLightLevel).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        World world = livingEntity.func_130014_f_();
        if (world.func_201670_d() || DurabilityUtils.isBroken(stack) || livingEntity.field_70173_aa % 20 != 0) {
            return;
        }
        if (MidnightRobeItem.canHide(livingEntity)) {
            livingEntity.func_195064_c(new EffectInstance(Effects.field_76441_p, 30, 0, false, false));
        }
        ModifiableAttributeInstance attribSpeed = livingEntity.func_110148_a(Attributes.field_233821_d_);
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (world.func_226690_K_()) {
            EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
        } else {
            EntityUtils.removeAttributeModifier(attribSpeed, speedModifier);
        }
    }

    private static boolean canHide(LivingEntity entity) {
        World world = entity.func_130014_f_();
        BlockPos position = entity.func_233580_cy_();
        return !EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.MIDNIGHT_ROBE.get()).func_190926_b() && world.func_226658_a_(LightType.BLOCK, position) + world.func_226658_a_(LightType.SKY, position) <= ((Stats)MidnightRobeItem.INSTANCE.stats).minLightLevel;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(slotContext.getWearer().func_110148_a(Attributes.field_233821_d_), new AttributeModifier((UUID)this.SPEED_INFO.getRight(), (String)this.SPEED_INFO.getLeft(), (double)((Stats)this.stats).speedModifier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new MidnightRobeModel();
    }

    public static class Stats
    extends RelicStats {
        public float speedModifier = 0.15f;
        public int minLightLevel = 2;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class CamouflageRingClientEvents {
        @SubscribeEvent
        public static void onEntityRender(RenderPlayerEvent.Pre event) {
            if (MidnightRobeItem.canHide((LivingEntity)event.getPlayer())) {
                event.setCanceled(true);
            }
        }
    }
}

