/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.belt;

import it.hurts.sskirillss.relics.client.renderer.items.models.HunterBeltModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

public class HunterBeltItem
extends RelicItem<Stats> {
    public static HunterBeltItem INSTANCE;

    public HunterBeltItem() {
        super(RelicData.builder().rarity(Rarity.UNCOMMON).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#32a167", "#16702e").ability(AbilityTooltip.builder().arg(((Stats)this.stats).additionalLooting).build()).ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).petDamageMultiplier * 100.0f - 100.0f) + "%").build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    @Override
    public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().entry((Pair<String, Integer>)Pair.of((Object)"talisman", (Object)1)).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new HunterBeltModel();
    }

    public int getLootingBonus(String identifier, LivingEntity livingEntity, ItemStack curio, int index) {
        return ((Stats)this.stats).additionalLooting;
    }

    public static class Stats
    extends RelicStats {
        public int additionalLooting = 1;
        public float petDamageMultiplier = 3.0f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class HunterBeltEvents {
        @SubscribeEvent
        public static void onLivingDamage(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            Entity entity = event.getSource().func_76346_g();
            if (!(entity instanceof TameableEntity)) {
                return;
            }
            TameableEntity pet = (TameableEntity)entity;
            if (!(pet.func_70902_q() instanceof PlayerEntity) && EntityUtils.findEquippedCurio((Entity)pet.func_70902_q(), (Item)ItemRegistry.HUNTER_BELT.get()).func_190926_b()) {
                return;
            }
            event.setAmount(event.getAmount() * stats.petDamageMultiplier);
        }
    }
}

