/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.renderer.items.models.EndersHandModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class EndersHandItem
extends RelicItem<Stats> {
    public static final String TAG_UPDATE_TIME = "time";

    public EndersHandItem() {
        super(RelicData.builder().rarity(Rarity.RARE).hasAbility().build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#00c98f", "#027f44").ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_228046_af_).build()).ability(AbilityTooltip.builder().active().build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        if (player.func_225608_bj_()) {
            Predicate<Entity> predicate = entity -> !entity.func_175149_v() && entity.func_70067_L();
            EntityRayTraceResult result = EntityUtils.rayTraceEntity((Entity)player, predicate, ((Stats)this.stats).maxDistance);
            if (result != null && result.func_216348_a() instanceof EndermanEntity) {
                if (time >= ((Stats)this.stats).preparationTime * 20) {
                    Vector3d swapVec = player.func_213303_ch();
                    EndermanEntity enderman = (EndermanEntity)result.func_216348_a();
                    World world = player.func_130014_f_();
                    player.func_70634_a(enderman.func_226277_ct_(), enderman.func_226278_cu_(), enderman.func_226281_cx_());
                    world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    enderman.func_70634_a(swapVec.func_82615_a(), swapVec.func_82617_b(), swapVec.func_82616_c());
                    world.func_184148_a(null, swapVec.func_82615_a(), swapVec.func_82617_b(), swapVec.func_82616_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                    player.func_184811_cZ().func_185145_a(stack.func_77973_b(), ((Stats)this.stats).cooldown * 20);
                } else {
                    NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
                }
            } else if (time > 0) {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, time - 1);
            }
        } else if (time > 0) {
            NBTUtils.setInt(stack, TAG_UPDATE_TIME, time - 1);
        }
    }

    @Override
    public void castAbility(PlayerEntity player, ItemStack stack) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((windowId, playerInv, playerEntity) -> ChestContainer.func_216992_a((int)windowId, (PlayerInventory)playerInv, (IInventory)playerEntity.func_71005_bN()), stack.func_151000_E()));
        player.func_184185_a(SoundEvents.field_187520_aJ, 1.0f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new EndersHandModel();
    }

    public static class Stats
    extends RelicStats {
        public int preparationTime = 1;
        public int maxDistance = 64;
        public int cooldown = 0;
    }

    @Mod.EventBusSubscriber(modid="relics", value={Dist.CLIENT})
    public static class EndersHandClientEvents {
        @SubscribeEvent
        public static void onFOVUpdate(FOVUpdateEvent event) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.ENDERS_HAND.get());
            if (stack.func_190926_b()) {
                return;
            }
            int time = NBTUtils.getInt(stack, EndersHandItem.TAG_UPDATE_TIME, 0);
            if (time > 0) {
                event.setNewfov(event.getNewfov() - (float)time / 32.0f);
            }
        }
    }
}

