/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.renderer.items.models.RageGloveModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

public class RageGloveItem
extends RelicItem<Stats> {
    public static final String TAG_STACKS_AMOUNT = "stacks";
    public static final String TAG_UPDATE_TIME = "time";
    public static RageGloveItem INSTANCE;

    public RageGloveItem() {
        super(RelicData.builder().rarity(Rarity.RARE).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#ffa90c", "#ff0606").ability(AbilityTooltip.builder().arg("+" + (int)(((Stats)this.stats).dealtDamageMultiplier * 100.0f) + "%").arg("+" + (int)(((Stats)this.stats).incomingDamageMultiplier * 100.0f) + "%").arg(((Stats)this.stats).stackDuration).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        int stacks = NBTUtils.getInt(stack, TAG_STACKS_AMOUNT, 0);
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
        if (DurabilityUtils.isBroken(stack) || livingEntity.field_70173_aa % 20 != 0 || stacks <= 0) {
            return;
        }
        if (time > 0) {
            NBTUtils.setInt(stack, TAG_UPDATE_TIME, time - 1);
        } else {
            NBTUtils.setInt(stack, TAG_STACKS_AMOUNT, 0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new RageGloveModel();
    }

    public static class Stats
    extends RelicStats {
        public int stackDuration = 3;
        public float dealtDamageMultiplier = 0.075f;
        public float incomingDamageMultiplier = 0.025f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class RageGloveEvents {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            Entity source = event.getSource().func_76346_g();
            if (!(source instanceof LivingEntity)) {
                return;
            }
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), (LivingEntity)source).ifPresent(triple -> {
                ItemStack stack = (ItemStack)triple.getRight();
                if (DurabilityUtils.isBroken(stack)) {
                    return;
                }
                int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 0);
                NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, ++stacks);
                NBTUtils.setInt(stack, RageGloveItem.TAG_UPDATE_TIME, stats.stackDuration);
                event.setAmount(event.getAmount() + event.getAmount() * ((float)stacks * stats.dealtDamageMultiplier));
            });
            CuriosApi.getCuriosHelper().findEquippedCurio((Item)ItemRegistry.RAGE_GLOVE.get(), event.getEntityLiving()).ifPresent(triple -> {
                ItemStack stack = (ItemStack)triple.getRight();
                if (DurabilityUtils.isBroken(stack)) {
                    return;
                }
                int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS_AMOUNT, 0);
                if (stacks <= 0) {
                    return;
                }
                event.setAmount(event.getAmount() + event.getAmount() * ((float)stacks * stats.incomingDamageMultiplier));
            });
        }
    }
}

