/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.renderer.items.models.WoolMittenModel;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WoolMittenItem
extends RelicItem<Stats> {
    private static WoolMittenItem INSTANCE;

    public WoolMittenItem() {
        super(RelicData.builder().rarity(Rarity.COMMON).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#db9d74", "#634733").ability(AbilityTooltip.builder().arg((int)((Stats)this.stats).minDamage).arg((int)((Stats)this.stats).damagePerSecond).build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<LivingEntity> getModel() {
        return new WoolMittenModel();
    }

    public static class Stats
    extends RelicStats {
        public float minDamage = 1.0f;
        public float damagePerSecond = 1.0f;
    }

    @Mod.EventBusSubscriber
    public static class WoolMittenEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            Entity source = event.getSource().func_76364_f();
            if (!(source instanceof SnowballEntity)) {
                return;
            }
            SnowballEntity snowball = (SnowballEntity)source;
            if (!(snowball.func_234616_v_() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)snowball.func_234616_v_();
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.WOOL_MITTEN.get()).func_190926_b()) {
                return;
            }
            event.setAmount(event.getAmount() + stats.minDamage + (float)snowball.field_70173_aa / 20.0f * stats.damagePerSecond);
        }
    }
}

