/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class BlazingFlaskItem
extends RelicItem<Stats> {
    public static final String TAG_FIRE_AMOUNT = "fire";

    public BlazingFlaskItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#e09614", "#302a44").ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().build()).ability(AbilityTooltip.builder().active(Minecraft.func_71410_x().field_71474_y.field_74314_A.getKey().func_237520_d_().getString() + " x2").build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (fire <= 0) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.blazing_flask.tooltip_1", new Object[]{fire}));
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof PlayerEntity) || DurabilityUtils.isBroken(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        World world = player.func_130014_f_();
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (!player.func_175149_v() && !player.func_184812_l_()) {
            boolean bl = player.field_71075_bZ.field_75101_c = fire > 0;
            if (player.field_71075_bZ.field_75100_b) {
                this.handleIgnite(player);
                this.handleLevitation(player, stack);
            }
        }
        this.collectFire(player, stack);
        if (fire <= 0 || player.field_70173_aa % 20 != 0 || !world.func_175727_C(player.func_233580_cy_()) && !player.func_70090_H()) {
            return;
        }
        world.func_184133_a(player, player.func_233580_cy_(), SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f);
        NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, fire - 1);
    }

    protected double getGroundHeight(PlayerEntity player) {
        BlockRayTraceResult result = player.field_70170_p.func_217299_a(new RayTraceContext(player.func_213303_ch(), new Vector3d(player.func_226277_ct_(), player.func_226278_cu_() - 64.0, player.func_226281_cx_()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)player));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            return result.func_216347_e().func_82617_b();
        }
        return -player.func_130014_f_().func_217301_I();
    }

    protected void handleIgnite(PlayerEntity player) {
        World world = player.func_130014_f_();
        for (int i = 0; i < 3; ++i) {
            world.func_195594_a((IParticleData)(player.func_70090_H() ? ParticleTypes.field_197613_f : ParticleTypes.field_197594_E), player.func_226277_ct_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), 0.0, player.func_70090_H() ? 0.0 : -0.1, 0.0);
        }
        if (player.func_70090_H()) {
            return;
        }
        world.func_195594_a((IParticleData)(world.func_234923_W_() == World.field_234919_h_ ? ParticleTypes.field_239811_B_ : ParticleTypes.field_197631_x), player.func_226277_ct_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226278_cu_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), player.func_226281_cx_() + (double)(MathUtils.randomFloat(world.func_201674_k()) * 0.5f), 0.0, -0.25, 0.0);
        for (LivingEntity entity : world.func_217357_a(LivingEntity.class, player.func_174813_aQ().func_186662_g(0.5).func_72321_a(0.0, -this.getGroundHeight(player) - 1.0, 0.0))) {
            if (entity == player) continue;
            entity.func_70015_d(5);
        }
    }

    protected void handleLevitation(PlayerEntity player, ItemStack stack) {
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        double riseVelocity = 0.0;
        player.field_71075_bZ.field_75100_b = fire > 0;
        player.func_213317_d(player.func_213322_ci().func_216372_d((double)((Stats)this.stats).levitationSpeed, (double)((Stats)this.stats).levitationSpeed, (double)((Stats)this.stats).levitationSpeed));
        Vector3d motion = player.func_213322_ci();
        if (player.field_191988_bg > 0.0f) {
            player.func_213293_j(motion.func_82615_a() + new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c).func_72432_b().func_82615_a() * (double)0.025f, motion.func_82617_b(), motion.func_82616_c() + new Vector3d(player.func_70040_Z().field_72450_a, 0.0, player.func_70040_Z().field_72449_c).func_72432_b().func_82616_c() * (double)0.025f);
        }
        if (player.func_130014_f_().func_201670_d() && player instanceof ClientPlayerEntity && ((ClientPlayerEntity)player).field_71158_b.field_78901_c) {
            riseVelocity = 0.04;
        }
        if (!player.func_225608_bj_()) {
            player.func_213293_j(motion.func_82615_a(), riseVelocity * (this.getGroundHeight(player) - (player.func_226278_cu_() - (double)((Stats)this.stats).levitationHeight)), motion.func_82616_c());
        }
        if (player.func_226278_cu_() - (double)((Stats)this.stats).levitationHeight > this.getGroundHeight(player)) {
            if (motion.func_82617_b() > 0.0) {
                player.func_213293_j(motion.func_82615_a(), 0.0, motion.func_82616_c());
            }
            player.func_213293_j(motion.func_82615_a(), -Math.min(player.func_226278_cu_() - (double)((Stats)this.stats).levitationHeight - this.getGroundHeight(player), 2.0) / 8.0, motion.func_82616_c());
        }
        if (player.field_70173_aa % 20 == 0) {
            NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, fire - 1);
        }
    }

    protected void collectFire(PlayerEntity player, ItemStack stack) {
        World world = player.func_130014_f_();
        int fire = NBTUtils.getInt(stack, TAG_FIRE_AMOUNT, 0);
        if (player.func_175149_v() || fire >= ((Stats)this.stats).capacity) {
            return;
        }
        List positions = WorldUtils.getBlockSphere(player.func_233580_cy_(), ((Stats)this.stats).consumptionRadius).stream().filter(pos -> world.func_180495_p(pos).func_177230_c() instanceof AbstractFireBlock).collect(Collectors.toList());
        for (BlockPos pos2 : positions) {
            Vector3d blockVec = new Vector3d((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
            double distance = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_72438_d(blockVec);
            Vector3d direction = player.func_213303_ch().func_72441_c(0.0, 1.0, 0.0).func_178788_d(blockVec).func_72432_b();
            world.func_195594_a((IParticleData)new CircleTintData(world.func_180495_p(pos2).func_177230_c() instanceof SoulFireBlock ? new Color(0, 200, 255) : new Color(255, 122, 0), (float)(distance * (double)0.075f), (int)distance * 5, 0.95f, false), blockVec.func_82615_a(), blockVec.func_82617_b(), blockVec.func_82616_c(), direction.field_72450_a * (double)0.2f, direction.field_72448_b * (double)0.2f, direction.field_72449_c * (double)0.2f);
            if (player.field_70173_aa % ((Stats)this.stats).consumptionCooldown != 0) continue;
            world.func_184133_a(null, pos2, SoundEvents.field_187652_bv, SoundCategory.PLAYERS, 1.0f, 1.0f);
            NBTUtils.setInt(stack, TAG_FIRE_AMOUNT, Math.min(((Stats)this.stats).capacity, fire + positions.size()));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (!(slotContext.getWearer() instanceof PlayerEntity) || NBTUtils.getInt(newStack, TAG_FIRE_AMOUNT, 0) > 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)slotContext.getWearer();
        if (player.func_184812_l_() || player.func_175149_v()) {
            return;
        }
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        player.func_71016_p();
    }

    public static class Stats
    extends RelicStats {
        public float levitationHeight = 5.0f;
        public float levitationSpeed = 0.75f;
        public int consumptionCooldown = 20;
        public int consumptionRadius = 10;
        public int capacity = 100;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class BlazingFlaskServerEvents {
        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            DamageSource source = event.getSource();
            if (!(EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.BLAZING_FLASK.get()).func_190926_b() || source != DamageSource.field_76372_a && source != DamageSource.field_76370_b)) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityAttack(LivingAttackEvent event) {
            DamageSource source = event.getSource();
            if (!(EntityUtils.findEquippedCurio((Entity)event.getEntityLiving(), (Item)ItemRegistry.BLAZING_FLASK.get()).func_190926_b() || source != DamageSource.field_76372_a && source != DamageSource.field_76370_b)) {
                event.setCanceled(true);
            }
        }
    }
}

