/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSConfiguredFeatures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;

public final class BiomeDimensionAllowDisallow {
    public static final Map<ResourceLocation, List<Pattern>> DIMENSION_DISALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> DIMENSION_ALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> BIOME_ALLOW = new HashMap<ResourceLocation, List<Pattern>>();
    public static final Map<ResourceLocation, List<Pattern>> BIOME_DISALLOW = new HashMap<ResourceLocation, List<Pattern>>();

    private BiomeDimensionAllowDisallow() {
    }

    public static void setupAllowDisallowMaps() {
        RSStructures.RS_STRUCTURES.forEach((key, value) -> {
            ResourceLocation id = Registry.field_218361_B.func_177774_c(key);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        RSConfiguredFeatures.RS_DUNGEONS.forEach(configuredFeature -> {
            ResourceLocation id = WorldGenRegistries.field_243653_e.func_177774_c(configuredFeature);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        RSConfiguredFeatures.RS_WELLS.forEach(configuredFeature -> {
            ResourceLocation id = WorldGenRegistries.field_243653_e.func_177774_c(configuredFeature);
            DIMENSION_DISALLOW.put(id, new ArrayList());
            DIMENSION_ALLOW.put(id, new ArrayList());
            BIOME_ALLOW.put(id, new ArrayList());
            BIOME_DISALLOW.put(id, new ArrayList());
        });
        BiomeDimensionAllowDisallow.setupMap(DIMENSION_DISALLOW, RepurposedStructures.RSOmegaBiomeDimConfig.disallowedDimensions, "dimension disallow");
        BiomeDimensionAllowDisallow.setupMap(DIMENSION_ALLOW, RepurposedStructures.RSOmegaBiomeDimConfig.allowedDimensions, "dimension allow");
        BiomeDimensionAllowDisallow.setupMap(BIOME_DISALLOW, RepurposedStructures.RSOmegaBiomeDimConfig.disallowedBiomes, "biome disallow");
        BiomeDimensionAllowDisallow.setupMap(BIOME_ALLOW, RepurposedStructures.RSOmegaBiomeDimConfig.allowedBiomes, "biome allow");
    }

    private static void setupMap(Map<ResourceLocation, List<Pattern>> mapToFillWithPatterns, Map<String, String> configMap, String errorMsg) {
        for (Map.Entry<String, String> configMapEntry : configMap.entrySet()) {
            List<String> parsedValues = Arrays.stream(configMapEntry.getValue().split(",")).map(String::trim).collect(Collectors.toList());
            ResourceLocation worldgenObjectID = new ResourceLocation(configMapEntry.getKey());
            if (configMapEntry.getKey().equals("all")) {
                mapToFillWithPatterns.values().forEach(patternList -> parsedValues.forEach(pattern -> patternList.add(Pattern.compile(pattern))));
                continue;
            }
            if (mapToFillWithPatterns.containsKey(worldgenObjectID)) {
                parsedValues.forEach(patternList -> ((List)mapToFillWithPatterns.get(worldgenObjectID)).add(Pattern.compile(patternList)));
                continue;
            }
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Unknown key {} was found in the {} config. Skipping that entry...", (Object)worldgenObjectID, (Object)errorMsg);
        }
    }
}

