/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.OpenSimplex2F;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

public class NoiseReplaceWithPropertiesProcessor
extends StructureProcessor {
    public static final Codec<NoiseReplaceWithPropertiesProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.field_212618_g.fieldOf("input_block").forGetter(config -> config.inputBlock), (App)Registry.field_212618_g.fieldOf("output_block").forGetter(config -> config.outputBlock), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("threshold").forGetter(config -> Float.valueOf(config.threshold)), (App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale))).apply((Applicative)instance, instance.stable(NoiseReplaceWithPropertiesProcessor::new)));
    private final Block inputBlock;
    private final Block outputBlock;
    private final float threshold;
    private final float xzScale;
    private final float yScale;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public NoiseReplaceWithPropertiesProcessor(Block inputBlock, Block outputBlock, float threshold, float xzScale, float yScale) {
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.threshold = threshold;
        this.xzScale = xzScale;
        this.yScale = yScale;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public Template.BlockInfo func_230386_a_(IWorldReader worldReader, BlockPos pos, BlockPos pos2, Template.BlockInfo infoIn1, Template.BlockInfo infoIn2, PlacementSettings settings) {
        BlockPos worldPos;
        double noiseVal;
        this.setSeed(worldReader instanceof WorldGenRegion ? ((WorldGenRegion)worldReader).func_72905_C() : 0L);
        if (infoIn2.field_186243_b.func_177230_c() == this.inputBlock && (noiseVal = this.noiseGenerator.noise3_Classic((float)(worldPos = infoIn2.field_186242_a).func_177958_n() * this.xzScale, (float)worldPos.func_177956_o() * this.yScale, (float)worldPos.func_177952_p() * this.xzScale)) / 2.0 + 0.5 < (double)this.threshold) {
            BlockState newBlockState = this.outputBlock.func_176223_P();
            for (Property property : infoIn2.field_186243_b.func_235904_r_()) {
                if (!newBlockState.func_235901_b_(property)) continue;
                newBlockState = this.getStateWithProperty(newBlockState, infoIn2.field_186243_b, property);
            }
            return new Template.BlockInfo(infoIn2.field_186242_a, newBlockState, infoIn2.field_186244_c);
        }
        return infoIn2;
    }

    private <T extends Comparable<T>> BlockState getStateWithProperty(BlockState state, BlockState stateToCopy, Property<T> property) {
        return (BlockState)state.func_206870_a(property, stateToCopy.func_177229_b(property));
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return RSProcessors.NOISE_REPLACE_WITH_PROPERTIES_PROCESSOR;
    }
}

