/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedDistanceJigsawStructure;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.util.Lazy;

public class StrongholdEndStructure
extends AdvancedDistanceJigsawStructure {
    public StrongholdEndStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int biomeRange, Lazy<Integer> maxY, Lazy<Integer> minY, boolean clipOutOfBoundsPieces, Lazy<Integer> verticalRange, int distanceFromWorldOrigin) {
        super(poolID, structureSize, biomeRange, maxY, minY, clipOutOfBoundsPieces, verticalRange, distanceFromWorldOrigin);
    }

    @Override
    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        boolean superCheck = super.isFeatureChunk(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        if (!superCheck) {
            return false;
        }
        int minLandHeight = Math.min(chunkGenerator.func_230355_e_(), 45);
        int xPos = chunkX * 16;
        int zPos = chunkZ * 16;
        int landHeight = Integer.MAX_VALUE;
        for (int i = 2; i >= 1; --i) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Vector3f offsetPos = new Vector3f((float)direction.func_82601_c(), 0.0f, (float)direction.func_82599_e());
                landHeight = this.getHeightAt(chunkGenerator, xPos + (int)(offsetPos = new Vector3f(offsetPos.func_195899_a() * 35.0f * (float)i, 0.0f, offsetPos.func_195902_c() * 35.0f * (float)i)).func_195899_a(), zPos + (int)offsetPos.func_195902_c(), landHeight);
                if (landHeight >= minLandHeight) continue;
                return false;
            }
        }
        return (landHeight = this.getHeightAt(chunkGenerator, xPos, zPos, landHeight)) >= minLandHeight;
    }

    private int getHeightAt(ChunkGenerator chunkGenerator, int xPos, int zPos, int landHeight) {
        landHeight = Math.min(landHeight, chunkGenerator.func_222531_c(xPos, zPos, Heightmap.Type.WORLD_SURFACE_WG));
        return landHeight;
    }

    public static class Builder<T extends Builder<T>>
    extends AdvancedDistanceJigsawStructure.Builder<T> {
        public Builder(ResourceLocation startPool) {
            super(startPool);
        }

        @Override
        public StrongholdEndStructure build() {
            return new StrongholdEndStructure(this.startPool, (Lazy<Integer>)this.structureSize, this.biomeRange, (Lazy<Integer>)this.maxY, (Lazy<Integer>)this.minY, this.clipOutOfBoundsPieces, (Lazy<Integer>)this.verticalRange, this.distanceFromWorldOrigin);
        }
    }
}

