/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.structures.JigsawPatternAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SingleJigsawPieceAccessor;
import com.telepathicgrunt.repurposedstructures.utils.BoxOctree;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.JigsawBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.EmptyJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static void assembleJigsawStructure(DynamicRegistries dynamicRegistries, VillageConfig jigsawConfig, ChunkGenerator chunkGenerator, TemplateManager templateManager, BlockPos startPos, List<? super StructurePiece> components, Random random, boolean doBoundaryAdjustments, boolean useHeightmap, ResourceLocation structureID, int maxY, int minY) {
        MutableRegistry jigsawPoolRegistry = dynamicRegistries.func_243612_b(Registry.field_243555_ax);
        Rotation rotation = Rotation.func_222466_a((Random)random);
        JigsawPattern startPool = (JigsawPattern)jigsawConfig.func_242810_c().get();
        if (startPool == null || startPool.func_214946_c() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent start pool: {}  Crash is imminent", startPool == null ? structureID : startPool.func_214947_b() + " - " + structureID);
        }
        JigsawPiece startPieceBlueprint = startPool.func_214944_a(random);
        AbstractVillagePiece startPiece = new AbstractVillagePiece(templateManager, startPieceBlueprint, startPos, startPieceBlueprint.func_214850_d(), rotation, startPieceBlueprint.func_214852_a(templateManager, startPos, rotation));
        MutableBoundingBox pieceBoundingBox = startPiece.func_74874_b();
        int pieceCenterX = (pieceBoundingBox.field_78893_d + pieceBoundingBox.field_78897_a) / 2;
        int pieceCenterZ = (pieceBoundingBox.field_78892_f + pieceBoundingBox.field_78896_c) / 2;
        int pieceCenterY = useHeightmap ? startPos.func_177956_o() + chunkGenerator.func_222532_b(pieceCenterX, pieceCenterZ, Heightmap.Type.WORLD_SURFACE_WG) : startPos.func_177956_o();
        int yAdjustment = pieceBoundingBox.field_78895_b + startPiece.func_214830_d();
        startPiece.func_181138_a(0, pieceCenterY - yAdjustment, 0);
        Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces = StructurePiecesBehavior.REQUIRED_PIECES_COUNT.get(structureID);
        boolean runOnce = requiredPieces == null;
        int attempts = 0;
        while (runOnce || PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces)) {
            if (attempts == 100) {
                RepurposedStructures.LOGGER.error("\n-------------------------------------------------------------------\nRepurposed Structures: Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces are: {}\n  Make sure the max height and min height for this structure in the config is not too close together.\n  If min and max height is super close together, the structure's pieces may not be able to fit in the narrow range and spawn.\n  Otherwise, if the min and max height ranges aren't close and this message still appears, please report the issue to Repurposed Structures's dev with latest.log file!\n\n", (Object)startPool.func_214947_b(), (Object)Arrays.toString(requiredPieces.keySet().toArray()));
                break;
            }
            components.clear();
            components.add((StructurePiece)startPiece);
            if (jigsawConfig.func_236534_a_() > 0) {
                AxisAlignedBB axisAlignedBB = new AxisAlignedBB((double)(pieceCenterX - 80), (double)(pieceCenterY - 120), (double)(pieceCenterZ - 80), (double)(pieceCenterX + 80 + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + 80 + 1));
                BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                boxOctree.addBox(AxisAlignedBB.func_216363_a((MutableBoundingBox)pieceBoundingBox));
                Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), pieceCenterY + 80, 0);
                Assembler assembler = new Assembler((Registry<JigsawPattern>)jigsawPoolRegistry, jigsawConfig.func_236534_a_(), chunkGenerator, templateManager, components, random, requiredPieces, maxY, minY);
                assembler.availablePieces.addLast(startPieceEntry);
                while (!assembler.availablePieces.isEmpty()) {
                    Entry entry = assembler.availablePieces.removeFirst();
                    assembler.generatePiece(entry.piece, entry.parentBoxOctree, entry.topYLimit, entry.depth, doBoundaryAdjustments);
                }
            }
            if (runOnce) break;
            ++attempts;
        }
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? super StructurePiece> components, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces) {
        HashMap<ResourceLocation, Integer> counter = new HashMap<ResourceLocation, Integer>();
        requiredPieces.forEach((key, value) -> counter.put((ResourceLocation)key, value.getRequiredAmount()));
        for (StructurePiece structurePiece : components) {
            ResourceLocation pieceID;
            JigsawPiece poolElement;
            if (!(structurePiece instanceof AbstractVillagePiece) || !((poolElement = ((AbstractVillagePiece)structurePiece).func_214826_b()) instanceof SingleJigsawPiece) || !counter.containsKey(pieceID = (ResourceLocation)((SingleJigsawPieceAccessor)poolElement).getTemplate().left().orElse(null))) continue;
            counter.put(pieceID, (Integer)counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public static final class Entry {
        public final AbstractVillagePiece piece;
        public final MutableObject<BoxOctree> parentBoxOctree;
        public final int topYLimit;
        public final int depth;

        public Entry(AbstractVillagePiece piece, MutableObject<BoxOctree> parentBoxOctree, int topYLimit, int depth) {
            this.piece = piece;
            this.parentBoxOctree = parentBoxOctree;
            this.topYLimit = topYLimit;
            this.depth = depth;
        }
    }

    public static final class Assembler {
        private final Registry<JigsawPattern> poolRegistry;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final TemplateManager templateManager;
        private final List<? super AbstractVillagePiece> structurePieces;
        private final Random rand;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<ResourceLocation, Integer> pieceCounts;
        private final Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;

        public Assembler(Registry<JigsawPattern> poolRegistry, int maxDepth, ChunkGenerator chunkGenerator, TemplateManager templateManager, List<? super AbstractVillagePiece> structurePieces, Random rand, Map<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.templateManager = templateManager;
            this.structurePieces = structurePieces;
            this.rand = rand;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = requiredPieces == null ? new HashMap<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>() : new HashMap<ResourceLocation, StructurePiecesBehavior.RequiredPieceNeeds>(requiredPieces);
            this.pieceCounts = new HashMap<ResourceLocation, Integer>(StructurePiecesBehavior.PIECES_COUNT);
            this.requiredPieces.forEach((key, value) -> this.pieceCounts.putIfAbsent((ResourceLocation)key, value.getRequiredAmount()));
        }

        public void generatePiece(AbstractVillagePiece piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments) {
            JigsawPiece pieceBlueprint = piece.func_214826_b();
            BlockPos piecePos = piece.func_214828_c();
            Rotation pieceRotation = piece.func_214809_Y_();
            MutableBoundingBox pieceBoundingBox = piece.func_74874_b();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            int pieceMinY = pieceBoundingBox.field_78895_b;
            List pieceJigsawBlocks = pieceBlueprint.func_214849_a(this.templateManager, piecePos, pieceRotation, this.rand);
            for (Template.BlockInfo jigsawBlock : pieceJigsawBlocks) {
                JigsawPiece generatedPiece;
                MutableObject<BoxOctree> octreeToUse;
                int targetPieceBoundsTop;
                Direction direction = JigsawBlock.func_235508_h_((BlockState)jigsawBlock.field_186243_b);
                BlockPos jigsawBlockPos = jigsawBlock.field_186242_a;
                BlockPos jigsawBlockTargetPos = jigsawBlockPos.func_177972_a(direction);
                ResourceLocation jigsawBlockPool = new ResourceLocation(jigsawBlock.field_186244_c.func_74779_i("pool"));
                Optional poolOptional = this.poolRegistry.func_241873_b(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((JigsawPattern)poolOptional.get()).func_214946_c() == 0 && !Objects.equals(jigsawBlockPool, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof SingleJigsawPiece ? ((SingleJigsawPieceAccessor)pieceBlueprint).getTemplate().left().get() : "not a SingleJigsawPiece class");
                    continue;
                }
                ResourceLocation jigsawBlockFallback = ((JigsawPattern)poolOptional.get()).func_214948_a();
                Optional fallbackOptional = this.poolRegistry.func_241873_b(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((JigsawPattern)fallbackOptional.get()).func_214946_c() == 0 && !Objects.equals(jigsawBlockFallback, JigsawPatternRegistry.field_244091_a.func_240901_a_())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockFallback, pieceBlueprint instanceof SingleJigsawPiece ? ((SingleJigsawPieceAccessor)pieceBlueprint).getTemplate().left().get() : "not a SingleJigsawPiece class");
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.func_175898_b((Vector3i)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    targetPieceBoundsTop = pieceMinY;
                    octreeToUse = parentOctree;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(AxisAlignedBB.func_216363_a((MutableBoundingBox)pieceBoundingBox)));
                    }
                } else {
                    targetPieceBoundsTop = minY;
                    octreeToUse = boxOctree;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<JigsawPiece, Integer>>(((JigsawPatternAccessor)poolOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop)) != null) continue;
                this.processList(new ArrayList<Pair<JigsawPiece, Integer>>(((JigsawPatternAccessor)fallbackOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop);
            }
        }

        private JigsawPiece processList(List<Pair<JigsawPiece, Integer>> candidatePieces, boolean doBoundaryAdjustments, Template.BlockInfo jigsawBlock, BlockPos jigsawBlockTargetPos, int pieceMinY, BlockPos jigsawBlockPos, MutableObject<BoxOctree> mutableObjectBoxOctree, AbstractVillagePiece piece, int depth, int targetPieceBoundsTop) {
            JigsawPattern.PlacementBehaviour piecePlacementBehavior = piece.func_214826_b().func_214854_c();
            boolean isPieceRigid = piecePlacementBehavior == JigsawPattern.PlacementBehaviour.RIGID;
            int jigsawBlockRelativeY = jigsawBlockPos.func_177956_o() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                JigsawPiece candidatePiece;
                Object chosenPiecePair = null;
                Optional<ResourceLocation> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.pieceCounts.get(key);
                    StructurePiecesBehavior.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    int startCount = StructurePiecesBehavior.PIECES_COUNT.getOrDefault(key, requireCount);
                    return currentCount > 0 && startCount - currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<JigsawPiece, Integer> candidatePiecePair = candidatePieces.get(i);
                        JigsawPiece jigsawPiece = (JigsawPiece)candidatePiecePair.getFirst();
                        if (!(jigsawPiece instanceof SingleJigsawPiece) || !((ResourceLocation)((SingleJigsawPieceAccessor)jigsawPiece).getTemplate().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter()) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (JigsawPiece)chosenPiecePair.getFirst()) == EmptyJigsawPiece.field_214856_a) {
                    return null;
                }
                ResourceLocation pieceName = null;
                if (candidatePiece instanceof SingleJigsawPiece && this.pieceCounts.containsKey(pieceName = (ResourceLocation)((SingleJigsawPieceAccessor)candidatePiece).getTemplate().left().get()) && this.pieceCounts.get(pieceName) <= 0) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (Rotation rotation : Rotation.func_222467_b((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.func_214849_a(this.templateManager, BlockPos.field_177992_a, rotation, this.rand);
                    MutableBoundingBox tempCandidateBoundingBox = candidatePiece.func_214852_a(this.templateManager, BlockPos.field_177992_a, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.func_78882_c() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.func_175898_b((Vector3i)pieceCandidateJigsawBlock.field_186242_a.func_177972_a(JigsawBlock.func_235508_h_((BlockState)pieceCandidateJigsawBlock.field_186243_b)))) {
                            return 0;
                        }
                        ResourceLocation candidateTargetPool = new ResourceLocation(pieceCandidateJigsawBlock.field_186244_c.func_74779_i("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.func_241873_b(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.poolRegistry.func_241873_b(p_242843_1_.func_214948_a()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.func_214945_a(this.templateManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.func_214945_a(this.templateManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (Template.BlockInfo candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!JigsawBlock.func_220171_a((Template.BlockInfo)jigsawBlock, (Template.BlockInfo)candidateJigsawBlock)) continue;
                        BlockPos candidateJigsawBlockPos = candidateJigsawBlock.field_186242_a;
                        BlockPos candidateJigsawBlockRelativePos = new BlockPos(jigsawBlockTargetPos.func_177958_n() - candidateJigsawBlockPos.func_177958_n(), jigsawBlockTargetPos.func_177956_o() - candidateJigsawBlockPos.func_177956_o(), jigsawBlockTargetPos.func_177952_p() - candidateJigsawBlockPos.func_177952_p());
                        MutableBoundingBox candidateBoundingBox = candidatePiece.func_214852_a(this.templateManager, candidateJigsawBlockRelativePos, rotation);
                        JigsawPattern.PlacementBehaviour candidatePlacementBehavior = candidatePiece.func_214854_c();
                        boolean isCandidateRigid = candidatePlacementBehavior == JigsawPattern.PlacementBehaviour.RIGID;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.func_177956_o();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + JigsawBlock.func_235508_h_((BlockState)jigsawBlock.field_186243_b).func_96559_d();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.func_222532_b(jigsawBlockPos.func_177958_n(), jigsawBlockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.field_78895_b;
                        MutableBoundingBox adjustedCandidateBoundingBox = candidateBoundingBox.func_215127_b(0, candidatePieceYOffsetNeeded, 0);
                        BlockPos adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.func_177982_a(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int heightAdjustement = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.field_78894_e - adjustedCandidateBoundingBox.field_78895_b);
                            adjustedCandidateBoundingBox.field_78894_e = adjustedCandidateBoundingBox.field_78895_b + heightAdjustement;
                        }
                        if (adjustedCandidateBoundingBox.field_78894_e > this.maxY || adjustedCandidateBoundingBox.field_78895_b < this.minY) continue;
                        AxisAlignedBB axisAlignedBB = AxisAlignedBB.func_216363_a((MutableBoundingBox)adjustedCandidateBoundingBox);
                        AxisAlignedBB axisAlignedBBDeflated = axisAlignedBB.func_186664_h(0.25);
                        if (!((BoxOctree)mutableObjectBoxOctree.getValue()).boundaryContains(axisAlignedBBDeflated) || ((BoxOctree)mutableObjectBoxOctree.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) continue;
                        ((BoxOctree)mutableObjectBoxOctree.getValue()).addBox(axisAlignedBB);
                        int newPieceGroundLevelDelta = piece.func_214830_d();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.func_214850_d();
                        AbstractVillagePiece newPiece = new AbstractVillagePiece(this.templateManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.func_222532_b(jigsawBlockPos.func_177958_n(), jigsawBlockPos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.func_214831_a(new JigsawJunction(jigsawBlockTargetPos.func_177958_n(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.func_177952_p(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.func_214831_a(new JigsawJunction(jigsawBlockPos.func_177958_n(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.func_177952_p(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((AbstractVillagePiece)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, mutableObjectBoxOctree, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.pieceCounts.containsKey(pieceName)) {
                            this.pieceCounts.put(pieceName, this.pieceCounts.get(pieceName) - 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

