/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.DynamicTreesHandler;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="snowundertrees")
public class WorldTickHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START && event.world.func_72896_J() && ((Boolean)Configuration.CONFIG.enableWhenSnowing.get()).booleanValue()) {
                ServerWorld world = (ServerWorld)event.world;
                world.func_72863_F().field_217237_a.func_223491_f().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                    if (optional.isPresent() && world.field_73012_v.nextInt(16) == 0) {
                        Chunk chunk = (Chunk)optional.get();
                        ChunkPos chunkPos = chunk.func_76632_l();
                        int chunkX = chunkPos.func_180334_c();
                        int chunkY = chunkPos.func_180333_d();
                        BlockPos randomPos = world.func_217383_a(chunkX, 0, chunkY, 15);
                        Biome biome = world.func_226691_t_(randomPos);
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome).toString());
                        if (!biomeDisabled && world.func_180495_p(world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, randomPos).func_177977_b()).func_235714_a_((ITag)BlockTags.field_206952_E)) {
                            BlockPos downPos;
                            BlockState stateBelow;
                            BlockPos pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, randomPos);
                            if (SnowUnderTrees.isDynamicTreesLoaded()) {
                                pos = DynamicTreesHandler.findGround((IWorld)world, pos.func_239590_i_());
                            }
                            if (SnowUnderTrees.placeSnow((IWorld)world, pos) && (stateBelow = world.func_180495_p(downPos = pos.func_177977_b())).func_224755_d((IBlockReader)world, downPos, Direction.UP) && stateBelow.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
                                world.func_180501_a(downPos, (BlockState)stateBelow.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    }
                });
            } else if (event.phase == TickEvent.Phase.END && SnowUnderTrees.isSereneSeasonsLoaded()) {
                SereneSeasonsHandler.tryMeltSnowUnderTrees(event);
            }
        }
    }
}

