/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.worldgen.jigsaw;

import com.legacy.structure_gel.worldgen.jigsaw.JigsawPoolBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;

public class JigsawRegistryHelper {
    public final String modid;
    public final String prefix;

    public JigsawRegistryHelper(String modid) {
        this(modid, "");
    }

    public JigsawRegistryHelper(String modid, String prefix) {
        this.modid = modid;
        this.prefix = prefix;
    }

    public JigsawRegistryHelper setModID(String modid) {
        return new JigsawRegistryHelper(modid, this.prefix);
    }

    public JigsawRegistryHelper setPrefix(String prefix) {
        return new JigsawRegistryHelper(this.modid, prefix);
    }

    public JigsawPoolBuilder builder() {
        return new JigsawPoolBuilder(this);
    }

    public JigsawPattern register(String poolName, String fallback, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool, JigsawPattern.PlacementBehaviour placement) {
        return JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(this.locatePiece(poolName), this.locatePiece(fallback), pool, placement));
    }

    public JigsawPattern register(String poolName, String fallback, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool) {
        return this.register(poolName, fallback, pool, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public JigsawPattern register(String poolName, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool, JigsawPattern.PlacementBehaviour placement) {
        return this.register(this.locatePiece(poolName), new ResourceLocation("empty"), pool, placement);
    }

    public JigsawPattern register(String poolName, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool) {
        return this.register(poolName, pool, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public JigsawPattern register(ResourceLocation poolName, ResourceLocation fallback, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool, JigsawPattern.PlacementBehaviour placement) {
        return JigsawPatternRegistry.func_244094_a((JigsawPattern)new JigsawPattern(poolName, fallback, pool, placement));
    }

    public JigsawPattern register(ResourceLocation poolName, ResourceLocation fallback, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool) {
        return this.register(poolName, fallback, pool, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public JigsawPattern register(ResourceLocation poolName, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool, JigsawPattern.PlacementBehaviour placement) {
        return this.register(poolName, new ResourceLocation("empty"), pool, placement);
    }

    public JigsawPattern register(ResourceLocation poolName, List<Pair<Function<JigsawPattern.PlacementBehaviour, ? extends JigsawPiece>, Integer>> pool) {
        return this.register(poolName, pool, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public ResourceLocation locatePiece(String key) {
        return new ResourceLocation(this.modid, this.prefix + key);
    }
}

