/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.monster.BlitzEntity;
import cofh.thermal.core.entity.projectile.ElementalProjectileEntity;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BasalzProjectileEntity
extends ElementalProjectileEntity {
    public static float defaultDamage = 6.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;
    public static float knockbackStrength = 1.2f;

    public BasalzProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public BasalzProjectileEntity(LivingEntity shooter, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BasalzProjectileEntity(double x, double y, double z, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BASALZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_218423_k;
    }

    public void func_70227_a(RayTraceResult result) {
        Entity entity;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)result).func_216348_a()).func_70097_a(BasalzDamageSource.causeDamage(this, this.func_234616_v_()), this.getDamage(entity)) && !entity.func_190530_aW() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(CoreReferences.SUNDERED, this.getEffectDuration(entity), this.getEffectAmplifier(entity), false, false));
            Vector3d velocity = this.func_213322_ci();
            if (velocity.func_189985_c() > 0.01) {
                living.func_233627_a_(knockbackStrength, -velocity.field_72450_a, -velocity.field_72449_c);
            }
        }
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            this.func_70106_y();
        }
    }

    @Override
    public float getDamage(Entity target) {
        return target instanceof BlitzEntity ? defaultDamage + 3.0f : defaultDamage;
    }

    @Override
    public int getEffectAmplifier(Entity target) {
        return effectAmplifier;
    }

    @Override
    public int getEffectDuration(Entity target) {
        return effectDuration;
    }

    protected static class BasalzDamageSource
    extends EntityDamageSource {
        public BasalzDamageSource(Entity source) {
            super("basalz", source);
        }

        public static DamageSource causeDamage(BasalzProjectileEntity entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("basalz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).func_76349_b();
        }
    }
}

