/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import twilightforest.TwilightForestMod;
import twilightforest.block.AuroraBrickBlock;
import twilightforest.block.TFBlocks;
import twilightforest.compat.ie.TFShaderItem;
import twilightforest.item.ArcticArmorItem;
import twilightforest.item.TFItems;

@Mod.EventBusSubscriber(modid="twilightforest", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ColorHandler {
    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : Color.HSBtoRGB(worldIn == null ? 0.45f : AuroraBrickBlock.rippleFractialNoise(2, 128.0f, pos != null ? pos.func_177981_b(128) : new BlockPos(0, 0, 0), 0.37f, 0.67f, 1.5f), 1.0f, 1.0f), new Block[]{(Block)TFBlocks.aurora_block.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int normalColor = blockColors.func_228054_a_(((Block)TFBlocks.aurora_block.get()).func_176223_P(), worldIn, pos, tintIndex);
            int red = normalColor >> 16 & 0xFF;
            int blue = normalColor & 0xFF;
            int green = normalColor >> 8 & 0xFF;
            float[] hsb = Color.RGBtoHSB(red, blue, green, null);
            return Color.HSBtoRGB(hsb[0], hsb[1] * 0.5f, Math.min(hsb[2] + 0.4f, 0.9f));
        }, new Block[]{(Block)TFBlocks.aurora_pillar.get(), (Block)TFBlocks.aurora_slab.get(), (Block)TFBlocks.auroralized_glass.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return FoliageColors.func_77468_c();
            }
            int red = 0;
            int grn = 0;
            int blu = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int i2 = BiomeColors.func_228361_b_((IBlockDisplayReader)worldIn, (BlockPos)pos.func_177982_a(dx, 0, dz));
                    red += (i2 & 0xFF0000) >> 16;
                    grn += (i2 & 0xFF00) >> 8;
                    blu += i2 & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
        }, new Block[]{(Block)TFBlocks.dark_leaves.get(), (Block)TFBlocks.giant_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : blockColors.func_228054_a_(Blocks.field_150349_c.func_176223_P(), worldIn, pos, tintIndex), new Block[]{(Block)TFBlocks.smoker.get(), (Block)TFBlocks.fire_jet.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? 2129968 : 7455580, new Block[]{(Block)TFBlocks.huge_lilypad.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return 6986775;
            }
            int fade = pos.func_177958_n() * 16 + pos.func_177956_o() * 16 + pos.func_177952_p() * 16;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 106.0f + fall * 251.0f);
            int green = (int)(spring * 156.0f + fall * 108.0f);
            int blue = (int)(spring * 23.0f + fall * 27.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.time_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return 7130346;
            }
            int fade = pos.func_177958_n() * 27 + pos.func_177956_o() * 63 + pos.func_177952_p() * 39;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 108.0f + fall * 96.0f);
            int green = (int)(spring * 204.0f + fall * 107.0f);
            int blue = (int)(spring * 234.0f + fall * 121.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.transformation_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return 16576836;
            }
            int fade = pos.func_177958_n() * 31 + pos.func_177956_o() * 33 + pos.func_177952_p() * 32;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 252.0f + fall * 237.0f);
            int green = (int)(spring * 241.0f + fall * 172.0f);
            int blue = (int)(spring * 68.0f + fall * 9.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.mining_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return 3558403;
            }
            int fade = pos.func_177958_n() * 63 + pos.func_177956_o() * 63 + pos.func_177952_p() * 63;
            if ((fade & 0x100) != 0) {
                fade = 255 - (fade & 0xFF);
            }
            float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
            float fall = (float)fade / 255.0f;
            int red = (int)(spring * 54.0f + fall * 168.0f);
            int green = (int)(spring * 76.0f + fall * 199.0f);
            int blue = (int)(spring * 3.0f + fall * 43.0f);
            return red << 16 | green << 8 | blue;
        }, new Block[]{(Block)TFBlocks.sorting_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return -1;
            }
            float f = AuroraBrickBlock.rippleFractialNoise(2, 32.0f, pos, 0.4f, 1.0f, 2.0f);
            return Color.HSBtoRGB(0.1f, 1.0f - f, (f + 2.0f) / 3.0f);
        }, new Block[]{(Block)TFBlocks.tower_wood.get(), (Block)TFBlocks.tower_wood_cracked.get(), (Block)TFBlocks.tower_wood_infested.get(), (Block)TFBlocks.tower_wood_mossy.get()});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 4764952;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
        }, new Block[]{(Block)TFBlocks.oak_leaves.get()});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 6330464;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
            return ((normalColor & 0xFEFEFE) + 4627046) / 2;
        }, new Block[]{(Block)TFBlocks.canopy_leaves.get()});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 8431445;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
            return ((normalColor & 0xFEFEFE) + 12641940) / 2;
        }, new Block[]{(Block)TFBlocks.mangrove_leaves.get()});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                return 4764952;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int color = BiomeColors.func_228361_b_((IBlockDisplayReader)world, (BlockPos)pos);
                    red += (color & 0xFF0000) >> 16;
                    green += (color & 0xFF00) >> 8;
                    blue += color & 0xFF;
                }
            }
            red = pos.func_177958_n() * 32 + pos.func_177956_o() * 16;
            if ((red & 0x100) != 0) {
                red = 255 - (red & 0xFF);
            }
            red &= 0xFF;
            blue = pos.func_177956_o() * 32 + pos.func_177952_p() * 16;
            if ((blue & 0x100) != 0) {
                blue = 255 - (blue & 0xFF);
            }
            blue ^= 0xFF;
            green = pos.func_177958_n() * 16 + pos.func_177952_p() * 32;
            if ((green & 0x100) != 0) {
                green = 255 - (green & 0xFF);
            }
            return red << 16 | blue << 8 | (green &= 0xFF);
        }, new Block[]{(Block)TFBlocks.rainboak_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> FoliageColors.func_77466_a(), new Block[]{(Block)TFBlocks.beanstalk_leaves.get(), (Block)TFBlocks.thorn_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            if (worldIn != null && pos != null) {
                return BiomeColors.func_228361_b_((IBlockDisplayReader)worldIn, (BlockPos)pos);
            }
            return FoliageColors.func_77468_c();
        }, new Block[]{(Block)TFBlocks.fallen_leaves.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return 0xFFFFFF;
            }
            if (worldIn != null && pos != null) {
                return BiomeColors.func_228358_a_((IBlockDisplayReader)worldIn, (BlockPos)pos);
            }
            return GrassColors.func_77480_a((double)0.5, (double)1.0);
        }, new Block[]{(Block)TFBlocks.fiddlehead.get(), (Block)TFBlocks.potted_fiddlehead.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{(Block)TFBlocks.twilight_portal_miniature_structure.get(), (Block)TFBlocks.naga_courtyard_miniature_structure.get(), (Block)TFBlocks.lich_tower_miniature_structure.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 0xFF00FF;
        }, new Block[]{(Block)TFBlocks.castle_rune_brick_pink.get(), (Block)TFBlocks.castle_door_pink.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 65535;
        }, new Block[]{(Block)TFBlocks.castle_rune_brick_blue.get(), (Block)TFBlocks.castle_door_blue.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 0xFFFF00;
        }, new Block[]{(Block)TFBlocks.castle_rune_brick_yellow.get(), (Block)TFBlocks.castle_door_yellow.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 4915330;
        }, new Block[]{(Block)TFBlocks.castle_rune_brick_purple.get(), (Block)TFBlocks.castle_door_purple.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 6033524;
        }, new Block[]{(Block)TFBlocks.force_field_purple.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 16385406;
        }, new Block[]{(Block)TFBlocks.force_field_pink.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 16734978;
        }, new Block[]{(Block)TFBlocks.force_field_orange.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 9037569;
        }, new Block[]{(Block)TFBlocks.force_field_green.get()});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            return 909055;
        }, new Block[]{(Block)TFBlocks.force_field_blue.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BlockColors blockColors = event.getBlockColors();
        itemColors.func_199877_a((stack, tintIndex) -> blockColors.func_228054_a_(((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P(), null, null, tintIndex), new IItemProvider[]{(IItemProvider)TFBlocks.aurora_block.get(), (IItemProvider)TFBlocks.aurora_pillar.get(), (IItemProvider)TFBlocks.aurora_slab.get(), (IItemProvider)TFBlocks.auroralized_glass.get(), (IItemProvider)TFBlocks.dark_leaves.get(), (IItemProvider)TFBlocks.giant_leaves.get(), (IItemProvider)TFBlocks.smoker.get(), (IItemProvider)TFBlocks.fire_jet.get(), (IItemProvider)TFBlocks.time_leaves.get(), (IItemProvider)TFBlocks.transformation_leaves.get(), (IItemProvider)TFBlocks.mining_leaves.get(), (IItemProvider)TFBlocks.sorting_leaves.get(), (IItemProvider)TFBlocks.oak_leaves.get(), (IItemProvider)TFBlocks.canopy_leaves.get(), (IItemProvider)TFBlocks.mangrove_leaves.get(), (IItemProvider)TFBlocks.rainboak_leaves.get(), (IItemProvider)TFBlocks.thorn_leaves.get(), (IItemProvider)TFBlocks.beanstalk_leaves.get(), (IItemProvider)TFBlocks.fallen_leaves.get(), (IItemProvider)TFBlocks.fiddlehead.get(), (IItemProvider)TFBlocks.potted_fiddlehead.get(), (IItemProvider)TFBlocks.castle_rune_brick_pink.get(), (IItemProvider)TFBlocks.castle_rune_brick_blue.get(), (IItemProvider)TFBlocks.castle_rune_brick_yellow.get(), (IItemProvider)TFBlocks.castle_rune_brick_purple.get(), (IItemProvider)TFBlocks.castle_door_yellow.get(), (IItemProvider)TFBlocks.castle_door_blue.get(), (IItemProvider)TFBlocks.castle_door_pink.get(), (IItemProvider)TFBlocks.castle_door_purple.get(), (IItemProvider)TFBlocks.force_field_pink.get(), (IItemProvider)TFBlocks.force_field_blue.get(), (IItemProvider)TFBlocks.force_field_green.get(), (IItemProvider)TFBlocks.force_field_orange.get(), (IItemProvider)TFBlocks.force_field_purple.get(), (IItemProvider)TFBlocks.huge_lilypad.get(), (IItemProvider)TFBlocks.twilight_portal_miniature_structure.get(), (IItemProvider)TFBlocks.naga_courtyard_miniature_structure.get(), (IItemProvider)TFBlocks.lich_tower_miniature_structure.get()});
        itemColors.func_199877_a((stack, tintIndex) -> stack.func_77973_b() instanceof ArcticArmorItem ? ((ArcticArmorItem)stack.func_77973_b()).getColor(stack, tintIndex) : 0xFFFFFF, new IItemProvider[]{(IItemProvider)TFItems.arctic_helmet.get(), (IItemProvider)TFItems.arctic_chestplate.get(), (IItemProvider)TFItems.arctic_leggings.get(), (IItemProvider)TFItems.arctic_boots.get()});
        if (ModList.get().isLoaded("immersiveengineering")) {
            itemColors.func_199877_a(TFShaderItem::getShaderColors, new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader"))});
            for (Rarity r : ShaderRegistry.rarityWeightMap.keySet()) {
                itemColors.func_199877_a((stack, tintIndex) -> {
                    int c = r.field_77937_e.func_211163_e();
                    float d = tintIndex + 1;
                    return (int)((float)(c >> 16 & 0xFF) / d) << 16 | (int)((float)(c >> 8 & 0xFF) / d) << 8 | (int)((float)(c & 0xFF) / d);
                }, new IItemProvider[]{(IItemProvider)ForgeRegistries.ITEMS.getValue(TwilightForestMod.prefix("shader_bag_" + r.name().toLowerCase(Locale.US).replace(':', '_')))});
            }
        }
    }

    private ColorHandler() {
    }
}

