/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings;

import java.util.function.BiConsumer;
import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.FlightDefault;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.net.Network;
import me.paulf.wings.server.net.clientbound.MessageSyncFlight;
import me.paulf.wings.server.potion.PotionMix;
import me.paulf.wings.util.SimpleStorage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public abstract class Proxy {
    protected final Network network = new Network();

    public void init(IEventBus modBus) {
        modBus.addListener(this::setup);
    }

    protected void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(Flight.class, SimpleStorage.ofVoid(), FlightDefault::new);
        CapabilityManager.INSTANCE.register(InSomniable.class, SimpleStorage.ofVoid(), InSomniable::new);
        event.enqueueWork(() -> {
            BiConsumer<IItemProvider, RegistryObject> reg = (item, obj) -> {
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionMix(Potions.field_204841_O, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), new ItemStack((IItemProvider)obj.get())));
                BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionMix(Potions.field_204842_P, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), new ItemStack((IItemProvider)obj.get())));
            };
            reg.accept((IItemProvider)Items.field_151008_G, WingsItems.ANGEL_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_222078_li, WingsItems.PARROT_WINGS_BOTTLE);
            reg.accept((IItemProvider)WingsItems.BAT_BLOOD_BOTTLE.get(), WingsItems.BAT_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_222083_lx, WingsItems.BLUE_BUTTERFLY_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_151116_aA, WingsItems.DRAGON_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_151103_aS, WingsItems.EVIL_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_221684_bd, WingsItems.FAIRY_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_151065_br, WingsItems.FIRE_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_196108_bd, WingsItems.MONARCH_BUTTERFLY_WINGS_BOTTLE);
            reg.accept((IItemProvider)Items.field_151123_aH, WingsItems.SLIME_WINGS_BOTTLE);
        });
    }

    public void addFlightListeners(PlayerEntity player, Flight instance) {
        if (player instanceof ServerPlayerEntity) {
            instance.registerFlyingListener(isFlying -> {
                player.field_71075_bZ.field_75101_c = isFlying;
            });
            instance.registerFlyingListener(isFlying -> {
                if (isFlying) {
                    player.func_233575_bb_();
                }
            });
            Flight.Notifier notifier = Flight.Notifier.of(() -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayerEntity)player), p -> this.network.sendToPlayer(new MessageSyncFlight(player, instance), (ServerPlayerEntity)p), () -> this.network.sendToAllTracking(new MessageSyncFlight(player, instance), (Entity)player));
            instance.registerSyncListener(players -> players.notify(notifier));
        }
    }
}

