/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings;

import com.mojang.serialization.Lifecycle;
import me.paulf.wings.Proxy;
import me.paulf.wings.client.ClientProxy;
import me.paulf.wings.server.ServerProxy;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.apparatus.SimpleFlightApparatus;
import me.paulf.wings.server.config.WingsItemsConfig;
import me.paulf.wings.server.effect.WingsEffects;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.sound.WingsSounds;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="wings")
public final class WingsMod {
    public static final String ID = "wings";
    private static WingsMod INSTANCE;
    public static final Registry<FlightApparatus> WINGS;
    public static final FlightApparatus NONE_WINGS;
    public static final FlightApparatus ANGEL_WINGS;
    public static final FlightApparatus PARROT_WINGS;
    public static final FlightApparatus BAT_WINGS;
    public static final FlightApparatus BLUE_BUTTERFLY_WINGS;
    public static final FlightApparatus DRAGON_WINGS;
    public static final FlightApparatus EVIL_WINGS;
    public static final FlightApparatus FAIRY_WINGS;
    public static final FlightApparatus MONARCH_BUTTERFLY_WINGS;
    public static final FlightApparatus SLIME_WINGS;
    public static final FlightApparatus FIRE_WINGS;
    private Proxy proxy;

    public WingsMod() {
        if (INSTANCE != null) {
            throw new IllegalStateException("Already constructed!");
        }
        INSTANCE = this;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        WingsItems.REG.register(bus);
        WingsSounds.REG.register(bus);
        WingsEffects.REG.register(bus);
        this.proxy = (Proxy)DistExecutor.safeRunForDist(() -> ProxyInit::createClient, () -> ProxyInit::createServer);
        this.proxy.init(bus);
    }

    public void addFlightListeners(PlayerEntity player, Flight instance) {
        this.requireProxy().addFlightListeners(player, instance);
    }

    public static WingsMod instance() {
        return INSTANCE;
    }

    private Proxy requireProxy() {
        if (this.proxy == null) {
            throw new IllegalStateException("Proxy not initialized");
        }
        return this.proxy;
    }

    static {
        WINGS = new DefaultedRegistry(Names.NONE.toString(), RegistryKey.func_240904_a_((ResourceLocation)new ResourceLocation(ID, ID)), Lifecycle.experimental());
        NONE_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.NONE, (Object)FlightApparatus.NONE);
        ANGEL_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.ANGEL, (Object)new SimpleFlightApparatus(WingsItemsConfig.ANGEL));
        PARROT_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.PARROT, (Object)new SimpleFlightApparatus(WingsItemsConfig.PARROT));
        BAT_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.BAT, (Object)new SimpleFlightApparatus(WingsItemsConfig.BAT));
        BLUE_BUTTERFLY_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.BLUE_BUTTERFLY, (Object)new SimpleFlightApparatus(WingsItemsConfig.BLUE_BUTTERFLY));
        DRAGON_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.DRAGON, (Object)new SimpleFlightApparatus(WingsItemsConfig.DRAGON));
        EVIL_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.EVIL, (Object)new SimpleFlightApparatus(WingsItemsConfig.EVIL));
        FAIRY_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.FAIRY, (Object)new SimpleFlightApparatus(WingsItemsConfig.FAIRY));
        MONARCH_BUTTERFLY_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.MONARCH_BUTTERFLY, (Object)new SimpleFlightApparatus(WingsItemsConfig.MONARCH_BUTTERFLY));
        SLIME_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.SLIME, (Object)new SimpleFlightApparatus(WingsItemsConfig.SLIME));
        FIRE_WINGS = (FlightApparatus)Registry.func_218322_a(WINGS, (ResourceLocation)Names.FIRE, (Object)new SimpleFlightApparatus(WingsItemsConfig.FIRE));
    }

    public static final class Names {
        public static final ResourceLocation NONE = Names.create("none");
        public static final ResourceLocation ANGEL = Names.create("angel_wings");
        public static final ResourceLocation PARROT = Names.create("parrot_wings");
        public static final ResourceLocation SLIME = Names.create("slime_wings");
        public static final ResourceLocation BLUE_BUTTERFLY = Names.create("blue_butterfly_wings");
        public static final ResourceLocation MONARCH_BUTTERFLY = Names.create("monarch_butterfly_wings");
        public static final ResourceLocation FIRE = Names.create("fire_wings");
        public static final ResourceLocation BAT = Names.create("bat_wings");
        public static final ResourceLocation FAIRY = Names.create("fairy_wings");
        public static final ResourceLocation EVIL = Names.create("evil_wings");
        public static final ResourceLocation DRAGON = Names.create("dragon_wings");

        private Names() {
        }

        private static ResourceLocation create(String path) {
            return new ResourceLocation(WingsMod.ID, path);
        }
    }

    static class ProxyInit {
        ProxyInit() {
        }

        static Proxy createClient() {
            return new ClientProxy();
        }

        static Proxy createServer() {
            return new ServerProxy();
        }
    }
}

