/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import me.paulf.wings.client.audio.WingsSound;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.FlightViews;
import me.paulf.wings.server.asm.AnimatePlayerModelEvent;
import me.paulf.wings.server.asm.ApplyPlayerRotationsEvent;
import me.paulf.wings.server.asm.EmptyOffHandPresentEvent;
import me.paulf.wings.server.asm.GetCameraEyeHeightEvent;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.util.Mth;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="wings")
public final class ClientEventHandler {
    private ClientEventHandler() {
    }

    @SubscribeEvent
    public static void onAnimatePlayerModel(AnimatePlayerModelEvent event) {
        PlayerEntity player = event.getPlayer();
        Flights.get(player).ifPresent(flight -> {
            float delta = event.getTicksExisted() - (float)player.field_70173_aa;
            float amt = flight.getFlyingAmount(delta);
            if (amt == 0.0f) {
                return;
            }
            PlayerModel<?> model = event.getModel();
            float pitch = event.getPitch();
            model.field_78116_c.field_78795_f = Mth.toRadians(Mth.lerp(pitch, pitch / 4.0f - 90.0f, amt));
            model.field_178724_i.field_78795_f = Mth.lerp(model.field_178724_i.field_78795_f, -3.2f, amt);
            model.field_178723_h.field_78795_f = Mth.lerp(model.field_178723_h.field_78795_f, -3.2f, amt);
            model.field_178722_k.field_78795_f = Mth.lerp(model.field_178722_k.field_78795_f, 0.0f, amt);
            model.field_178721_j.field_78795_f = Mth.lerp(model.field_178721_j.field_78795_f, 0.0f, amt);
            model.field_178720_f.func_217177_a(model.field_78116_c);
        });
    }

    @SubscribeEvent
    public static void onApplyRotations(ApplyPlayerRotationsEvent event) {
        Flights.ifPlayer(event.getEntity(), (player, flight) -> {
            MatrixStack matrixStack = event.getMatrixStack();
            float delta = event.getDelta();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = Mth.lerpDegrees(player.field_70760_ar - player.field_70126_B, player.field_70761_aq - player.field_70177_z, delta);
                float pitch = -Mth.lerpDegrees(player.field_70127_C, player.field_70125_A, delta) - 90.0f;
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(Mth.lerpDegrees(0.0f, roll, amt)));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Mth.lerpDegrees(0.0f, pitch, amt)));
                matrixStack.func_227861_a_(0.0, -1.2 * (double)Mth.easeInOut(amt), 0.0);
            }
        });
    }

    @SubscribeEvent
    public static void onGetCameraEyeHeight(GetCameraEyeHeightEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ClientPlayerEntity) {
            FlightViews.get((LivingEntity)((ClientPlayerEntity)entity)).ifPresent(flight -> flight.tickEyeHeight(event.getValue(), event::setValue));
        }
    }

    @SubscribeEvent
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        Flights.ifPlayer(Minecraft.func_71410_x().field_175622_Z, (player, flight) -> {
            float delta = (float)event.getRenderPartialTicks();
            float amt = flight.getFlyingAmount(delta);
            if (amt > 0.0f) {
                float roll = Mth.lerpDegrees(player.field_70760_ar - player.field_70126_B, player.field_70761_aq - player.field_70177_z, delta);
                event.setRoll(Mth.lerpDegrees(0.0f, -roll * 0.25f, amt));
            }
        });
    }

    @SubscribeEvent
    public static void onEmptyOffHandPresentEvent(EmptyOffHandPresentEvent event) {
        Flights.get((PlayerEntity)event.getPlayer()).ifPresent(flight -> {
            if (flight.isFlying()) {
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Flights.ifPlayer(event.getEntity(), PlayerEntity::func_175144_cb, (player, flight) -> Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new WingsSound((PlayerEntity)player, (Flight)flight)));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity entity = event.player;
        if (event.phase == TickEvent.Phase.END && entity instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)entity;
            FlightViews.get((LivingEntity)player).ifPresent(FlightView::tick);
        }
    }
}

