/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client;

import java.util.function.Supplier;
import java.util.stream.Stream;
import me.paulf.wings.Proxy;
import me.paulf.wings.WingsMod;
import me.paulf.wings.client.apparatus.WingForm;
import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.client.flight.AnimatorAvian;
import me.paulf.wings.client.flight.AnimatorInsectoid;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.model.ModelWings;
import me.paulf.wings.client.model.ModelWingsAvian;
import me.paulf.wings.client.model.ModelWingsInsectoid;
import me.paulf.wings.client.renderer.LayerWings;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.server.flight.Flights;
import me.paulf.wings.server.item.WingsItems;
import me.paulf.wings.server.net.serverbound.MessageControlFlying;
import me.paulf.wings.util.KeyInputListener;
import me.paulf.wings.util.SimpleStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public final class ClientProxy
extends Proxy {
    private final ModelWings<AnimatorAvian> avianWings = new ModelWingsAvian();
    private final ModelWings<AnimatorInsectoid> insectoidWings = new ModelWingsInsectoid();

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        MinecraftForge.EVENT_BUS.register((Object)KeyInputListener.builder().category("key.categories.wings").key("key.wings.fly", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 82).onPress(() -> {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            Flights.get((PlayerEntity)player).filter(arg_0 -> ClientProxy.lambda$null$0((PlayerEntity)player, arg_0)).ifPresent(flight -> flight.toggleIsFlying(Flight.PlayerSet.ofOthers()));
        }).build());
        modBus.addListener(e -> {
            e.enqueueWork(() -> {
                Minecraft mc = Minecraft.func_71410_x();
                EntityRendererManager manager = mc.func_175598_ae();
                ((Stream)Stream.concat(manager.getSkinMap().values().stream(), manager.field_78729_o.values().stream()).filter(LivingRenderer.class::isInstance).map(r -> (LivingRenderer)r).filter(render -> render.func_217764_d() instanceof BipedModel).unordered()).distinct().forEach(render -> {
                    ModelRenderer body = ((BipedModel)render.func_217764_d()).field_78115_e;
                    LivingRenderer livingRender = render;
                    livingRender.func_177094_a((LayerRenderer)new LayerWings((LivingRenderer<LivingEntity, BipedModel<LivingEntity>>)livingRender, (player, stack) -> {
                        if (player.func_213453_ef()) {
                            stack.func_227861_a_(0.0, 0.2, 0.0);
                        }
                        body.func_228307_a_(stack);
                    }));
                });
            });
            WingForm.register(WingsMod.ANGEL_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.ANGEL_WINGS)));
            WingForm.register(WingsMod.PARROT_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.PARROT_WINGS)));
            WingForm.register(WingsMod.BAT_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.BAT_WINGS)));
            WingForm.register(WingsMod.BLUE_BUTTERFLY_WINGS, this.createInsectoidWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.BLUE_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.DRAGON_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.DRAGON_WINGS)));
            WingForm.register(WingsMod.EVIL_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.EVIL_WINGS)));
            WingForm.register(WingsMod.FAIRY_WINGS, this.createInsectoidWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.FAIRY_WINGS)));
            WingForm.register(WingsMod.FIRE_WINGS, this.createAvianWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.FIRE_WINGS)));
            WingForm.register(WingsMod.MONARCH_BUTTERFLY_WINGS, this.createInsectoidWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.MONARCH_BUTTERFLY_WINGS)));
            WingForm.register(WingsMod.SLIME_WINGS, this.createInsectoidWings(WingsMod.WINGS.func_177774_c((Object)WingsMod.SLIME_WINGS)));
        });
        modBus.addListener(e -> e.getItemColors().func_199877_a((stack, pass) -> pass == 0 ? 10164013 : 0xFFFFFF, new IItemProvider[]{(IItemProvider)WingsItems.BAT_BLOOD_BOTTLE.get()}));
    }

    @Override
    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        CapabilityManager.INSTANCE.register(FlightView.class, SimpleStorage.ofVoid(), () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Override
    public void addFlightListeners(PlayerEntity player, Flight flight) {
        super.addFlightListeners(player, flight);
        if (player.func_175144_cb()) {
            Flight.Notifier notifier = Flight.Notifier.of(() -> {}, p -> {}, () -> this.network.sendToServer(new MessageControlFlying(flight.isFlying())));
            flight.registerSyncListener(players -> players.notify(notifier));
        }
    }

    private WingForm<AnimatorAvian> createAvianWings(ResourceLocation name) {
        return this.createWings(name, AnimatorAvian::new, this.avianWings);
    }

    private WingForm<AnimatorInsectoid> createInsectoidWings(ResourceLocation name) {
        return this.createWings(name, AnimatorInsectoid::new, this.insectoidWings);
    }

    private <A extends Animator> WingForm<A> createWings(ResourceLocation name, Supplier<A> animator, ModelWings<A> model) {
        return WingForm.of(animator, model, new ResourceLocation(name.func_110624_b(), String.format("textures/entity/%s.png", name.func_110623_a())));
    }

    private static /* synthetic */ boolean lambda$null$0(PlayerEntity player, Flight flight) {
        return flight.canFly(player);
    }
}

