/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.flight;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Consumer;
import me.paulf.wings.client.apparatus.WingForm;
import me.paulf.wings.client.flight.Animator;
import me.paulf.wings.client.flight.FlightView;
import me.paulf.wings.client.flight.state.State;
import me.paulf.wings.client.flight.state.StateIdle;
import me.paulf.wings.server.flight.Flight;
import me.paulf.wings.util.function.FloatConsumer;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public final class FlightViewDefault
implements FlightView {
    private static final WingState ABSENT_ANIMATOR = new WingState(){

        @Override
        public WingState nextAbsent() {
            return this;
        }

        @Override
        public WingState next(WingForm<?> form) {
            return PresentWingState.newState(form);
        }

        @Override
        public void update(Flight flight, PlayerEntity player) {
        }

        @Override
        public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        }
    };
    private final Flight flight;
    private final PlayerEntity player;
    private WingState animator = ABSENT_ANIMATOR;

    public FlightViewDefault(PlayerEntity player, Flight flight) {
        this.player = player;
        this.flight = flight;
    }

    @Override
    public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
        this.animator.ifFormPresent(consumer);
    }

    @Override
    public void tick() {
        this.animator = WingForm.get(this.flight.getWing()).map(view -> this.animator.next((WingForm<?>)view)).orElseGet(this.animator::nextAbsent);
        this.animator.update(this.flight, this.player);
    }

    @Override
    public void tickEyeHeight(float value, FloatConsumer valueOut) {
        if (this.flight.isFlying() || this.flight.getFlyingAmount(1.0f) > 0.0f && this.player.func_213283_Z() == Pose.FALL_FLYING) {
            valueOut.accept(1.0f);
        }
    }

    private static final class PresentWingState
    implements WingState {
        private final WingForm<?> wing;
        private final Strategy behavior;

        private PresentWingState(WingForm<?> wing, Strategy behavior) {
            this.wing = wing;
            this.behavior = behavior;
        }

        @Override
        public WingState nextAbsent() {
            return ABSENT_ANIMATOR;
        }

        @Override
        public WingState next(WingForm<?> form) {
            if (this.wing.equals(form)) {
                return this;
            }
            return PresentWingState.newState(form);
        }

        @Override
        public void update(Flight flight, PlayerEntity player) {
            this.behavior.update(flight, player);
        }

        @Override
        public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
            this.behavior.ifFormPresent(consumer);
        }

        public static <T extends Animator> WingState newState(WingForm<T> shape) {
            return new PresentWingState(shape, new WingStrategy<T>(shape));
        }

        private static class WingStrategy<T extends Animator>
        implements Strategy {
            private final WingForm<T> shape;
            private final T animator;
            private State state;

            public WingStrategy(WingForm<T> shape) {
                this.shape = shape;
                this.animator = shape.createAnimator();
                this.state = new StateIdle();
            }

            @Override
            public void update(Flight flight, PlayerEntity player) {
                this.animator.update();
                State state = this.state.update(flight, player.func_226277_ct_() - player.field_70169_q, player.func_226278_cu_() - player.field_70167_r, player.func_226281_cx_() - player.field_70166_s, player);
                if (!this.state.equals(state)) {
                    state.beginAnimation((Animator)this.animator);
                }
                this.state = state;
            }

            @Override
            public void ifFormPresent(Consumer<FlightView.FormRenderer> consumer) {
                consumer.accept(new FlightView.FormRenderer(){

                    @Override
                    public ResourceLocation getTexture() {
                        return shape.getTexture();
                    }

                    @Override
                    public void render(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, float delta) {
                        shape.getModel().render(animator, delta, matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
                    }
                });
            }
        }
    }

    static interface WingState {
        public WingState nextAbsent();

        public WingState next(WingForm<?> var1);

        public void update(Flight var1, PlayerEntity var2);

        public void ifFormPresent(Consumer<FlightView.FormRenderer> var1);
    }

    private static interface Strategy {
        public void update(Flight var1, PlayerEntity var2);

        public void ifFormPresent(Consumer<FlightView.FormRenderer> var1);
    }
}

