/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.client.model;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Direction;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class Model3DTexture
extends ModelRenderer.ModelBox {
    private final int width;
    private final int height;
    private final float u1;
    private final float v1;
    private final float u2;
    private final float v2;

    private Model3DTexture(float posX, float posY, float posZ, int width, int height, float u1, float v1, float u2, float v2) {
        super(0, 0, posX, posY, posZ, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f);
        float f9;
        float f8;
        float f82;
        float f7;
        int k;
        Constructor<?> texturedQuadCtor;
        Constructor<?> positionTextureVertexCtor;
        this.width = width;
        this.height = height;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        int faceCount = 2 + 2 * width + 2 * height;
        String MODEL_BOX_QUADS = "field_78254_i";
        Object quadsOld = Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(ModelRenderer.ModelBox.class, (Object)((Object)this), (String)"field_78254_i"));
        Class<?> texturedQuadClass = quadsOld.getClass().getComponentType();
        Object vertexPositionsArray = Model3DTexture.getPrivateValue(((Object[])quadsOld)[0], "field_78239_a");
        Class<?> positionTextureVertexClass = vertexPositionsArray.getClass().getComponentType();
        try {
            positionTextureVertexCtor = positionTextureVertexClass.getDeclaredConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
            positionTextureVertexCtor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        try {
            texturedQuadCtor = texturedQuadClass.getDeclaredConstructor(vertexPositionsArray.getClass(), Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Boolean.TYPE, Direction.class);
            texturedQuadCtor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Object[] quads = (Object[])Array.newInstance(texturedQuadClass, faceCount);
        int[] quadIndex = new int[]{0};
        float x0 = this.field_78252_a;
        float x1 = this.field_78252_a + (float)this.width;
        float y0 = this.field_78250_b;
        float y1 = this.field_78250_b + (float)this.height;
        float z0 = this.field_78251_c;
        float z1 = this.field_78251_c + 1.0f;
        FaceAdder faces = (fx0, fy0, fz0, fx1, fy1, fz1, fu1, fv1, fu2, fv2, normal) -> {
            Object[] vertices = (Object[])Array.newInstance(positionTextureVertexClass, 4);
            try {
                boolean v = normal.func_176740_k().func_200128_b();
                vertices[0] = positionTextureVertexCtor.newInstance(Float.valueOf(fx1), Float.valueOf(fy0), Float.valueOf(fz0), Float.valueOf(0.0f), Float.valueOf(0.0f));
                vertices[1] = positionTextureVertexCtor.newInstance(Float.valueOf(fx0), Float.valueOf(fy0), Float.valueOf(v ? fz0 : fz1), Float.valueOf(0.0f), Float.valueOf(0.0f));
                vertices[2] = positionTextureVertexCtor.newInstance(Float.valueOf(fx0), Float.valueOf(fy1), Float.valueOf(fz1), Float.valueOf(0.0f), Float.valueOf(0.0f));
                vertices[3] = positionTextureVertexCtor.newInstance(Float.valueOf(fx1), Float.valueOf(fy1), Float.valueOf(v ? fz1 : fz0), Float.valueOf(0.0f), Float.valueOf(0.0f));
                int n = quadIndex[0];
                quadIndex[0] = n + 1;
                quads[n] = texturedQuadCtor.newInstance(vertices, Float.valueOf(fu1), Float.valueOf(fv1), Float.valueOf(fu2), Float.valueOf(fv2), 64, 64, false, normal);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
        faces.add(x0, y0, z0, x1, y1, z0, this.u1, this.v1, this.u2, this.v2, Direction.NORTH);
        faces.add(x0, y1, z1, x1, y0, z1, this.u1, this.v2, this.u2, this.v1, Direction.SOUTH);
        float f5 = 0.5f * (this.u1 - this.u2) / (float)this.width;
        float f6 = 0.5f * (this.v1 - this.v2) / (float)this.height;
        for (k = 0; k < this.width; ++k) {
            f7 = x0 + (float)k;
            f82 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            faces.add(f7, y0, z0, f7, y1, z1, f82, this.v1, f82, this.v2, Direction.WEST);
        }
        for (k = 0; k < this.width; ++k) {
            f8 = this.u1 + (this.u2 - this.u1) * ((float)k / (float)this.width) - f5;
            f9 = x0 + (float)(k + 1);
            faces.add(f9, y1, z0, f9, y0, z1, f8, this.v2, f8, this.v1, Direction.EAST);
        }
        for (k = 0; k < this.height; ++k) {
            f8 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            f9 = y0 + (float)(k + 1);
            faces.add(x0, f9, z0, x1, f9, z1, this.u1, f8, this.u2, f8, Direction.UP);
        }
        for (k = 0; k < this.height; ++k) {
            f7 = y0 + (float)k;
            f82 = this.v1 + (this.v2 - this.v1) * ((float)k / (float)this.height) - f6;
            faces.add(x1, f7, z0, x0, f7, z1, this.u2, f82, this.u1, f82, Direction.DOWN);
        }
        ObfuscationReflectionHelper.setPrivateValue(ModelRenderer.ModelBox.class, (Object)((Object)this), (Object)quads, (String)"field_78254_i");
    }

    private static <E, T> T getPrivateValue(E object, String fieldName) {
        return (T)Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(object.getClass(), object, (String)fieldName));
    }

    public static Model3DTexture create(float posX, float posY, float posZ, int width, int height, int u, int v, int textureWidth, int textureHeight) {
        return new Model3DTexture(posX, posY, posZ, width, height, u, v, u + width, v + height);
    }

    static interface FaceAdder {
        public void add(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, Direction var11);
    }
}

