/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import me.paulf.wings.server.apparatus.FlightApparatus;
import me.paulf.wings.server.command.WingsArgument;
import me.paulf.wings.server.item.BatBloodBottleItem;
import me.paulf.wings.server.item.WingsBottleItem;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WingsCommand {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.wings.give.failed"));
    private static final SimpleCommandExceptionType ERROR_TAKE_FAILED = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.wings.take.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"wings").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::giveWing))))).then(Commands.func_197057_a((String)"take").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"wings", (ArgumentType)WingsArgument.wings()).executes(WingsCommand::takeSpecificWings))).executes(WingsCommand::takeWings))));
    }

    private static int giveWing(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.func_197090_e(ctx, (String)"targets");
        FlightApparatus wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayerEntity player : targets) {
            if (!WingsBottleItem.giveWing(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.give.success.single", new Object[]{((ServerPlayerEntity)targets.iterator().next()).func_145748_c_()}), true);
        } else {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.give.success.multiple", new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeWings(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.func_197090_e(ctx, (String)"targets");
        int count = 0;
        for (ServerPlayerEntity player : targets) {
            if (!BatBloodBottleItem.removeWings(player)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.take.success.single", new Object[]{((ServerPlayerEntity)targets.iterator().next()).func_145748_c_()}), true);
        } else {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.take.success.multiple", new Object[]{targets.size()}), true);
        }
        return count;
    }

    private static int takeSpecificWings(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        Collection targets = EntityArgument.func_197090_e(ctx, (String)"targets");
        FlightApparatus wings = WingsArgument.getWings(ctx, "wings");
        int count = 0;
        for (ServerPlayerEntity player : targets) {
            if (!BatBloodBottleItem.removeWings(player, wings)) continue;
            ++count;
        }
        if (count == 0) {
            throw ERROR_TAKE_FAILED.create();
        }
        if (targets.size() == 1) {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.take.success.single", new Object[]{((ServerPlayerEntity)targets.iterator().next()).func_145748_c_()}), true);
        } else {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.wings.take.success.multiple", new Object[]{targets.size()}), true);
        }
        return count;
    }
}

