/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.dreamcatcher;

import me.paulf.wings.server.dreamcatcher.InSomniable;
import me.paulf.wings.util.CapabilityHolder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="wings")
public final class InSomniableCapability {
    private static final CapabilityHolder<PlayerEntity, InSomniable, CapabilityHolder.State<PlayerEntity, InSomniable>> INSOMNIABLE = CapabilityHolder.create();

    private InSomniableCapability() {
    }

    public static LazyOptional<InSomniable> getInSomniable(PlayerEntity player) {
        return INSOMNIABLE.state().get(player, null);
    }

    @CapabilityInject(value=InSomniable.class)
    static void injectInSomniable(Capability<InSomniable> capability) {
        INSOMNIABLE.inject(capability);
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("wings", "insomniable"), INSOMNIABLE.state().providerBuilder(new InSomniable()).serializedBy(new InSomniable.Serializer()).build());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        InSomniableCapability.getInSomniable(event.getOriginal()).ifPresent(oldInstance -> InSomniableCapability.getInSomniable(event.getPlayer()).ifPresent(newInstance -> newInstance.clone((InSomniable)oldInstance)));
    }
}

