/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.server.flight;

import java.util.function.Consumer;
import me.paulf.wings.server.apparatus.FlightApparatus;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;

public interface Flight {
    default public void setIsFlying(boolean isFlying) {
        this.setIsFlying(isFlying, PlayerSet.empty());
    }

    public void setIsFlying(boolean var1, PlayerSet var2);

    public boolean isFlying();

    default public void toggleIsFlying(PlayerSet players) {
        this.setIsFlying(!this.isFlying(), players);
    }

    public void setTimeFlying(int var1);

    public int getTimeFlying();

    default public void setWing(FlightApparatus wing) {
        this.setWing(wing, PlayerSet.empty());
    }

    public void setWing(FlightApparatus var1, PlayerSet var2);

    public FlightApparatus getWing();

    public float getFlyingAmount(float var1);

    public void registerFlyingListener(FlyingListener var1);

    public void registerSyncListener(SyncListener var1);

    public boolean canFly(PlayerEntity var1);

    public boolean canLand(PlayerEntity var1);

    public void tick(PlayerEntity var1);

    public void onFlown(PlayerEntity var1, Vector3d var2);

    public void clone(Flight var1);

    public void sync(PlayerSet var1);

    public void serialize(PacketBuffer var1);

    public void deserialize(PacketBuffer var1);

    public static interface Notifier {
        public void notifySelf();

        public void notifyPlayer(ServerPlayerEntity var1);

        public void notifyOthers();

        public static Notifier of(final Runnable notifySelf, final Consumer<ServerPlayerEntity> notifyPlayer, final Runnable notifyOthers) {
            return new Notifier(){

                @Override
                public void notifySelf() {
                    notifySelf.run();
                }

                @Override
                public void notifyPlayer(ServerPlayerEntity player) {
                    notifyPlayer.accept(player);
                }

                @Override
                public void notifyOthers() {
                    notifyOthers.run();
                }
            };
        }
    }

    public static interface PlayerSet {
        public void notify(Notifier var1);

        public static PlayerSet empty() {
            return n -> {};
        }

        public static PlayerSet ofSelf() {
            return Notifier::notifySelf;
        }

        public static PlayerSet ofPlayer(ServerPlayerEntity player) {
            return n -> n.notifyPlayer(player);
        }

        public static PlayerSet ofOthers() {
            return Notifier::notifyOthers;
        }

        public static PlayerSet ofAll() {
            return n -> {
                n.notifySelf();
                n.notifyOthers();
            };
        }
    }

    public static interface SyncListener {
        public void onSync(PlayerSet var1);

        public static Consumer<SyncListener> onSyncUsing(PlayerSet players) {
            return l -> l.onSync(players);
        }
    }

    public static interface FlyingListener {
        public void onChange(boolean var1);

        public static Consumer<FlyingListener> onChangeUsing(boolean isFlying) {
            return l -> l.onChange(isFlying);
        }
    }
}

