/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.animation;

import com.bottomtextdanny.dannys_expansion.client.animation.CustomEntityModel;
import com.bottomtextdanny.dannys_expansion.client.animation.DannyModelRenderer;
import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.Transform;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Map;

public class Animator {
    public final CustomEntityModel<?> model;
    private final Map<DannyModelRenderer, Transform> transformMap = Maps.newHashMap();
    private final Map<DannyModelRenderer, Transform> prevTransformMap = Maps.newHashMap();
    float keyframe = 0.0f;
    float prevKeyframe = 0.0f;
    float timer;
    float mult;

    public Animator(CustomEntityModel<?> model, float timer) {
        this.model = model;
        this.timer = timer;
        this.mult = 1.0f;
    }

    public Animator(CustomEntityModel<?> model, float timer, float mult) {
        this.model = model;
        this.timer = timer;
        this.mult = mult;
    }

    public Map<DannyModelRenderer, Transform> getTransformMap() {
        return this.transformMap;
    }

    private Transform getTransform(DannyModelRenderer part) {
        return this.transformMap.computeIfAbsent(part, t -> new Transform());
    }

    public void rotate(DannyModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addRotation(x * this.mult, y * this.mult, z * this.mult);
    }

    public void move(DannyModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addOffset(x * this.mult, y * this.mult, z * this.mult);
    }

    public void scale(DannyModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addScale(x * this.mult, y * this.mult, z * this.mult);
    }

    public void setKeyframeDuration(float duration) {
        this.prevKeyframe = this.keyframe;
        this.keyframe += duration;
    }

    public void resetKeyframe(float duration, Easing easing) {
        this.setKeyframeDuration(duration);
        this.setTransformToModel(easing);
    }

    public void setStaticKeyframe(float duration) {
        this.setKeyframeDuration(duration);
        this.addTransformToModel(Easing.LINEAR);
    }

    public void setTransformToModel(Easing easing) {
        float animationTick = this.timer;
        if (animationTick >= this.prevKeyframe && animationTick < this.keyframe) {
            float uneasedProg = (animationTick - this.prevKeyframe) / (this.keyframe - this.prevKeyframe);
            float prog = easing.progression(uneasedProg);
            float invProg = 1.0f - prog;
            for (DannyModelRenderer box : this.prevTransformMap.keySet()) {
                box.field_78795_f += invProg * this.prevTransformMap.get((Object)box).getRotationX();
                box.field_78796_g += invProg * this.prevTransformMap.get((Object)box).getRotationY();
                box.field_78808_h += invProg * this.prevTransformMap.get((Object)box).getRotationZ();
                box.field_78800_c += invProg * this.prevTransformMap.get((Object)box).getOffsetX();
                box.field_78797_d += invProg * this.prevTransformMap.get((Object)box).getOffsetY();
                box.field_78798_e += invProg * this.prevTransformMap.get((Object)box).getOffsetZ();
                box.scaleX += invProg * this.prevTransformMap.get((Object)box).getScaleX();
                box.scaleY += invProg * this.prevTransformMap.get((Object)box).getScaleY();
                box.scaleZ += invProg * this.prevTransformMap.get((Object)box).getScaleZ();
            }
            for (DannyModelRenderer box : this.transformMap.keySet()) {
                box.field_78795_f += prog * this.transformMap.get((Object)box).getRotationX();
                box.field_78796_g += prog * this.transformMap.get((Object)box).getRotationY();
                box.field_78808_h += prog * this.transformMap.get((Object)box).getRotationZ();
                box.field_78800_c += prog * this.transformMap.get((Object)box).getOffsetX();
                box.field_78797_d += prog * this.transformMap.get((Object)box).getOffsetY();
                box.field_78798_e += prog * this.transformMap.get((Object)box).getOffsetZ();
                box.scaleX += prog * this.transformMap.get((Object)box).getScaleX();
                box.scaleY += prog * this.transformMap.get((Object)box).getScaleY();
                box.scaleZ += prog * this.transformMap.get((Object)box).getScaleZ();
            }
        }
        this.prevTransformMap.clear();
        this.prevTransformMap.putAll(this.transformMap);
        this.transformMap.clear();
    }

    public void setTransformToModel() {
        this.setTransformToModel(Easing.LINEAR);
    }

    public void addTransformToModel(Easing easing) {
        float animationTick = this.timer;
        if (animationTick >= this.prevKeyframe && animationTick < this.keyframe) {
            float uneasedProg = (animationTick - this.prevKeyframe) / (this.keyframe - this.prevKeyframe);
            float prog = easing.progression(uneasedProg);
            for (DannyModelRenderer box : this.prevTransformMap.keySet()) {
                box.field_78795_f += this.prevTransformMap.get((Object)box).getRotationX();
                box.field_78796_g += this.prevTransformMap.get((Object)box).getRotationY();
                box.field_78808_h += this.prevTransformMap.get((Object)box).getRotationZ();
                box.field_78800_c += this.prevTransformMap.get((Object)box).getOffsetX();
                box.field_78797_d += this.prevTransformMap.get((Object)box).getOffsetY();
                box.field_78798_e += this.prevTransformMap.get((Object)box).getOffsetZ();
                box.scaleX += this.prevTransformMap.get((Object)box).getScaleX();
                box.scaleY += this.prevTransformMap.get((Object)box).getScaleY();
                box.scaleZ += this.prevTransformMap.get((Object)box).getScaleZ();
            }
            for (DannyModelRenderer box : this.transformMap.keySet()) {
                box.field_78795_f += prog * this.transformMap.get((Object)box).getRotationX();
                box.field_78796_g += prog * this.transformMap.get((Object)box).getRotationY();
                box.field_78808_h += prog * this.transformMap.get((Object)box).getRotationZ();
                box.field_78800_c += prog * this.transformMap.get((Object)box).getOffsetX();
                box.field_78797_d += prog * this.transformMap.get((Object)box).getOffsetY();
                box.field_78798_e += prog * this.transformMap.get((Object)box).getOffsetZ();
                box.scaleX += prog * this.transformMap.get((Object)box).getScaleX();
                box.scaleY += prog * this.transformMap.get((Object)box).getScaleY();
                box.scaleZ += prog * this.transformMap.get((Object)box).getScaleZ();
            }
        }
    }

    public void reset() {
        this.prevKeyframe = 0.0f;
        this.keyframe = 0.0f;
    }

    public float disable(float startTick, float staticTicks, float endTick, float timer) {
        if (timer < startTick) {
            float prog = timer / startTick;
            return 1.0f - prog;
        }
        if (timer >= startTick && timer < startTick + staticTicks) {
            return 0.0f;
        }
        if (timer >= startTick + staticTicks && timer < startTick + staticTicks + endTick) {
            float prog = (timer - (startTick + staticTicks)) / endTick;
            return prog;
        }
        return 0.0f;
    }

    public float disable(float startTick, float staticTicks, float endTick) {
        if (this.timer < startTick) {
            float prog = this.timer / startTick;
            return 1.0f - prog;
        }
        if (this.timer >= startTick && this.timer < startTick + staticTicks) {
            return 0.0f;
        }
        if (this.timer >= startTick + staticTicks && this.timer < startTick + staticTicks + endTick) {
            float prog = (this.timer - (startTick + staticTicks)) / endTick;
            return prog;
        }
        return 0.0f;
    }

    public void disableAtomic(AtomicDouble atomic, float startTick, float staticTicks, float endTick, float timer) {
        if (timer < startTick) {
            float prog = timer / startTick;
            atomic.set((double)(1.0f - prog));
        } else if (timer >= startTick && timer < startTick + staticTicks) {
            atomic.set(0.0);
        } else if (timer >= startTick + staticTicks && timer < startTick + staticTicks + endTick) {
            float prog = (timer - (startTick + staticTicks)) / endTick;
            atomic.set((double)prog);
        }
    }

    public void disableAtomic(AtomicDouble atomic, float startTick, float staticTicks, float endTick) {
        if (this.timer < startTick) {
            float prog = this.timer / startTick;
            atomic.set((double)(1.0f - prog));
        } else if (this.timer >= startTick && this.timer < startTick + staticTicks) {
            atomic.set(0.0);
        } else if (this.timer >= startTick + staticTicks && this.timer < startTick + staticTicks + endTick) {
            float prog = (this.timer - (startTick + staticTicks)) / endTick;
            atomic.set((double)prog);
        }
    }
}

