/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.animation;

import com.bottomtextdanny.dannys_expansion.client.animation.DannyModelRenderer;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.List;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CustomEntityModel<E extends Entity>
extends EntityModel<E> {
    public List<DannyModelRenderer> defaultValues = Lists.newArrayList();
    public AtomicDouble walkMult = new AtomicDouble(1.0);
    protected float partialTick;
    public float radian = (float)Math.PI / 180;
    public float globalSpeed;
    public float netHeadYaw;
    public float headPitch;

    public void func_225597_a_(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.walkMult = new AtomicDouble(1.0);
        this.setDefaultState();
        this.netHeadYaw = netHeadYaw * this.radian;
        this.headPitch = headPitch * this.radian;
        this.handleAnimations(entityIn);
    }

    public void handleAnimations(E entity) {
    }

    public void func_212843_a_(E entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.partialTick = partialTick;
    }

    public void getDefaultState() {
        this.defaultValues.forEach(DannyModelRenderer::getDefaultState);
    }

    public void setDefaultState() {
        this.defaultValues.forEach(DannyModelRenderer::setDefaultState);
    }

    public void setRotationAngle(DannyModelRenderer MoreContentModelRenderer, float x, float y, float z) {
        MoreContentModelRenderer.field_78795_f = x;
        MoreContentModelRenderer.field_78796_g = y;
        MoreContentModelRenderer.field_78808_h = z;
    }

    public void setRotationAngleDegrees(DannyModelRenderer MoreContentModelRenderer, float x, float y, float z) {
        MoreContentModelRenderer.field_78795_f = x * this.radian;
        MoreContentModelRenderer.field_78796_g = y * this.radian;
        MoreContentModelRenderer.field_78808_h = z * this.radian;
    }

    public void setOffset(DannyModelRenderer part, float x, float y, float z) {
        part.field_78800_c = x;
        part.field_78797_d = y;
        part.field_78798_e = z;
    }

    public void setSize(DannyModelRenderer part, float x, float y, float z) {
        part.scaleX = x;
        part.scaleY = y;
        part.scaleZ = z;
    }

    public void addRotation(DannyModelRenderer part, float x, float y, float z) {
        part.field_78795_f = (float)((double)part.field_78795_f + Math.toRadians(x));
        part.field_78796_g = (float)((double)part.field_78796_g + Math.toRadians(y));
        part.field_78808_h = (float)((double)part.field_78808_h + Math.toRadians(z));
    }

    public void addOffset(DannyModelRenderer part, float x, float y, float z) {
        part.field_78800_c += x;
        part.field_78797_d += y;
        part.field_78798_e += z;
    }

    public void addSize(DannyModelRenderer part, float x, float y, float z) {
        part.scaleX += x;
        part.scaleY += y;
        part.scaleZ += z;
    }

    public void addRotation(DannyModelRenderer part, float x, float y, float z, float mult) {
        part.field_78795_f = (float)((double)part.field_78795_f + Math.toRadians(x) * (double)mult);
        part.field_78796_g = (float)((double)part.field_78796_g + Math.toRadians(y) * (double)mult);
        part.field_78808_h = (float)((double)part.field_78808_h + Math.toRadians(z) * (double)mult);
    }

    public void addOffset(DannyModelRenderer part, float x, float y, float z, float mult) {
        part.field_78800_c += x * mult;
        part.field_78797_d += y * mult;
        part.field_78798_e += z * mult;
    }

    public void addSize(DannyModelRenderer part, float x, float y, float z, float mult) {
        part.scaleX += x * mult;
        part.scaleY += y * mult;
        part.scaleZ += z * mult;
    }

    public float walkRotationHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? (MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (-amount * this.radian * 2.0f) * limbSwingAmount + weight * limbSwingAmount * this.radian) * this.walkMult.floatValue() : (MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (amount * this.radian * 2.0f) * limbSwingAmount + weight * limbSwingAmount * this.radian) * this.walkMult.floatValue();
    }

    public float walkOffsetHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? (MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (-amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount) * this.walkMult.floatValue() : (MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount) * this.walkMult.floatValue();
    }

    public void walkRotateX(DannyModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78795_f += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkRotateY(DannyModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78796_g += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkRotateZ(DannyModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78808_h += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetX(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78800_c += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetY(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78797_d += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetZ(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78798_e += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkScaleX(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleX += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkScaleY(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleY += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkScaleZ(DannyModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.scaleZ += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }
}

