/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.animation;

import com.bottomtextdanny.dannys_expansion.client.animation.CustomEntityModel;
import com.bottomtextdanny.dannys_expansion.client.animation.RotationMatrix;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DannyModelRenderer
extends ModelRenderer {
    public float defaultAngleX;
    public float defaultAngleY;
    public float defaultAngleZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultSizeX;
    public float defaultSizeY;
    public float defaultSizeZ;
    public int field_78803_o;
    public int field_78813_p;
    public float field_78801_a;
    public float field_78799_b;
    public float scaleX;
    public float scaleY;
    public float scaleZ;
    DannyModelRenderer parent;
    public final ObjectList<ModelBox> field_78804_l = new ObjectArrayList();
    public final ObjectList<DannyModelRenderer> field_78805_m = new ObjectArrayList();

    public DannyModelRenderer(CustomEntityModel<? extends Entity> model) {
        super(model);
        this.setScale(1.0f, 1.0f, 1.0f);
        model.accept(this);
        this.setTextureSize(model.field_78090_t, model.field_78089_u);
        model.defaultValues.add(this);
    }

    public DannyModelRenderer(Model model) {
        super(model);
        this.setScale(1.0f, 1.0f, 1.0f);
        model.accept((ModelRenderer)this);
        this.setTextureSize(model.field_78090_t, model.field_78089_u);
    }

    public Vector3d getAbsoluteRotation(Vector3d holder, float partialTicks, Entity entity) {
        this.collectRotations(holder);
        double easedRotationYaw = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70126_B, (float)entity.field_70177_z);
        holder = holder.func_72441_c(0.0, easedRotationYaw, 0.0);
        return MathUtil.fromPitchYawRoll(holder.field_72450_a, holder.field_72448_b, holder.field_72449_c);
    }

    public void collectRotations(Vector3d holder) {
        if (this.parent != null) {
            this.collectRotations(holder);
        }
        holder = holder.func_72441_c((double)this.field_78795_f, (double)this.field_78796_g, (double)this.field_78808_h);
    }

    public void translateRotateWithParents(MatrixStack matrixStackIn) {
        if (this.parent != null) {
            this.parent.translateRotateWithParents(matrixStackIn);
        }
        matrixStackIn.func_227861_a_((double)(this.field_78800_c / 16.0f), (double)(this.field_78797_d / 16.0f), (double)(this.field_78798_e / 16.0f));
        if (this.field_78808_h != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.field_78808_h));
        }
        if (this.field_78796_g != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(this.field_78796_g));
        }
        if (this.field_78795_f != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(this.field_78795_f));
        }
    }

    public void translateRotateWithParentsInverted(MatrixStack matrixStackIn) {
        if (this.parent != null) {
            this.parent.translateRotateWithParentsInverted(matrixStackIn);
        }
        matrixStackIn.func_227861_a_((double)(this.field_78800_c / 16.0f), (double)(this.field_78797_d / 16.0f), (double)(this.field_78798_e / 16.0f));
        if (this.field_78808_h != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(this.field_78808_h));
        }
        if (this.field_78796_g != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-this.field_78796_g));
        }
        if (this.field_78795_f != 0.0f) {
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(-this.field_78795_f));
        }
    }

    public Vector3d getAbsolutePosition(Vector3d holder, float partialTicks, LivingEntity entity) {
        Vector3d modelPosition = this.modelPositionWithParentsInverted(holder);
        double entityPositionX = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double entityPositionY = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
        double entityPositionZ = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        Vector3d entityPos = new Vector3d(entityPositionX, entityPositionY, entityPositionZ);
        RotationMatrix matrixRotY = new RotationMatrix();
        matrixRotY.rotY((float)Math.toRadians(-entity.field_70761_aq));
        modelPosition = matrixRotY.getTransform(modelPosition);
        modelPosition = modelPosition.func_72441_c(0.0, 1.5, 0.0);
        return entityPos.func_178787_e(modelPosition);
    }

    public Vector3d modelPositionWithParentsInverted(Vector3d holder) {
        Vector3d rendererPos = new Vector3d(holder.func_82615_a(), holder.func_82617_b(), holder.func_82616_c());
        Vector3d translation = new Vector3d((double)(this.field_78800_c / 16.0f), (double)(-this.field_78797_d / 16.0f), (double)(-this.field_78798_e / 16.0f));
        RotationMatrix matrixRotX = new RotationMatrix();
        RotationMatrix matrixRotY = new RotationMatrix();
        RotationMatrix matrixRotZ = new RotationMatrix();
        matrixRotX.rotX(this.field_78795_f);
        matrixRotY.rotY(-this.field_78796_g);
        matrixRotZ.rotZ(-this.field_78808_h);
        rendererPos = matrixRotZ.getTransform(rendererPos);
        rendererPos = matrixRotX.getTransform(rendererPos);
        rendererPos = matrixRotY.getTransform(rendererPos);
        rendererPos = rendererPos.func_178787_e(translation);
        if (this.parent != null) {
            return this.parent.modelPositionWithParentsInverted(rendererPos);
        }
        return new Vector3d(rendererPos.func_82615_a(), rendererPos.func_82617_b(), rendererPos.func_82616_c());
    }

    public void addChild(DannyModelRenderer renderer) {
        this.field_78805_m.add((Object)renderer);
        renderer.parent = this;
    }

    public void setRotationAngle(float rotationAngleXIn, float rotationAngleYIn, float rotationAngleZIn) {
        this.field_78795_f = rotationAngleXIn;
        this.field_78796_g = rotationAngleYIn;
        this.field_78808_h = rotationAngleZIn;
    }

    public void setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
    }

    public void getDefaultState() {
        this.defaultAngleX = this.field_78795_f;
        this.defaultAngleY = this.field_78796_g;
        this.defaultAngleZ = this.field_78808_h;
        this.defaultOffsetX = this.field_78800_c;
        this.defaultOffsetY = this.field_78797_d;
        this.defaultOffsetZ = this.field_78798_e;
        this.defaultSizeX = this.scaleX;
        this.defaultSizeY = this.scaleY;
        this.defaultSizeZ = this.scaleZ;
    }

    public void setDefaultState() {
        this.field_78795_f = this.defaultAngleX;
        this.field_78796_g = this.defaultAngleY;
        this.field_78808_h = this.defaultAngleZ;
        this.field_78800_c = this.defaultOffsetX;
        this.field_78797_d = this.defaultOffsetY;
        this.field_78798_e = this.defaultOffsetZ;
        this.setScale(this.defaultSizeX, this.defaultSizeY, this.defaultSizeZ);
    }

    public DannyModelRenderer setTextureOffset(int x, int y) {
        this.field_78803_o = x;
        this.field_78813_p = y;
        return this;
    }

    public DannyModelRenderer setTextureSize(int textureWidthIn, int textureHeightIn) {
        this.field_78801_a = textureWidthIn;
        this.field_78799_b = textureHeightIn;
        return this;
    }

    public DannyModelRenderer addBox(String partName, float x, float y, float z, int width, int height, int depth, float delta, int texX, int texY) {
        this.setTextureOffset(texX, texY);
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
        return this;
    }

    public DannyModelRenderer addBox(float x, float y, float z, float width, float height, float depth) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, this.field_78809_i, false);
        return this;
    }

    public DannyModelRenderer addBox(float x, float y, float z, float width, float height, float depth, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, 0.0f, 0.0f, 0.0f, mirrorIn, false);
        return this;
    }

    public void func_228301_a_(float x, float y, float z, float width, float height, float depth, float delta) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, this.field_78809_i, false);
    }

    public void func_228302_a_(float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, this.field_78809_i, false);
    }

    public void func_228303_a_(float x, float y, float z, float width, float height, float depth, float delta, boolean mirrorIn) {
        this.addBox(this.field_78803_o, this.field_78813_p, x, y, z, width, height, depth, delta, delta, delta, mirrorIn, false);
    }

    private void addBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, boolean p_228305_13_) {
        this.field_78804_l.add((Object)new ModelBox(texOffX, texOffY, x, y, z, width, height, depth, deltaX, deltaY, deltaZ, mirorIn, this.field_78801_a, this.field_78799_b));
    }

    public void func_228309_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.field_78806_j || this.field_78804_l.isEmpty() && this.field_78805_m.isEmpty())) {
            matrixStackIn.func_227860_a_();
            this.func_228307_a_(matrixStackIn);
            matrixStackIn.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
            this.doRender(matrixStackIn.func_227866_c_(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            for (DannyModelRenderer modelrenderer : this.field_78805_m) {
                modelrenderer.func_228309_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void doRender(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
        Matrix3f matrix3f = matrixEntryIn.func_227872_b_();
        for (ModelBox modelrenderer$modelbox : this.field_78804_l) {
            for (TexturedQuad modelrenderer$texturedquad : modelrenderer$modelbox.quads) {
                Vector3f vector3f = modelrenderer$texturedquad.normal.func_229195_e_();
                vector3f.func_229188_a_(matrix3f);
                float f = vector3f.func_195899_a();
                float f1 = vector3f.func_195900_b();
                float f2 = vector3f.func_195902_c();
                for (int i = 0; i < 4; ++i) {
                    PositionTextureVertex MoreContentModelRenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                    float f3 = MoreContentModelRenderer$positiontexturevertex.position.func_195899_a() / 16.0f;
                    float f4 = MoreContentModelRenderer$positiontexturevertex.position.func_195900_b() / 16.0f;
                    float f5 = MoreContentModelRenderer$positiontexturevertex.position.func_195902_c() / 16.0f;
                    Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                    vector4f.func_229372_a_(matrix4f);
                    bufferIn.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), red, green, blue, alpha, MoreContentModelRenderer$positiontexturevertex.textureU, MoreContentModelRenderer$positiontexturevertex.textureV, packedOverlayIn, packedLightIn, f, f1, f2);
                }
            }
        }
    }

    public static class ModelBox {
        protected final TexturedQuad[] quads;
        public float posX1;
        public float posY1;
        public float posZ1;
        public float posX2;
        public float posY2;
        public float posZ2;

        public ModelBox(int texOffX, int texOffY, float x, float y, float z, float width, float height, float depth, float deltaX, float deltaY, float deltaZ, boolean mirorIn, float texWidth, float texHeight) {
            this.posX1 = x;
            this.posY1 = y;
            this.posZ1 = z;
            this.posX2 = x + width;
            this.posY2 = y + height;
            this.posZ2 = z + depth;
            this.quads = new TexturedQuad[6];
            float f = x + width;
            float f1 = y + height;
            float f2 = z + depth;
            x -= deltaX;
            y -= deltaY;
            z -= deltaZ;
            f += deltaX;
            f1 += deltaY;
            f2 += deltaZ;
            if (mirorIn) {
                float f3 = f;
                f = x;
                x = f3;
            }
            PositionTextureVertex modelrenderer$positiontexturevertex7 = new PositionTextureVertex(x, y, z, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex = new PositionTextureVertex(f, y, z, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex1 = new PositionTextureVertex(f, f1, z, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex2 = new PositionTextureVertex(x, f1, z, 8.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex3 = new PositionTextureVertex(x, y, f2, 0.0f, 0.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex4 = new PositionTextureVertex(f, y, f2, 0.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex5 = new PositionTextureVertex(f, f1, f2, 8.0f, 8.0f);
            PositionTextureVertex modelrenderer$positiontexturevertex6 = new PositionTextureVertex(x, f1, f2, 8.0f, 0.0f);
            float f4 = texOffX;
            float f5 = (float)texOffX + depth;
            float f6 = (float)texOffX + depth + width;
            float f7 = (float)texOffX + depth + width + width;
            float f8 = (float)texOffX + depth + width + depth;
            float f9 = (float)texOffX + depth + width + depth + width;
            float f10 = texOffY;
            float f11 = (float)texOffY + depth;
            float f12 = (float)texOffY + depth + height;
            this.quads[2] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex}, f5, f10, f6, f11, texWidth, texHeight, mirorIn, Direction.DOWN);
            this.quads[3] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex5}, f6, f11, f7, f10, texWidth, texHeight, mirorIn, Direction.UP);
            this.quads[1] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex6, modelrenderer$positiontexturevertex2}, f4, f11, f5, f12, texWidth, texHeight, mirorIn, Direction.WEST);
            this.quads[4] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex7, modelrenderer$positiontexturevertex2, modelrenderer$positiontexturevertex1}, f5, f11, f6, f12, texWidth, texHeight, mirorIn, Direction.NORTH);
            this.quads[0] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex, modelrenderer$positiontexturevertex1, modelrenderer$positiontexturevertex5}, f6, f11, f8, f12, texWidth, texHeight, mirorIn, Direction.EAST);
            this.quads[5] = new TexturedQuad(new PositionTextureVertex[]{modelrenderer$positiontexturevertex3, modelrenderer$positiontexturevertex4, modelrenderer$positiontexturevertex5, modelrenderer$positiontexturevertex6}, f8, f11, f9, f12, texWidth, texHeight, mirorIn, Direction.SOUTH);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class TexturedQuad {
        public final PositionTextureVertex[] vertexPositions;
        public final Vector3f normal;

        public TexturedQuad(PositionTextureVertex[] positionsIn, float u1, float v1, float u2, float v2, float texWidth, float texHeight, boolean mirrorIn, Direction directionIn) {
            this.vertexPositions = positionsIn;
            float f = 0.0f / texWidth;
            float f1 = 0.0f / texHeight;
            positionsIn[0] = positionsIn[0].setTextureUV(u2 / texWidth - f, v1 / texHeight + f1);
            positionsIn[1] = positionsIn[1].setTextureUV(u1 / texWidth + f, v1 / texHeight + f1);
            positionsIn[2] = positionsIn[2].setTextureUV(u1 / texWidth + f, v2 / texHeight - f1);
            positionsIn[3] = positionsIn[3].setTextureUV(u2 / texWidth - f, v2 / texHeight - f1);
            if (mirrorIn) {
                int i = positionsIn.length;
                for (int j = 0; j < i / 2; ++j) {
                    PositionTextureVertex MoreContentModelRenderer$positiontexturevertex = positionsIn[j];
                    positionsIn[j] = positionsIn[i - 1 - j];
                    positionsIn[i - 1 - j] = MoreContentModelRenderer$positiontexturevertex;
                }
            }
            this.normal = directionIn.func_229386_k_();
            if (mirrorIn) {
                this.normal.func_229192_b_(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class PositionTextureVertex {
        public final Vector3f position;
        public final float textureU;
        public final float textureV;

        public PositionTextureVertex(float x, float y, float z, float texU, float texV) {
            this(new Vector3f(x, y, z), texU, texV);
        }

        public PositionTextureVertex setTextureUV(float texU, float texV) {
            return new PositionTextureVertex(this.position, texU, texV);
        }

        public PositionTextureVertex(Vector3f posIn, float texU, float texV) {
            this.position = posIn;
            this.textureU = texU;
            this.textureV = texV;
        }
    }
}

