/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.entity.model.living;

import com.bottomtextdanny.dannys_expansion.client.ClientInstance;
import com.bottomtextdanny.dannys_expansion.client.animation.Animator;
import com.bottomtextdanny.dannys_expansion.client.animation.DannyModelRenderer;
import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.MoreContentEntityModel;
import com.bottomtextdanny.dannys_expansion.client.entity.render.entity.MountEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.slime.BlueSlimeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class BlueSlimeModel<E extends BlueSlimeEntity>
extends MoreContentEntityModel<E> {
    private final DannyModelRenderer model;
    private final DannyModelRenderer slime;
    private final DannyModelRenderer saddle;

    public BlueSlimeModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.model = new DannyModelRenderer(this);
        this.model.func_78793_a(0.0f, 24.0f, 0.0f);
        this.saddle = new DannyModelRenderer(this);
        this.saddle.func_78793_a(0.0f, 0.0f, 0.0f);
        this.model.addChild(this.saddle);
        this.saddle.setTextureOffset(0, 32).func_228303_a_(-9.0f, -14.0f, -9.0f, 18.0f, 14.0f, 18.0f, 0.5f, false);
        this.slime = new DannyModelRenderer(this);
        this.slime.func_78793_a(0.0f, 0.0f, 0.0f);
        this.model.addChild(this.slime);
        this.slime.setTextureOffset(0, 0).func_228303_a_(-9.0f, -14.0f, -9.0f, 18.0f, 14.0f, 18.0f, 0.0f, false);
        this.getDefaultState();
    }

    @Override
    public void setRotationAngles(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float idle = MathHelper.func_76126_a((float)(ageInTicks * 0.1f));
        this.slime.field_78806_j = true;
        this.globalSpeed = 0.4f;
        this.walkScaleY(this.model, this.globalSpeed, 0.01f, 0.0f, 0.01f, limbSwing, limbSwingAmount, false);
        this.walkScaleX(this.model, this.globalSpeed, -0.01f, 0.0f, -0.01f, limbSwing, limbSwingAmount, false);
        this.walkScaleZ(this.model, this.globalSpeed, -0.01f, 0.0f, -0.01f, limbSwing, limbSwingAmount, false);
        this.addSize(this.model, 0.02222f * idle, -0.02f * idle, 0.02222f * idle);
        if (((MountEntity)entityIn).func_184179_bs() instanceof PlayerEntity) {
            ClientPlayerEntity cPlayer = (ClientPlayerEntity)((MountEntity)entityIn).func_184179_bs();
            Vector3d vec = cPlayer.func_213303_ch().func_72441_c(0.0, (double)cPlayer.func_70047_e(), 0.0);
            if (entityIn.func_174813_aQ().func_72326_a(new AxisAlignedBB(vec, vec)) && ClientInstance.gs().func_243230_g() == PointOfView.FIRST_PERSON) {
                this.slime.field_78806_j = false;
            }
        }
    }

    @Override
    public void handleAnimations(E entity) {
        super.handleAnimations(entity);
        float dif = ((MountEntity)entity).getProgress() - ((MountEntity)entity).getPrevProgress();
        float prog = ((MountEntity)entity).getPrevProgress() + dif * this.partialTick;
        Animator animator = new Animator(this, (float)((DannyEntity)entity).getMainAnimationTick() + this.partialTick);
        Animator mountProgAnimator = new Animator(this, prog);
        if (((MountEntity)entity).getProgress() > 0.0f) {
            mountProgAnimator.setKeyframeDuration(1.0f);
            mountProgAnimator.scale(this.model, 0.2f, -0.3f, 0.2f);
            mountProgAnimator.setTransformToModel();
            mountProgAnimator.setStaticKeyframe(1.0f);
        }
        if (((DannyEntity)entity).isAnimationPlaying(BlueSlimeEntity.JUMP)) {
            animator.setKeyframeDuration(3.0f);
            animator.scale(this.model, -0.25f, 0.4f, -0.25f);
            animator.setTransformToModel();
            animator.resetKeyframe(10.0f, Easing.LINEAR);
        } else if (((DannyEntity)entity).isAnimationPlaying(BlueSlimeEntity.BACK_TO_ITEM)) {
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.15f, -0.15f, -0.15f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.3f, -0.3f, -0.3f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.45f, -0.45f, -0.45f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.6f, -0.6f, -0.6f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.75f, -0.75f, -0.75f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
        } else if (((DannyEntity)entity).isAnimationPlaying(BlueSlimeEntity.FROM_ITEM)) {
            animator.setKeyframeDuration(0.0f);
            animator.scale(this.model, -0.75f, -0.75f, -0.75f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.6f, -0.6f, -0.6f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.45f, -0.45f, -0.45f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.3f, -0.3f, -0.3f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.setKeyframeDuration(4.0f);
            animator.scale(this.model, -0.15f, -0.15f, -0.15f);
            animator.setTransformToModel(Easing.EASE_OUT_BACK);
            animator.resetKeyframe(4.0f, Easing.EASE_OUT_BACK);
        }
        if (((BlueSlimeEntity)entity).getProtectiveTicks() > -1) {
            Animator protectiveAnimator = new Animator(this, (float)((BlueSlimeEntity)entity).getProtectiveTicks() + this.partialTick);
            protectiveAnimator.setKeyframeDuration(10.0f);
            protectiveAnimator.scale(this.model, 0.7f, 0.7f, 0.7f);
            protectiveAnimator.setTransformToModel(Easing.EASE_OUT_BACK);
            protectiveAnimator.setStaticKeyframe(280.0f);
            protectiveAnimator.resetKeyframe(10.0f, Easing.EASE_OUT_BACK);
        }
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.func_228308_a_(matrixStackIn, bufferIn, packedLight, packedOverlay);
    }
}

