/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.entity.render.entity;

import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IDannyMount;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MountEntity
extends DannyEntity
implements IDannyMount {
    private static final DataParameter<Integer> ABILITY_TIMER = EntityDataManager.func_187226_a(MountEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    int progress;
    int prevProgress;
    boolean progressIsIncreasing;
    int progressDifference;

    public MountEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ABILITY_TIMER, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAbilityTimer(MathHelper.func_76125_a((int)compound.func_74762_e("AbilityTimer"), (int)0, (int)10000));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("AbilityTimer", (float)this.getAbilityTimer());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevProgress = this.progress;
        if (this.usesProgressBar()) {
            this.progress = this.progressIsIncreasing ? MathHelper.func_76125_a((int)(this.progress + this.progressAddition()), (int)0, (int)1000) : MathHelper.func_76125_a((int)(this.progress + this.progressSubtraction()), (int)0, (int)1000);
            this.progressIsIncreasing = false;
        }
        this.progressDifference = this.progress - this.prevProgress;
        if (this.usesAbilityBar() && this.getAbilityTimer() < 10000) {
            this.setAbilityTimer(MathHelper.func_76125_a((int)(this.getAbilityTimer() + this.abilityTimerAddition()), (int)0, (int)10000));
        }
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void setRiddenBy(PlayerEntity player) {
        player.field_70177_z = this.field_70177_z;
        player.field_70125_A = this.field_70125_A;
        player.func_184220_m((Entity)this);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public int progressAddition() {
        return 50;
    }

    public int progressSubtraction() {
        return -this.progressAddition();
    }

    public int abilityTimerAddition() {
        return 40;
    }

    public boolean progressIncreasingParams() {
        return !this.progShouldWaitforRestart() || this.getProgressDifference() > -1;
    }

    @Override
    public void doAct() {
    }

    @Override
    public void doAbility() {
        this.setAbilityTimer(0);
    }

    public float getProgress() {
        return (float)this.progress / 1000.0f;
    }

    public float getPrevProgress() {
        return (float)this.prevProgress / 1000.0f;
    }

    public int getAbilityTimer() {
        return (Integer)this.field_70180_af.func_187225_a(ABILITY_TIMER);
    }

    public boolean usesProgressBar() {
        return true;
    }

    public boolean usesAbilityBar() {
        return true;
    }

    public boolean progShouldWaitforRestart() {
        return true;
    }

    public void setAbilityTimer(int i) {
        this.field_70180_af.func_187227_b(ABILITY_TIMER, (Object)i);
    }

    public void setProgressIsIncreasing(boolean progressIsIncreasing) {
        this.progressIsIncreasing = progressIsIncreasing;
    }

    public int getProgressDifference() {
        return this.progressDifference;
    }
}

