/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.entity.render.entity.kite;

import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.PolygonHelper;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.KiteModel;
import com.bottomtextdanny.dannys_expansion.common.Entities.kite.KiteEntity;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class KiteRenderer
extends EntityRenderer<KiteEntity> {
    protected final List<LayerRenderer<KiteEntity, KiteModel<KiteEntity>>> layerRenderers = Lists.newArrayList();
    KiteModel<KiteEntity> entityModel = new KiteModel();
    String color;

    public KiteRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public final boolean addLayer(LayerRenderer<KiteEntity, KiteModel<KiteEntity>> layer) {
        return this.layerRenderers.add(layer);
    }

    public void render(KiteEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        matrixStackIn.func_227860_a_();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKiteYaw, (float)entityIn.kiteYaw) - 180.0f;
        float f2 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKitePitch, (float)entityIn.kitePitch);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entityIn)));
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        float ageInTicks = this.handleRotationFloat(entityIn, partialTicks);
        this.entityModel.getPartialTick(partialTicks);
        this.entityModel.setRotationAngles(entityIn, 0.0f, 0.0f, (float)entityIn.field_70173_aa + partialTicks, f1, f2);
        this.entityModel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerRenderer<KiteEntity, KiteModel<KiteEntity>> layerrenderer : this.layerRenderers) {
            layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, 1.0f, 0.0f, partialTicks, ageInTicks, f1, f2);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        float easedPosX = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_());
        float easedPosY = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_());
        float easedPosZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_());
        IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(this.getPolygonRenderType());
        PolygonHelper polygonHelper2 = new PolygonHelper(ivertexbuilder3, matrixStackIn, packedLightIn);
        if (entityIn.getKnot() != null) {
            float knotEasedPosX = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70169_q, (double)entityIn.getKnot().func_226277_ct_());
            float knotEasedPosY = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70167_r, (double)entityIn.getKnot().func_226278_cu_());
            float knotEasedPosZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70166_s, (double)entityIn.getKnot().func_226281_cx_());
            matrixStackIn.func_227860_a_();
            float horizontalDistance = MathUtil.getHorizontalDistance(easedPosX, easedPosZ, knotEasedPosX, knotEasedPosZ);
            float verticalDistance = easedPosY - knotEasedPosY;
            float yawToKnot = MathUtil.getTargetYaw(easedPosX, easedPosZ, knotEasedPosX, knotEasedPosZ);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yawToKnot));
            matrixStackIn.func_227860_a_();
            float texPos = 0.015625f;
            int instances = 24;
            float yOffset = 0.0f;
            for (int i = 0; i < instances; ++i) {
                float uneasedProg = (float)(i + 1) / 23.0f;
                float prog = Easing.EASE_OUT_SQUARE.progression(uneasedProg) * verticalDistance;
                matrixStackIn.func_227860_a_();
                polygonHelper2.addQuadPair(new Vector3d((double)texPos, (double)(-prog), (double)(horizontalDistance / (float)instances)), new Vector3d((double)texPos, (double)(-yOffset), 0.0), new Vector3d((double)(-texPos), (double)(-yOffset), 0.0), new Vector3d((double)(-texPos), (double)(-prog), (double)(horizontalDistance / (float)instances)), 0.0f, 0.0f, texPos * 2.0f, horizontalDistance / (float)instances, new Quaternion(1.0f, 1.0f, 1.0f, 255.0f), packedLightIn);
                matrixStackIn.func_227861_a_(0.0, (double)(-prog), 0.0);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227860_a_();
                polygonHelper2.addQuadPair(new Vector3d(0.0, (double)(texPos - prog), (double)(horizontalDistance / (float)instances)), new Vector3d(0.0, (double)(texPos - yOffset), 0.0), new Vector3d(0.0, (double)(-texPos - yOffset), 0.0), new Vector3d(0.0, (double)(-texPos - prog), (double)(horizontalDistance / (float)instances)), 0.0f, 0.0f, texPos * 2.0f, horizontalDistance / (float)instances, new Quaternion(1.0f, 1.0f, 1.0f, 255.0f), packedLightIn);
                matrixStackIn.func_227861_a_(0.0, (double)(-prog), 0.0);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)(horizontalDistance / (float)instances));
                yOffset = prog;
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
        if (!entityIn.getDesign().equals("none")) {
            matrixStackIn.func_227860_a_();
            float texPos = 0.0625f;
            IVertexBuilder ivertexbuilder0 = bufferIn.getBuffer(this.getDesignRenderType(entityIn));
            PolygonHelper polygonHelper1 = new PolygonHelper(ivertexbuilder0, matrixStackIn, packedLightIn);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
            this.entityModel.kite.translateRotateWithParentsInverted(matrixStackIn);
            matrixStackIn.func_227861_a_((double)(texPos * 5.5f), (double)(texPos * -9.0f), (double)texPos * 0.515);
            polygonHelper1.addQuad(new Vector3d((double)texPos, 0.0, 0.0), new Vector3d((double)texPos, (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), 0.0, 0.0), 0.0f, 0.0f, -1.0f, 1.0f, new Quaternion((float)entityIn.designColor.func_82615_a() / 255.0f, (float)entityIn.designColor.func_82617_b() / 255.0f, (float)entityIn.designColor.func_82616_c() / 255.0f, 1.0f), packedLightIn);
            matrixStackIn.func_227861_a_(0.0, 0.0, (double)texPos * -0.03);
            polygonHelper1.addQuad(new Vector3d((double)texPos, 0.0, 0.0), new Vector3d((double)texPos, (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), 0.0, 0.0), 0.0f, 0.0f, -1.0f, 1.0f, new Quaternion((float)entityIn.designColor.func_82615_a() / 510.0f, (float)entityIn.designColor.func_82617_b() / 510.0f, (float)entityIn.designColor.func_82616_c() / 510.0f, 0.6f), packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    public void renderStatic(KiteEntity entityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        KiteModel entityModel1 = new KiteModel();
        matrixStackIn.func_227860_a_();
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKiteYaw, (float)entityIn.kiteYaw) - 180.0f;
        float f2 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKitePitch, (float)entityIn.kitePitch);
        float ageInTicks = this.handleRotationFloat(entityIn, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entityIn)));
        entityModel1.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerRenderer<KiteEntity, KiteModel<KiteEntity>> layerrenderer : this.layerRenderers) {
            layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, 1.0f, 0.0f, partialTicks, ageInTicks, f1, f2);
        }
        matrixStackIn.func_227865_b_();
        IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(this.getPolygonRenderType());
        PolygonHelper polygonHelper2 = new PolygonHelper(ivertexbuilder3, matrixStackIn, packedLightIn);
        if (!entityIn.getDesign().equals("none")) {
            matrixStackIn.func_227860_a_();
            float texPos = 0.0625f;
            IVertexBuilder ivertexbuilder0 = bufferIn.getBuffer(this.getDesignRenderType(entityIn));
            PolygonHelper polygonHelper1 = new PolygonHelper(ivertexbuilder0, matrixStackIn, packedLightIn);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
            entityModel1.kite.translateRotateWithParentsInverted(matrixStackIn);
            matrixStackIn.func_227861_a_((double)(texPos * 5.5f), (double)(texPos * -9.0f), (double)texPos * 0.515);
            polygonHelper1.addQuad(new Vector3d((double)texPos, 0.0, 0.0), new Vector3d((double)texPos, (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), 0.0, 0.0), 0.0f, 0.0f, -1.0f, 1.0f, new Quaternion((float)entityIn.designColor.func_82615_a() / 255.0f, (float)entityIn.designColor.func_82617_b() / 255.0f, (float)entityIn.designColor.func_82616_c() / 255.0f, 1.0f), packedLightIn);
            matrixStackIn.func_227861_a_(0.0, 0.0, (double)texPos * -0.03);
            polygonHelper1.addQuad(new Vector3d((double)texPos, 0.0, 0.0), new Vector3d((double)texPos, (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), (double)(texPos * 18.0f), 0.0), new Vector3d((double)(-texPos * 12.0f), 0.0, 0.0), 0.0f, 0.0f, -1.0f, 1.0f, new Quaternion((float)entityIn.designColor.func_82615_a() / 510.0f, (float)entityIn.designColor.func_82617_b() / 510.0f, (float)entityIn.designColor.func_82616_c() / 510.0f, 0.6f), packedLightIn);
            matrixStackIn.func_227865_b_();
        }
    }

    public boolean shouldRender(KiteEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return true;
    }

    protected float handleRotationFloat(KiteEntity livingBase, float partialTicks) {
        return (float)livingBase.field_70173_aa + livingBase.tickOffset + partialTicks;
    }

    public ResourceLocation getEntityTexture(KiteEntity entity) {
        switch (entity.getColor()) {
            case 1: {
                this.color = "orange";
                break;
            }
            case 2: {
                this.color = "magenta";
                break;
            }
            case 3: {
                this.color = "light_blue";
                break;
            }
            case 4: {
                this.color = "yellow";
                break;
            }
            case 5: {
                this.color = "lime";
                break;
            }
            case 6: {
                this.color = "pink";
                break;
            }
            case 7: {
                this.color = "gray";
                break;
            }
            case 8: {
                this.color = "light_gray";
                break;
            }
            case 9: {
                this.color = "cyan";
                break;
            }
            case 10: {
                this.color = "purple";
                break;
            }
            case 11: {
                this.color = "blue";
                break;
            }
            case 12: {
                this.color = "brown";
                break;
            }
            case 13: {
                this.color = "green";
                break;
            }
            case 14: {
                this.color = "red";
                break;
            }
            case 15: {
                this.color = "black";
                break;
            }
            default: {
                this.color = "white";
            }
        }
        return new ResourceLocation("dannys_expansion:textures/entity/kite/" + this.color + "_kite.png");
    }

    public RenderType getPolygonRenderType() {
        return RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_wool.png"));
    }

    public RenderType getDesignRenderType(KiteEntity entity) {
        return RenderType.func_228644_e_((ResourceLocation)new ResourceLocation("dannys_expansion:textures/entity/kite/designs/" + entity.getDesign() + ".png"));
    }
}

