/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.entity.render.entity.kite;

import com.bottomtextdanny.dannys_expansion.client.animation.Easing;
import com.bottomtextdanny.dannys_expansion.client.animation.PolygonHelper;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.HugeHalfKiteModel;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.HugeKiteModel;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.KiteBaseModel;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.KiteModel;
import com.bottomtextdanny.dannys_expansion.client.entity.model.kite.LargeKiteModel;
import com.bottomtextdanny.dannys_expansion.common.Entities.kite.SpecialKiteEntity;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class SpecialKiteRenderer
extends EntityRenderer<SpecialKiteEntity> {
    protected final List<LayerRenderer<SpecialKiteEntity, KiteBaseModel<SpecialKiteEntity>>> layerRenderers = Lists.newArrayList();
    KiteBaseModel<SpecialKiteEntity> entityModel;

    public SpecialKiteRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    public final boolean addLayer(LayerRenderer<SpecialKiteEntity, KiteBaseModel<SpecialKiteEntity>> layer) {
        return this.layerRenderers.add(layer);
    }

    public void render(SpecialKiteEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.getModel() == 0) {
            this.entityModel = new KiteModel<SpecialKiteEntity>();
        } else if (entityIn.getModel() == 1) {
            this.entityModel = new LargeKiteModel<SpecialKiteEntity>();
        } else if (entityIn.getModel() == 3) {
            this.entityModel = new HugeHalfKiteModel<SpecialKiteEntity>();
        } else if (entityIn.getModel() == 4) {
            this.entityModel = new HugeKiteModel<SpecialKiteEntity>();
        }
        matrixStackIn.func_227860_a_();
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKiteYaw, (float)entityIn.kiteYaw) - 180.0f;
        float f2 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKitePitch, (float)entityIn.kitePitch);
        float ageInTicks = this.handleRotationFloat(entityIn, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        IVertexBuilder ivertexbuilder0 = bufferIn.getBuffer(this.getRender(entityIn));
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        this.entityModel.getPartialTick(partialTicks);
        this.entityModel.setRotationAngles(entityIn, 0.0f, 0.0f, (float)entityIn.field_70173_aa + partialTicks, f1, f2);
        this.entityModel.func_225598_a_(matrixStackIn, ivertexbuilder0, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerRenderer<SpecialKiteEntity, KiteBaseModel<SpecialKiteEntity>> layerrenderer : this.layerRenderers) {
            layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, 1.0f, 0.0f, partialTicks, ageInTicks, f1, f2);
        }
        if (entityIn.hasFullbrightLayer()) {
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(RenderType.func_239264_a_((ResourceLocation)new ResourceLocation("dannys_expansion", this.getEntityTexture(entityIn).func_110623_a().replaceFirst(".png", "_fullbright.png")), (float)0.5f));
            this.entityModel.func_225598_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.func_227865_b_();
        super.func_225623_a_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        float easedPosX = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70169_q, (double)entityIn.func_226277_ct_());
        float easedPosY = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70167_r, (double)entityIn.func_226278_cu_());
        float easedPosZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70166_s, (double)entityIn.func_226281_cx_());
        if (entityIn.getKnot() != null) {
            float knotEasedPosX = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70169_q, (double)entityIn.getKnot().func_226277_ct_());
            float knotEasedPosY = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70167_r, (double)entityIn.getKnot().func_226278_cu_());
            float knotEasedPosZ = (float)MathHelper.func_219803_d((double)partialTicks, (double)entityIn.getKnot().field_70166_s, (double)entityIn.getKnot().func_226281_cx_());
            matrixStackIn.func_227860_a_();
            float horizontalDistance = MathUtil.getHorizontalDistance(easedPosX, easedPosZ, knotEasedPosX, knotEasedPosZ);
            float verticalDistance = easedPosY - knotEasedPosY;
            float yawToKnot = MathUtil.getTargetYaw(easedPosX, easedPosZ, knotEasedPosX, knotEasedPosZ);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yawToKnot));
            matrixStackIn.func_227860_a_();
            IVertexBuilder ivertexbuilder2 = bufferIn.getBuffer(this.getCordRenderer(entityIn));
            PolygonHelper polygonHelper2 = new PolygonHelper(ivertexbuilder2, matrixStackIn, packedLightIn);
            float texPos = 0.015625f;
            int instances = 24;
            float yOffset = 0.0f;
            for (int i = 0; i < instances; ++i) {
                float uneasedProg = (float)(i + 1) / 23.0f;
                float prog = Easing.EASE_OUT_SQUARE.progression(uneasedProg) * verticalDistance;
                matrixStackIn.func_227860_a_();
                polygonHelper2.addQuadPair(new Vector3d((double)texPos, (double)(-prog), (double)(horizontalDistance / (float)instances)), new Vector3d((double)texPos, (double)(-yOffset), 0.0), new Vector3d((double)(-texPos), (double)(-yOffset), 0.0), new Vector3d((double)(-texPos), (double)(-prog), (double)(horizontalDistance / (float)instances)), 0.0f, 0.0f, texPos * 2.0f, horizontalDistance / (float)instances, new Quaternion(1.0f, 1.0f, 1.0f, 255.0f), packedLightIn);
                matrixStackIn.func_227861_a_(0.0, (double)(-prog), 0.0);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227860_a_();
                polygonHelper2.addQuadPair(new Vector3d(0.0, (double)(texPos - prog), (double)(horizontalDistance / (float)instances)), new Vector3d(0.0, (double)(texPos - yOffset), 0.0), new Vector3d(0.0, (double)(-texPos - yOffset), 0.0), new Vector3d(0.0, (double)(-texPos - prog), (double)(horizontalDistance / (float)instances)), 0.0f, 0.0f, texPos * 2.0f, horizontalDistance / (float)instances, new Quaternion(1.0f, 1.0f, 1.0f, 255.0f), packedLightIn);
                matrixStackIn.func_227861_a_(0.0, (double)(-prog), 0.0);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227861_a_(0.0, 0.0, (double)(horizontalDistance / (float)instances));
                yOffset = prog;
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }

    public void renderStatic(SpecialKiteEntity entityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        KiteBaseModel entityModel1 = null;
        if (entityIn.getModel() == 0) {
            entityModel1 = new KiteModel();
        } else if (entityIn.getModel() == 1) {
            entityModel1 = new LargeKiteModel();
        } else if (entityIn.getModel() == 3) {
            entityModel1 = new HugeHalfKiteModel();
        } else if (entityIn.getModel() == 4) {
            entityModel1 = new HugeKiteModel();
        }
        matrixStackIn.func_227860_a_();
        float f1 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKiteYaw, (float)entityIn.kiteYaw) - 180.0f;
        float f2 = MathHelper.func_219805_h((float)partialTicks, (float)entityIn.prevKitePitch, (float)entityIn.kitePitch);
        float ageInTicks = this.handleRotationFloat(entityIn, partialTicks);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f1));
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
        IVertexBuilder ivertexbuilder0 = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entityIn)));
        entityModel1.func_225598_a_(matrixStackIn, ivertexbuilder0, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (LayerRenderer<SpecialKiteEntity, KiteBaseModel<SpecialKiteEntity>> layerrenderer : this.layerRenderers) {
            layerrenderer.func_225628_a_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, 1.0f, 0.0f, partialTicks, ageInTicks, f1, f2);
        }
        if (entityIn.hasFullbrightLayer()) {
            IVertexBuilder ivertexbuilder1 = bufferIn.getBuffer(RenderType.func_239264_a_((ResourceLocation)new ResourceLocation("dannys_expansion", this.getEntityTexture(entityIn).func_110623_a().replaceFirst(".png", "_fullbright.png")), (float)0.5f));
            entityModel1.func_225598_a_(matrixStackIn, ivertexbuilder1, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        matrixStackIn.func_227865_b_();
        IVertexBuilder ivertexbuilder3 = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_wool.png")));
    }

    public boolean shouldRender(SpecialKiteEntity livingEntityIn, ClippingHelper camera, double camX, double camY, double camZ) {
        return true;
    }

    public RenderType getCordRenderer(SpecialKiteEntity entityIn) {
        return RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/block/white_wool.png"));
    }

    protected float handleRotationFloat(SpecialKiteEntity livingBase, float partialTicks) {
        return (float)livingBase.field_70173_aa + livingBase.tickOffset + partialTicks;
    }

    public RenderType getRender(SpecialKiteEntity entity) {
        return RenderType.func_228640_c_((ResourceLocation)this.getEntityTexture(entity));
    }

    public ResourceLocation getEntityTexture(SpecialKiteEntity entity) {
        return new ResourceLocation("dannys_expansion:textures/entity/kite/special/" + entity.getID() + ".png");
    }
}

