/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.gui;

import com.bottomtextdanny.dannys_expansion.client.gui.DannyWidget;
import com.bottomtextdanny.dannys_expansion.core.interfaces.ITypableWidget;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class DannyTextWidget
extends DannyWidget
implements ITypableWidget {
    private int pointerIndex;
    private int pointerPixelX;
    private int selectionPixelX;
    private boolean lockedSelection;
    private int selectionIndex;
    private String text = "";

    public DannyTextWidget(Screen screen, int x, int y, int width, ITextComponent title) {
        super(x, y, width, 20, title);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int outlineColor = 255;
        if (!this.func_230999_j_()) {
            outlineColor = 125;
        }
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buf.func_225582_a_((double)this.field_230690_l_, (double)(this.field_230691_m_ + this.field_230689_k_), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
        buf.func_225582_a_((double)(this.field_230690_l_ + this.field_230688_j_), (double)(this.field_230691_m_ + this.field_230689_k_), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
        buf.func_225582_a_((double)(this.field_230690_l_ + this.field_230688_j_), (double)this.field_230691_m_, 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
        buf.func_225582_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
        tess.func_78381_a();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buf.func_225582_a_((double)(this.field_230690_l_ + 1), (double)(this.field_230691_m_ + this.field_230689_k_ - 1), 0.0).func_225586_a_(10, 10, 10, 255).func_181675_d();
        buf.func_225582_a_((double)(this.field_230690_l_ + this.field_230688_j_ - 1), (double)(this.field_230691_m_ + this.field_230689_k_ - 1), 0.0).func_225586_a_(10, 10, 10, 255).func_181675_d();
        buf.func_225582_a_((double)(this.field_230690_l_ + this.field_230688_j_ - 1), (double)(this.field_230691_m_ + 1), 0.0).func_225586_a_(10, 10, 10, 255).func_181675_d();
        buf.func_225582_a_((double)(this.field_230690_l_ + 1), (double)(this.field_230691_m_ + 1), 0.0).func_225586_a_(10, 10, 10, 255).func_181675_d();
        tess.func_78381_a();
        if (!this.lockedSelection) {
            int[] sortedXs = this.sortedSelectionPointer();
            int startPos = sortedXs[0];
            int endPos = sortedXs[1];
            buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buf.func_225582_a_((double)(this.field_230690_l_ + startPos + 3), (double)(this.field_230691_m_ + this.field_230689_k_ - 3), 0.0).func_225586_a_(9, 9, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + endPos + 3), (double)(this.field_230691_m_ + this.field_230689_k_ - 3), 0.0).func_225586_a_(9, 9, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + endPos + 3), (double)(this.field_230691_m_ + 3), 0.0).func_225586_a_(9, 9, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + startPos + 3), (double)(this.field_230691_m_ + 3), 0.0).func_225586_a_(9, 9, outlineColor, 255).func_181675_d();
            tess.func_78381_a();
        }
        if (this.func_230999_j_()) {
            buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buf.func_225582_a_((double)(this.field_230690_l_ + 2 + this.pointerPixelX), (double)(this.field_230691_m_ + this.field_230689_k_ - 3), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + this.pointerPixelX + 3), (double)(this.field_230691_m_ + this.field_230689_k_ - 3), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + this.pointerPixelX + 3), (double)(this.field_230691_m_ + 3), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
            buf.func_225582_a_((double)(this.field_230690_l_ + 2 + this.pointerPixelX), (double)(this.field_230691_m_ + 3), 0.0).func_225586_a_(outlineColor, outlineColor, outlineColor, 255).func_181675_d();
            tess.func_78381_a();
        }
        DannyTextWidget.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)this.field_230690_l_, (int)(this.field_230691_m_ - 10), (int)0xFFFFFF);
        DannyTextWidget.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.text, (int)(this.field_230690_l_ + 3), (int)(this.field_230691_m_ + 6), (int)0xFFFFFF);
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        super.func_230982_a_(mouseX, mouseY);
    }

    protected void func_230983_a_(double mouseX, double mouseY, double dragX, double dragY) {
        super.func_230983_a_(mouseX, mouseY, dragX, dragY);
        int start = this.field_230690_l_ + 3;
        int distanceToStart = MathHelper.func_76128_c((double)mouseX) - start;
        if (distanceToStart > 0) {
            this.setSelectionIndex(Minecraft.func_71410_x().field_71466_p.func_238412_a_(this.text, distanceToStart).length());
        } else {
            this.setSelectionIndex(0);
        }
        if (this.selectionPixelX != this.pointerPixelX) {
            this.lockedSelection = false;
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.lockedSelection = true;
        if (this.insideBounds(mouseX, mouseY)) {
            if (!this.func_230999_j_() && this.focusParameters()) {
                this.func_230996_d_(true);
                this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
            }
            int start = this.field_230690_l_ + 3;
            int distanceToStart = MathHelper.func_76128_c((double)mouseX) - start;
            if (distanceToStart > 0) {
                this.setPointerIndex(Minecraft.func_71410_x().field_71466_p.func_238412_a_(this.text, distanceToStart).length());
            } else {
                this.setPointerIndex(0);
            }
        } else if (!this.insideAllPossibleBounds(mouseX, mouseY) && this.func_230999_j_()) {
            this.onMiss();
            this.func_230996_d_(false);
            this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
        }
        if (this.field_230693_o_ && this.field_230694_p_) {
            boolean flag;
            if (this.func_230987_a_(button) && (flag = this.func_230992_c_(mouseX, mouseY))) {
                this.func_230982_a_(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.func_230999_j_()) {
            if (Screen.func_231168_h_((int)keyCode)) {
                if (!this.lockedSelection) {
                    this.deleteCharFrom2Indices(this.selectionIndex, this.pointerIndex);
                    this.lockedSelection = true;
                }
                this.injectString(Minecraft.func_71410_x().field_195559_v.func_197965_a(), this.pointerIndex);
            }
            if (!this.lockedSelection) {
                if (Screen.func_231169_i_((int)keyCode)) {
                    Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getSelectedText());
                }
                if (keyCode == 259 && this.selectionOffset() != 0) {
                    this.deleteCharFrom2Indices(this.selectionIndex, this.pointerIndex);
                    this.lockedSelection = true;
                }
                if (keyCode == 262) {
                    if (!Screen.func_231173_s_()) {
                        this.lockedSelection = true;
                    }
                    if (Screen.func_231172_r_()) {
                        this.setPointerIndex(this.getBoundIndex(this.pointerIndex, true));
                    } else {
                        this.setPointerIndex(this.pointerIndex + 1);
                    }
                }
                if (keyCode == 263) {
                    if (!Screen.func_231173_s_()) {
                        this.lockedSelection = true;
                    }
                    if (Screen.func_231172_r_()) {
                        this.setPointerIndex(this.getBoundIndex(this.pointerIndex, false));
                    } else {
                        this.setPointerIndex(this.pointerIndex - 1);
                    }
                }
            } else if (this.text.length() > 0) {
                switch (keyCode) {
                    case 259: {
                        if (Screen.func_231172_r_()) {
                            this.deleteCharFrom2Indices(this.getBoundIndex(this.pointerIndex, false), this.pointerIndex);
                            break;
                        }
                        this.deleteCharFromIndex(this.pointerIndex);
                        break;
                    }
                    case 261: {
                        if (Screen.func_231172_r_()) {
                            this.deleteCharFrom2Indices(this.getBoundIndex(this.pointerIndex, true), this.pointerIndex);
                            break;
                        }
                        this.deleteCharFromIndex(this.pointerIndex + 1);
                        break;
                    }
                    case 262: {
                        if (Screen.func_231173_s_()) {
                            this.setSelectionIndex(this.pointerIndex);
                            this.lockedSelection = false;
                        }
                        if (Screen.func_231172_r_()) {
                            this.setPointerIndex(this.getBoundIndex(this.pointerIndex, true));
                            break;
                        }
                        this.setPointerIndex(this.pointerIndex + 1);
                        break;
                    }
                    case 263: {
                        if (Screen.func_231173_s_()) {
                            this.setSelectionIndex(this.pointerIndex);
                            this.lockedSelection = false;
                        }
                        if (Screen.func_231172_r_()) {
                            this.setPointerIndex(this.getBoundIndex(this.pointerIndex, false));
                            break;
                        }
                        this.setPointerIndex(this.pointerIndex - 1);
                        break;
                    }
                }
            }
        }
        return false;
    }

    public boolean focusParameters() {
        return true;
    }

    public void onMiss() {
    }

    public boolean func_231042_a_(char codePoint, int modifiers) {
        if (!this.func_230999_j_()) {
            return false;
        }
        if (SharedConstants.func_71566_a((char)codePoint)) {
            if (!this.lockedSelection) {
                this.deleteCharFrom2Indices(this.selectionIndex, this.pointerIndex);
                this.lockedSelection = true;
            }
            this.injectString(Character.toString(codePoint), this.pointerIndex);
            return true;
        }
        return false;
    }

    public void setPointerIndex(int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.text.length()) {
            index = this.text.length();
        }
        this.pointerIndex = index;
        this.pointerIndexChanged();
    }

    public void pointerIndexChanged() {
        this.pointerPixelX = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text.substring(0, this.pointerIndex));
    }

    public void setSelectionIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        this.selectionIndex = index;
        this.selectionIndexChanged();
    }

    public void selectionIndexChanged() {
        this.selectionPixelX = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text.substring(0, this.selectionIndex));
    }

    public void textChanged() {
        if (this.pointerIndex > this.text.length()) {
            this.setPointerIndex(this.text.length());
        }
        if (this.selectionIndex > this.text.length()) {
            this.setSelectionIndex(this.text.length());
        }
        if (Minecraft.func_71410_x().field_71466_p.func_78256_a(this.text) > this.field_230688_j_ - 6) {
            this.text = Minecraft.func_71410_x().field_71466_p.func_238412_a_(this.text, this.field_230688_j_ - 6);
        }
    }

    public void setText(String newText) {
        this.text = newText;
        this.textChanged();
    }

    public void injectString(CharSequence str, int index) {
        String start = this.text.substring(0, index) + str;
        String end = this.text.substring(index);
        if (!this.lockedSelection) {
            this.deleteCharFrom2Indices(this.selectionIndex, this.pointerIndex);
            this.lockedSelection = true;
        }
        this.setText(start + end);
        if (index >= this.pointerIndex) {
            this.setPointerIndex(this.pointerIndex + str.length());
        }
    }

    public boolean deleteCharFromIndex(int index) {
        if (index <= 0) {
            return false;
        }
        if (index > this.text.length()) {
            return false;
        }
        int i = 0;
        if (index <= this.pointerIndex) {
            ++i;
        }
        this.setPointerIndex(this.pointerIndex - i);
        String start = this.text.substring(0, index - 1);
        String end = this.text.substring(index);
        this.setText(start + end);
        return true;
    }

    public boolean deleteCharFrom2Indices(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            String start = this.text.substring(0, endIndex);
            String end = this.text.substring(startIndex);
            this.setText(start + end);
            return false;
        }
        String start = this.text.substring(0, startIndex);
        String end = this.text.substring(endIndex);
        this.setPointerIndex(this.pointerIndex - (endIndex - startIndex));
        this.setText(start + end);
        return true;
    }

    public int getBoundIndex(int index, boolean forward) {
        int mod = forward ? 1 : -1;
        return this.getNthWordFromPosWS(mod, index, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public int selectionOffset() {
        return this.pointerIndex + this.pointerIndex - this.selectionIndex;
    }

    public int[] sortedSelectionPointer() {
        int[] buf = new int[2];
        if (this.pointerIndex > this.selectionIndex) {
            buf[0] = this.selectionPixelX;
            buf[1] = this.pointerPixelX;
        } else {
            buf[0] = this.pointerPixelX;
            buf[1] = this.selectionPixelX;
        }
        return buf;
    }

    public String getSelectedText() {
        int i = Math.min(this.pointerIndex, this.selectionIndex);
        int j = Math.max(this.pointerIndex, this.selectionIndex);
        return this.text.substring(i, j);
    }

    public String getText() {
        return this.text;
    }

    public boolean checkIndex(int index) {
        return index >= 0 && index < this.text.length();
    }
}

