/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.gui.screen;

import com.bottomtextdanny.dannys_expansion.client.RenderUtils;
import com.bottomtextdanny.dannys_expansion.common.Inventory.WorkbenchContainer;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.Pair;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchCraft;
import com.bottomtextdanny.dannys_expansion.core.misc.WorkbenchIngredient;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class WorkbenchScreen
extends ContainerScreen<WorkbenchContainer> {
    private static final ResourceLocation WORKBENCH_TEXTURE = new ResourceLocation("dannys_expansion:textures/gui/container/workbench.png");
    private int timesInventoryChanged;
    private int startColumnRender;
    private Pair<WorkbenchCraft, CraftState> selectedRecipe = Pair.of(WorkbenchCraft.EMPTY, CraftState.UNCRAFTABLE);
    public TranslationTextComponent name;

    public WorkbenchScreen(WorkbenchContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.timesInventoryChanged = inv.func_194015_p();
        this.name = new TranslationTextComponent("container.workbench");
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(WORKBENCH_TEXTURE);
        WorkbenchScreen.func_238464_a_((MatrixStack)matrixStack, (int)(this.field_230708_k_ / 2 - 120), (int)(this.field_230709_l_ / 2 - 119), (int)0, (float)0.0f, (float)0.0f, (int)240, (int)238, (int)512, (int)512);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.field_230712_o_.func_228079_a_(this.field_213127_e.func_145748_c_().getString(), (float)(this.field_230708_k_ / 2 - 80), (float)(this.field_230709_l_ / 2 + 24), 0x404040, false, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
        this.field_230712_o_.func_228079_a_(this.name.getString(), (float)(this.field_230708_k_ / 2 - 98), (float)(this.field_230709_l_ / 2 - 110), 0x404040, false, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
        renderTypeBuffer.func_228461_a_();
        if (this.selectedRecipe.getKey() != WorkbenchCraft.EMPTY) {
            int x = this.field_230708_k_ / 2 - 72;
            int y = this.field_230709_l_ / 2 - 90;
            for (WorkbenchIngredient ingredient : this.selectedRecipe.getKey().getIngredients()) {
                ItemStack stack = new ItemStack((IItemProvider)ingredient.getItem());
                String s = "(" + ingredient.getCount() + ")";
                Minecraft.func_71410_x().func_175599_af().func_175042_a(stack, x += MathHelper.func_76125_a((int)(this.field_230712_o_.func_78256_a(s) / 2), (int)8, (int)64), y);
                IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                this.field_230712_o_.func_228079_a_(s, (float)(x + 8 - this.field_230712_o_.func_78256_a(s) / 2), (float)(y + 16), 0xFFFFFF, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                irendertypebuffer$impl.func_228461_a_();
                if (this.isMouseOver(mouseX, mouseY, x, y, 16, 16)) {
                    this.func_243308_b(matrixStack, stack.func_82840_a(this.field_213127_e.field_70458_d, (ITooltipFlag)tooltipFlag), x, y);
                }
                x += MathHelper.func_76125_a((int)(this.field_230712_o_.func_78256_a(s) / 2), (int)8, (int)64) + 2;
            }
            if (this.selectedRecipe.getValue() != CraftState.CRAFTABLE) {
                RenderUtils.renderItemModelIntoGUI(this.selectedRecipe.getKey().getResult(), this.field_230708_k_ / 2 - 90, this.field_230709_l_ / 2 - 90, 171437);
                RenderUtils.renderItemOverlayIntoGUI(this.field_230712_o_, this.selectedRecipe.getKey().getResult(), this.field_230708_k_ / 2 - 90, this.field_230709_l_ / 2 - 90, null, 0x8E8E8E, 0);
                if (this.isMouseOver(mouseX, mouseY, this.field_230708_k_ / 2 - 90, this.field_230709_l_ / 2 - 90, 16, 16)) {
                    this.func_243308_b(matrixStack, this.selectedRecipe.getKey().getResult().func_82840_a(this.field_213127_e.field_70458_d, (ITooltipFlag)tooltipFlag), mouseX, mouseY);
                }
            }
        }
        if (this.getSlotUnderMouse() != null && this.getSlotUnderMouse().func_75211_c() != ItemStack.field_190927_a) {
            this.func_243308_b(matrixStack, this.getSlotUnderMouse().func_75211_c().func_82840_a(this.field_213127_e.field_70458_d, (ITooltipFlag)tooltipFlag), mouseX, mouseY);
        }
        for (Widget button : this.field_230710_m_) {
            if (!button.func_231047_b_((double)mouseX, (double)mouseY)) continue;
            button.func_230443_a_(matrixStack, mouseX, mouseY);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.selectedRecipe.getKey() != WorkbenchCraft.EMPTY && ((WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA).getItemStackResult() != this.selectedRecipe.getKey().getResult()) {
            if (this.selectedRecipe.getValue() == CraftState.CRAFTABLE) {
                DENetwork.setWorkbenchResult(this.field_213127_e.field_70458_d, this.selectedRecipe.getKey());
                ((WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA).result = this.selectedRecipe.getKey();
            } else {
                DENetwork.setWorkbenchResult(this.field_213127_e.field_70458_d, WorkbenchCraft.EMPTY);
                ((WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA).result = WorkbenchCraft.EMPTY;
            }
            ((WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA).onResultUpdate();
        }
        if (this.timesInventoryChanged != this.field_213127_e.func_194015_p()) {
            DENetwork.updateInventory(this.field_213127_e.field_70458_d);
            ((WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA).onPlayerInventoryUpdate();
            this.drawButtons();
            this.timesInventoryChanged = this.field_213127_e.func_194015_p();
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        WorkbenchContainer container = (WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA;
        int size = container.craftableRecipes.size() + container.semiCraftableRecipes.size() + container.uncraftableRecipes.size() - 3;
        if (delta < 0.0 && (float)(this.startColumnRender + 3) < (float)size / 11.0f) {
            ++this.startColumnRender;
            this.drawButtons();
        } else if (delta > 0.0 && this.startColumnRender > 0) {
            --this.startColumnRender;
            this.drawButtons();
        }
        return false;
    }

    public void drawButtons() {
        WorkbenchContainer container = (WorkbenchContainer)this.field_213127_e.field_70458_d.field_71070_bA;
        ArrayList recipes = Lists.newArrayList(container.craftableRecipes);
        recipes.addAll(container.semiCraftableRecipes);
        recipes.addAll(container.uncraftableRecipes);
        List renderedRecipes = recipes.subList(Math.max(0, this.startColumnRender * 11), Math.min(this.startColumnRender * 11 + 44, recipes.size()));
        Pair<WorkbenchCraft, CraftState> selected = this.selectedRecipe;
        int xOffset = 0;
        int yOffset = 1;
        int counter = 0;
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        for (Pair recipe : recipes) {
            if (recipe.getKey() != selected.getKey() || recipe.getValue() == selected.getValue()) continue;
            this.selectedRecipe = recipe;
        }
        for (Pair recipe : renderedRecipes) {
            while (yOffset * 10 < xOffset) {
                ++yOffset;
                xOffset -= 11;
            }
            RecipeButton button = new RecipeButton(this.field_230708_k_ / 2 - 99 + counter % 11 * 18, this.field_230709_l_ / 2 - 34 + (MathHelper.func_76141_d((float)((float)counter / 11.0f)) - 1) * 18, (WorkbenchCraft)recipe.getKey(), (CraftState)((Object)recipe.getValue()));
            this.func_230480_a_((Widget)button);
            ++xOffset;
            ++counter;
        }
    }

    public static enum CraftState {
        CRAFTABLE,
        SEMI,
        UNCRAFTABLE;

    }

    class RecipeButton
    extends AbstractButton {
        private WorkbenchCraft recipe;
        private CraftState state;

        protected RecipeButton(int x, int y, WorkbenchCraft recipe, CraftState uncraftable) {
            this(x, y, recipe);
            this.state = uncraftable;
        }

        protected RecipeButton(int x, int y, WorkbenchCraft recipe) {
            super(x, y, 18, 18, StringTextComponent.field_240750_d_);
            this.recipe = recipe;
        }

        public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WORKBENCH_TEXTURE);
            if (this.state != CraftState.CRAFTABLE) {
                if (this.state == CraftState.SEMI) {
                    if (this.isSelected()) {
                        RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)240.0f, (float)36.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    } else {
                        RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)240.0f, (float)18.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    }
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1);
                    Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1, null);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(WORKBENCH_TEXTURE);
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.alphaFunc((int)516, (float)0.0f);
                    RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)10, (float)294.0f, (float)18.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    RenderSystem.disableBlend();
                    RenderSystem.enableDepthTest();
                } else {
                    if (this.isSelected()) {
                        RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)258.0f, (float)36.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    } else {
                        RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)258.0f, (float)18.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    }
                    Minecraft.func_71410_x().func_175599_af().func_175042_a(this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1);
                    Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1, null);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(WORKBENCH_TEXTURE);
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.alphaFunc((int)516, (float)0.0f);
                    RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)10, (float)276.0f, (float)18.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                    RenderSystem.disableBlend();
                    RenderSystem.enableDepthTest();
                }
            } else {
                if (this.isSelected()) {
                    RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)240.0f, (float)72.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                } else {
                    RecipeButton.func_238464_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (float)240.0f, (float)54.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)512, (int)512);
                }
                Minecraft.func_71410_x().func_175599_af().func_175042_a(this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1);
                Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, this.recipe.getResult(), this.field_230690_l_ + 1, this.field_230691_m_ + 1, null);
            }
        }

        public void func_230443_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
            ITooltipFlag.TooltipFlags tooltipFlag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            WorkbenchScreen.this.func_243308_b(matrixStack, this.recipe.getResult().func_82840_a(((WorkbenchScreen)WorkbenchScreen.this).field_213127_e.field_70458_d, (ITooltipFlag)tooltipFlag), this.field_230690_l_ + 10, this.field_230691_m_ - 11);
            super.func_230443_a_(matrixStack, mouseX, mouseY);
        }

        public boolean isSelected() {
            return this.recipe.equals(WorkbenchScreen.this.selectedRecipe.getKey());
        }

        public void setSelected() {
            WorkbenchScreen.this.selectedRecipe = Pair.of(this.recipe, this.state);
        }

        public boolean func_231047_b_(double mouseX, double mouseY) {
            return super.func_231047_b_(mouseX, mouseY);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.field_230693_o_ && this.field_230694_p_) {
                boolean flag;
                if (this.func_230987_a_(button) && (flag = this.func_230992_c_(mouseX, mouseY))) {
                    if (!this.isSelected()) {
                        this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
                        this.func_230982_a_(mouseX, mouseY);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }

        public void func_230930_b_() {
            WorkbenchContainer container = (WorkbenchContainer)((WorkbenchScreen)WorkbenchScreen.this).field_213127_e.field_70458_d.field_71070_bA;
            if (!this.isSelected()) {
                this.setSelected();
                if (container.getItemStackResult() != ((WorkbenchCraft)WorkbenchScreen.this.selectedRecipe.getKey()).getResult()) {
                    container.result = this.state == CraftState.CRAFTABLE ? (WorkbenchCraft)WorkbenchScreen.this.selectedRecipe.getKey() : WorkbenchCraft.EMPTY;
                    container.onResultUpdate();
                }
            }
        }
    }
}

