/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.client.shader;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    public int programId;
    public int vertexShader;
    public int fragmentShader;

    public ShaderProgram(String vertexPath, String fragmentPath) {
        String vertexShaderSource = ShaderProgram.loadShaderSource(vertexPath);
        String fragmentShaderSource = ShaderProgram.loadShaderSource(fragmentPath);
        this.vertexShader = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)this.vertexShader, (CharSequence)vertexShaderSource);
        GL20.glCompileShader((int)this.vertexShader);
        this.fragmentShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)this.fragmentShader, (CharSequence)fragmentShaderSource);
        GL20.glCompileShader((int)this.fragmentShader);
        this.programId = GL20.glCreateProgram();
    }

    public void link() {
        GL20.glAttachShader((int)this.programId, (int)this.vertexShader);
        GL20.glAttachShader((int)this.programId, (int)this.fragmentShader);
        GL20.glLinkProgram((int)this.programId);
        GL20.glValidateProgram((int)this.programId);
    }

    public void use() {
        GL20.glUseProgram((int)this.programId);
    }

    public void delete() {
        GL20.glDeleteShader((int)this.vertexShader);
        GL20.glDeleteShader((int)this.fragmentShader);
    }

    public void setBool(String name, boolean value) {
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (int)(value ? 1 : 0));
    }

    public void setInt(String name, int value) {
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (int)value);
    }

    public void setFloat(String name, float value) {
        GL20.glUniform1f((int)GL20.glGetUniformLocation((int)this.programId, (CharSequence)name), (float)value);
    }

    public void setVec3(String name, Vector3f value) {
        int transformLoc = GL20.glGetUniformLocation((int)this.programId, (CharSequence)name);
        GL20.glUniform3f((int)transformLoc, (float)value.func_195899_a(), (float)value.func_195900_b(), (float)value.func_195902_c());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String loadShaderSource(String path) {
        try (InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("dannys_expansion:shaders/" + path)).func_199027_b();){
            Scanner scanner = new Scanner(in, StandardCharsets.UTF_8.name());
            try {
                String string = scanner.useDelimiter("\\A").next();
                scanner.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

