/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Blocks.chest;

import com.bottomtextdanny.dannys_expansion.common.TileEntities.DannyChestTileEntity;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DannyChestBlock
extends AbstractChestBlock<DannyChestTileEntity> {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.field_208140_ao;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SHAPE_SINGLE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final TileEntityMerger.ICallback<DannyChestTileEntity, Optional<IInventory>> INVENTORY_MERGER = new TileEntityMerger.ICallback<DannyChestTileEntity, Optional<IInventory>>(){

        public Optional<IInventory> func_225539_a_(DannyChestTileEntity p_225539_1_, DannyChestTileEntity p_225539_2_) {
            return Optional.of(new DoubleSidedInventory((IInventory)p_225539_1_, (IInventory)p_225539_2_));
        }

        public Optional<IInventory> func_225538_a_(DannyChestTileEntity p_225538_1_) {
            return Optional.of(p_225538_1_);
        }

        public Optional<IInventory> func_225537_b_() {
            return Optional.empty();
        }
    };
    private static final TileEntityMerger.ICallback<DannyChestTileEntity, Optional<INamedContainerProvider>> CONTAINER_MERGER = new TileEntityMerger.ICallback<DannyChestTileEntity, Optional<INamedContainerProvider>>(){

        public Optional<INamedContainerProvider> func_225539_a_(final DannyChestTileEntity p_225539_1_, final DannyChestTileEntity p_225539_2_) {
            DoubleSidedInventory iinventory = new DoubleSidedInventory((IInventory)p_225539_1_, (IInventory)p_225539_2_);
            return Optional.of(new INamedContainerProvider(){
                final /* synthetic */ IInventory val$iinventory;
                {
                    this.val$iinventory = iInventory;
                }

                @Nullable
                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    if (p_225539_1_.func_213904_e(p_createMenu_3_) && p_225539_2_.func_213904_e(p_createMenu_3_)) {
                        p_225539_1_.func_184281_d(p_createMenu_2_.field_70458_d);
                        p_225539_2_.func_184281_d(p_createMenu_2_.field_70458_d);
                        return ChestContainer.func_216984_b((int)p_createMenu_1_, (PlayerInventory)p_createMenu_2_, (IInventory)this.val$iinventory);
                    }
                    return null;
                }

                public ITextComponent func_145748_c_() {
                    if (p_225539_1_.func_145818_k_()) {
                        return p_225539_1_.func_145748_c_();
                    }
                    return p_225539_2_.func_145818_k_() ? p_225539_2_.func_145748_c_() : new TranslationTextComponent("container.chestDouble");
                }
            });
        }

        public Optional<INamedContainerProvider> func_225538_a_(DannyChestTileEntity p_225538_1_) {
            return Optional.of(p_225538_1_);
        }

        public Optional<INamedContainerProvider> func_225537_b_() {
            return Optional.empty();
        }
    };
    String texture;

    public DannyChestBlock(AbstractBlock.Properties builder, String texture, Supplier<TileEntityType<? extends DannyChestTileEntity>> tileEntityTypeIn) {
        super(builder, tileEntityTypeIn);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(TYPE, (Comparable)ChestType.SINGLE)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.texture = texture;
    }

    public String getTexture() {
        return this.texture;
    }

    public static TileEntityMerger.Type getChestMergerType(BlockState state) {
        ChestType chesttype = (ChestType)state.func_177229_b(TYPE);
        if (chesttype == ChestType.SINGLE) {
            return TileEntityMerger.Type.SINGLE;
        }
        return chesttype == ChestType.RIGHT ? TileEntityMerger.Type.FIRST : TileEntityMerger.Type.SECOND;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facingState.func_203425_a((Block)this) && facing.func_176740_k().func_176722_c()) {
            ChestType chesttype = (ChestType)facingState.func_177229_b(TYPE);
            if (stateIn.func_177229_b(TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && stateIn.func_177229_b((Property)FACING) == facingState.func_177229_b((Property)FACING) && DannyChestBlock.getDirectionToAttached(facingState) == facing.func_176734_d()) {
                return (BlockState)stateIn.func_206870_a(TYPE, (Comparable)chesttype.func_208081_a());
            }
        } else if (DannyChestBlock.getDirectionToAttached(stateIn) == facing) {
            return (BlockState)stateIn.func_206870_a(TYPE, (Comparable)ChestType.SINGLE);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(TYPE) == ChestType.SINGLE) {
            return SHAPE_SINGLE;
        }
        switch (DannyChestBlock.getDirectionToAttached(state)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case EAST: 
        }
        return SHAPE_EAST;
    }

    public static Direction getDirectionToAttached(BlockState state) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return state.func_177229_b(TYPE) == ChestType.LEFT ? direction.func_176746_e() : direction.func_176735_f();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction2;
        ChestType chesttype = ChestType.SINGLE;
        Direction direction = context.func_195992_f().func_176734_d();
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = context.func_225518_g_();
        Direction direction1 = context.func_196000_l();
        if (direction1.func_176740_k().func_176722_c() && flag && (direction2 = this.getDirectionToAttach(context, direction1.func_176734_d())) != null && direction2.func_176740_k() != direction1.func_176740_k()) {
            direction = direction2;
            ChestType chestType = chesttype = direction2.func_176735_f() == direction1.func_176734_d() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (chesttype == ChestType.SINGLE && !flag) {
            if (direction == this.getDirectionToAttach(context, direction.func_176746_e())) {
                chesttype = ChestType.LEFT;
            } else if (direction == this.getDirectionToAttach(context, direction.func_176735_f())) {
                chesttype = ChestType.RIGHT;
            }
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a(TYPE, (Comparable)chesttype)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Nullable
    private Direction getDirectionToAttach(BlockItemUseContext context, Direction direction) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(direction));
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b(TYPE) == ChestType.SINGLE ? (Direction)blockstate.func_177229_b((Property)FACING) : null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof DannyChestTileEntity) {
            ((DannyChestTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, worldIn, pos);
        if (inamedcontainerprovider != null) {
            player.func_213829_a(inamedcontainerprovider);
            player.func_71029_a(this.getOpenStat());
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
        }
        return ActionResultType.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenStat() {
        return Stats.field_199092_j.func_199076_b((Object)Stats.field_188063_ac);
    }

    @Nullable
    public static IInventory getChestInventory(DannyChestBlock chest, BlockState state, World world, BlockPos pos, boolean override) {
        return ((Optional)chest.func_225536_a_(state, world, pos, override).apply(INVENTORY_MERGER)).orElse(null);
    }

    public TileEntityMerger.ICallbackWrapper<? extends DannyChestTileEntity> func_225536_a_(BlockState state, World world, BlockPos pos, boolean override) {
        BiPredicate<IWorld, BlockPos> bipredicate = override ? (worldIn, posIn) -> false : ChestBlock::func_220108_a;
        return TileEntityMerger.func_226924_a_((TileEntityType)((TileEntityType)this.field_226859_a_.get()), ChestBlock::func_226919_h_, ChestBlock::func_196311_i, (DirectionProperty)FACING, (BlockState)state, (IWorld)world, (BlockPos)pos, bipredicate);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return ((Optional)this.func_225536_a_(state, worldIn, pos, false).apply(CONTAINER_MERGER)).orElse(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TileEntityMerger.ICallback<DannyChestTileEntity, Float2FloatFunction> getLidRotationCallback(final IChestLid lid) {
        return new TileEntityMerger.ICallback<DannyChestTileEntity, Float2FloatFunction>(){

            public Float2FloatFunction func_225539_a_(DannyChestTileEntity p_225539_1_, DannyChestTileEntity p_225539_2_) {
                return angle -> Math.max(p_225539_1_.func_195480_a(angle), p_225539_2_.func_195480_a(angle));
            }

            public Float2FloatFunction func_225538_a_(DannyChestTileEntity p_225538_1_) {
                return arg_0 -> ((DannyChestTileEntity)p_225538_1_).func_195480_a(arg_0);
            }

            public Float2FloatFunction func_225537_b_() {
                return arg_0 -> ((IChestLid)lid).func_195480_a(arg_0);
            }
        };
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)this.field_226859_a_.get()).func_200968_a();
    }

    public static boolean isBlocked(IWorld world, BlockPos pos) {
        return DannyChestBlock.isBelowSolidBlock((IBlockReader)world, pos) || DannyChestBlock.isCatSittingOn(world, pos);
    }

    private static boolean isBelowSolidBlock(IBlockReader reader, BlockPos worldIn) {
        BlockPos blockpos = worldIn.func_177984_a();
        return reader.func_180495_p(blockpos).func_215686_e(reader, blockpos);
    }

    private static boolean isCatSittingOn(IWorld world, BlockPos pos) {
        List list = world.func_217357_a(CatEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)));
        if (!list.isEmpty()) {
            for (CatEntity catentity : list) {
                if (!catentity.func_233684_eK_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)DannyChestBlock.getChestInventory(this, blockState, worldIn, pos, false));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

