/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.bullet;

import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.DannyRayTraceHelper;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IAttachEntities;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IClientManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractBulletEntity
extends Entity
implements IAttachEntities,
IClientManager {
    protected static final DataParameter<Optional<UUID>> ORIGIN_UUID = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> BULLET_DAMAGE = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> BULLET_SPEED = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> BULLET_SPEED_MULT = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> MAX_LIFE_TICKS = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> CURRENT_LIFE_TICKS = EntityDataManager.func_187226_a(AbstractBulletEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public SimpleMotion acceleration = new SimpleMotion(0.95f);
    public boolean soundPlayed;
    public boolean waterSplashSoundPlayer;
    private final List<Entity> attachedEntities = Arrays.asList(new Entity[1000]);
    public float prevDifference;
    public float difference;

    public AbstractBulletEntity(EntityType<? extends AbstractBulletEntity> entityTypeIn, World worldIn, int lifetime) {
        super(entityTypeIn, worldIn);
        this.setMaxLifeTicks(lifetime);
    }

    public AbstractBulletEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ORIGIN_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(MAX_LIFE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(CURRENT_LIFE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(BULLET_DAMAGE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BULLET_SPEED, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BULLET_SPEED_MULT, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("Origin")) {
            this.setOriginUUID(compound.func_186857_a("Origin"));
        }
        this.setMaxLifeTicks(compound.func_74762_e("MaxLifeTicks"));
        this.setCurrentLifeTicks(compound.func_74762_e("CurrentLifeTicks"));
        this.setBulletDamage(compound.func_74760_g("BulletDamage"));
        this.setBulletSpeed(compound.func_74760_g("BulletSpeed"));
        this.setBulletSpeedMult(compound.func_74760_g("BulletSpeedMult"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        this.getOriginUUID().ifPresent(uuid -> compound.func_186854_a("Origin", this.getOriginUUID().get()));
        compound.func_74768_a("MaxLifeTicks", this.getMaxLifeTicks());
        compound.func_74768_a("CurrentLifeTicks", this.getCurrentLifeTicks());
        compound.func_74776_a("BulletDamage", this.getBulletDamage());
        compound.func_74776_a("BulletSpeed", this.getBulletSpeed());
        compound.func_74776_a("BulletSpeedMult", this.getBulletSpeedMult());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key == ORIGIN_UUID) {
            this.getOriginUUID().ifPresent(uuid -> DENetwork.attachEntity(0, this, this.getOriginUUID().get()));
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70145_X = true;
        this.acceleration.tick();
        this.prevDifference = this.difference;
        this.difference = MathUtil.getDistance(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70169_q, this.field_70167_r, this.field_70166_s);
        if (this.getCurrentLifeTicks() < this.getMaxLifeTicks()) {
            this.setCurrentLifeTicks(this.getCurrentLifeTicks() + 1);
        } else {
            this.onDeath();
            this.func_241204_bJ_();
        }
        if (!this.canceledMovement()) {
            Vector3d forward = Vector3d.func_189986_a((float)this.field_70125_A, (float)this.field_70177_z);
            Vector3d nextPosition = this.func_213303_ch().func_72441_c((double)this.getRealSpeed() * forward.field_72450_a, (double)this.getRealSpeed() * forward.field_72448_b, (double)this.getRealSpeed() * forward.field_72449_c);
            BlockPos nextBlockPosition = new BlockPos((int)nextPosition.field_72450_a, (int)nextPosition.field_72448_b, (int)nextPosition.field_72449_c);
            if (this.field_70170_p.func_195588_v(nextBlockPosition)) {
                this.func_213315_a(MoverType.SELF, this.acceleration.getAcceleratedMotion());
            } else {
                this.func_241204_bJ_();
            }
            if (!this.field_70122_E) {
                this.acceleration.setMotion((double)this.getRealSpeed() * forward.field_72450_a, (double)this.getRealSpeed() * forward.field_72448_b, (double)this.getRealSpeed() * forward.field_72449_c);
            }
        }
        RayTraceResult raytraceresult = this.rayTraceResultType();
        this.onImpact(raytraceresult);
        this.func_145775_I();
    }

    protected void onImpact(RayTraceResult result) {
        RayTraceResult.Type type = result.func_216346_c();
        if (type == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() != this.getOrigin()) {
            this.onEntityHit((EntityRayTraceResult)result);
        } else if (type == RayTraceResult.Type.BLOCK) {
            this.onBlockHit((BlockRayTraceResult)result);
        }
    }

    public void onDeath() {
    }

    protected void onBlockHit(BlockRayTraceResult result) {
        Block block = this.field_70170_p.func_180495_p(result.func_216350_a()).func_177230_c();
        SoundEvent breakSound = this.field_70170_p.func_180495_p(result.func_216350_a()).func_215695_r().func_185845_c();
        if (this.field_70170_p.func_204610_c(result.func_216350_a()).func_206886_c() == Fluids.field_204546_a) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_WATER.get(), SoundCategory.NEUTRAL, 0.6f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
            this.waterSplashSoundPlayer = true;
        } else if (breakSound == SoundEvents.field_187835_fT || block.getTags().stream().anyMatch(res -> res.equals((Object)Tags.Blocks.STONE.func_230234_a_()))) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_STONE.get(), SoundCategory.NEUTRAL, 0.6f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.field_187561_bM || block.getTags().stream().anyMatch(res -> res.equals((Object)Tags.Blocks.GLASS.func_230234_a_()))) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_GLASS.get(), SoundCategory.NEUTRAL, 0.6f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.field_187571_bR || breakSound == SoundEvents.field_187581_bW || block.getTags().stream().anyMatch(res -> res.equals((Object)Tags.Blocks.DIRT.func_230234_a_()))) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_DIRT.get(), SoundCategory.NEUTRAL, 0.6f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.field_187881_gQ) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_WOOD.get(), SoundCategory.NEUTRAL, 0.6f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
            this.soundPlayed = true;
        }
        this.func_241204_bJ_();
    }

    protected void onEntityHit(EntityRayTraceResult result) {
        if (result.func_216348_a() instanceof LivingEntity && this.getOrigin() != null && result.func_216348_a().func_145782_y() != this.getOrigin().func_145782_y()) {
            this.onTargetHit(result);
        }
    }

    protected void onTargetHit(EntityRayTraceResult result) {
        result.func_216348_a().field_70172_ad = 0;
        this.castersDamage((LivingEntity)result.func_216348_a(), this.getBulletDamage());
        this.func_241204_bJ_();
    }

    protected void func_241204_bJ_() {
        this.onDeath();
        super.func_241204_bJ_();
    }

    @Override
    public void dannyClientManager(int flag, float abstractVal) {
    }

    public boolean canceledMovement() {
        return false;
    }

    public RayTraceResult rayTraceResultType() {
        return DannyRayTraceHelper.bulletRaytrace(this, this::collisionParameters, MathUtil.fromPitchYaw(this.field_70125_A, this.field_70177_z).func_216372_d((double)this.getRealSpeed(), (double)this.getRealSpeed(), (double)this.getRealSpeed()), RayTraceContext.FluidMode.ANY);
    }

    public boolean collisionParameters(Entity entityIn) {
        return !entityIn.func_175149_v() && entityIn.func_70089_S() && entityIn.func_70067_L() && !entityIn.equals((Object)this.getOrigin());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void castersDamage(LivingEntity livingEntity, float amount) {
        if (this.getOrigin() != null) {
            livingEntity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.getOrigin()), amount);
        } else {
            livingEntity.func_70097_a(DamageSource.field_76376_m, amount);
        }
    }

    public void setBulletDamage(float damage) {
        this.func_184212_Q().func_187227_b(BULLET_DAMAGE, (Object)Float.valueOf(damage));
    }

    public void addBulletDamage(float damage) {
        this.func_184212_Q().func_187227_b(BULLET_DAMAGE, (Object)Float.valueOf(this.getBulletDamage() + damage));
    }

    public void setBulletSpeedMult(float speedMult) {
        this.func_184212_Q().func_187227_b(BULLET_SPEED_MULT, (Object)Float.valueOf(speedMult));
    }

    public void addBulletSpeedMult(float speedMult) {
        this.func_184212_Q().func_187227_b(BULLET_SPEED_MULT, (Object)Float.valueOf(this.getBulletSpeed() + speedMult));
    }

    public void setBulletSpeed(float speed) {
        this.func_184212_Q().func_187227_b(BULLET_SPEED, (Object)Float.valueOf(speed));
    }

    public void addBulletSpeed(float speed) {
        this.func_184212_Q().func_187227_b(BULLET_SPEED, (Object)Float.valueOf(this.getBulletSpeed() + speed));
    }

    public void setOrigin(LivingEntity livingEntity) {
        this.func_184212_Q().func_187227_b(ORIGIN_UUID, Optional.of(livingEntity.func_110124_au()));
    }

    public void setOriginUUID(UUID casterUUID) {
        this.func_184212_Q().func_187227_b(ORIGIN_UUID, Optional.of(casterUUID));
    }

    @Override
    public void setAttachedEntity(Entity entity, int index) {
        this.attachedEntities.set(index, entity);
    }

    public void setMaxLifeTicks(int i) {
        this.func_184212_Q().func_187227_b(MAX_LIFE_TICKS, (Object)i);
    }

    public void setCurrentLifeTicks(int i) {
        this.func_184212_Q().func_187227_b(CURRENT_LIFE_TICKS, (Object)i);
    }

    public float getBulletDamage() {
        return ((Float)this.func_184212_Q().func_187225_a(BULLET_DAMAGE)).floatValue();
    }

    public float getBulletSpeedMult() {
        return ((Float)this.func_184212_Q().func_187225_a(BULLET_SPEED_MULT)).floatValue();
    }

    public float getBulletSpeed() {
        return ((Float)this.func_184212_Q().func_187225_a(BULLET_SPEED)).floatValue();
    }

    public float getRealSpeed() {
        return this.getBulletSpeed() * this.getBulletSpeedMult();
    }

    @Nullable
    public LivingEntity getOrigin() {
        if (this.getAttachedEntity(0) instanceof LivingEntity) {
            return (LivingEntity)this.getAttachedEntity(0);
        }
        return null;
    }

    public Optional<UUID> getOriginUUID() {
        return (Optional)this.func_184212_Q().func_187225_a(ORIGIN_UUID);
    }

    @Override
    public Entity getAttachedEntity(int index) {
        return this.attachedEntities.get(index);
    }

    public int getMaxLifeTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(MAX_LIFE_TICKS);
    }

    public int getCurrentLifeTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(CURRENT_LIFE_TICKS);
    }
}

