/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.bullet;

import com.bottomtextdanny.dannys_expansion.client.Particles.DannyDustParticleData;
import com.bottomtextdanny.dannys_expansion.common.Entities.bullet.AbstractBulletEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.DannyRayTraceHelper;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class AquaticBulletEntity
extends AbstractBulletEntity {
    public AquaticBulletEntity(EntityType<? extends AbstractBulletEntity> entityTypeIn, World worldIn, int lifetime) {
        super(entityTypeIn, worldIn, lifetime);
    }

    public AquaticBulletEntity(EntityType<? extends AbstractBulletEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        Vector3d forward = MathUtil.fromPitchYaw(this.field_70125_A, this.field_70177_z);
        float multiplier = 1.0f;
        if (this.field_70171_ac) {
            multiplier = 1.5f;
        }
        this.setBulletSpeedMult(multiplier);
        Vector3d nextPosition = this.func_213303_ch().func_72441_c((double)this.getRealSpeed() * forward.field_72450_a, (double)this.getRealSpeed() * forward.field_72448_b, (double)this.getRealSpeed() * forward.field_72449_c);
        BlockPos nextBlockPosition = new BlockPos((int)nextPosition.field_72450_a, (int)nextPosition.field_72448_b, (int)nextPosition.field_72449_c);
        if (this.field_70170_p.func_195588_v(nextBlockPosition)) {
            this.func_213315_a(MoverType.SELF, this.acceleration.getAcceleratedMotion());
        }
        if (!this.field_70122_E) {
            this.acceleration.setMotion((double)this.getRealSpeed() * forward.field_72450_a, (double)this.getRealSpeed() * forward.field_72448_b, (double)this.getRealSpeed() * forward.field_72449_c);
        }
    }

    @Override
    public boolean canceledMovement() {
        return true;
    }

    @Override
    public void onDeath() {
        super.onDeath();
        if (!this.soundPlayed) {
            this.func_184185_a((SoundEvent)DannySounds.ENTITY_BULLET_IMPACT_GENERIC.get(), 1.0f, 1.0f + 0.2f * this.field_70146_Z.nextFloat());
        }
    }

    @Override
    public RayTraceResult rayTraceResultType() {
        return DannyRayTraceHelper.bulletRaytrace(this, this::collisionParameters, MathUtil.fromPitchYaw(this.field_70125_A, this.field_70177_z).func_216372_d((double)this.getRealSpeed(), (double)this.getRealSpeed(), (double)this.getRealSpeed()), RayTraceContext.FluidMode.NONE);
    }

    @Override
    protected void onTargetHit(EntityRayTraceResult result) {
        super.onTargetHit(result);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                float f = 0.75f + this.field_70146_Z.nextFloat() * 0.5f;
                Vector3d vec = MathUtil.fromPitchYaw(this.field_70125_A + (float)this.field_70146_Z.nextGaussian() * 30.0f, this.field_70177_z + (float)this.field_70146_Z.nextGaussian() * 30.0f);
                this.field_70170_p.func_195594_a((IParticleData)new DannyDustParticleData(0.2f, 0.5f, 1.0f, 1.0f, 2 + this.field_70146_Z.nextInt(8)), result.func_216347_e().field_72450_a, result.func_216347_e().field_72448_b, result.func_216347_e().field_72449_c, -vec.field_72450_a * (double)f, -vec.field_72448_b * (double)f, -vec.field_72449_c * (double)f);
            }
        }
    }

    @Override
    protected void onBlockHit(BlockRayTraceResult p_230299_1_) {
        super.onBlockHit(p_230299_1_);
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(2); ++i) {
                float f = 0.5f + this.field_70146_Z.nextFloat() * 0.75f;
                Vector3d vec = MathUtil.fromPitchYaw(this.field_70125_A + (float)this.field_70146_Z.nextGaussian() * 10.0f, this.field_70177_z + (float)this.field_70146_Z.nextGaussian() * 10.0f);
                this.field_70170_p.func_195594_a((IParticleData)new DannyDustParticleData(0.2f, 0.5f, 1.0f, 1.0f, 2 + this.field_70146_Z.nextInt(8)), p_230299_1_.func_216347_e().field_72450_a, p_230299_1_.func_216347_e().field_72448_b, p_230299_1_.func_216347_e().field_72449_c, -vec.field_72450_a * (double)f, -vec.field_72448_b * (double)f, -vec.field_72449_c * (double)f);
            }
        }
    }
}

