/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.kite;

import com.bottomtextdanny.dannys_expansion.client.ClientInstance;
import com.bottomtextdanny.dannys_expansion.client.sound.KiteLoopSound;
import com.bottomtextdanny.dannys_expansion.common.Entities.kite.KiteKnotEntity;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.capabilities.world.DannyWorldCap;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IClientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class KiteEntity
extends Entity
implements IClientManager {
    private static final DataParameter<String> DESIGN = EntityDataManager.func_187226_a(KiteEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> DYABLE_DESIGN = EntityDataManager.func_187226_a(KiteEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(KiteEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DESIGN_COLOR = EntityDataManager.func_187226_a(KiteEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<ItemStack> KITE_ITEM = EntityDataManager.func_187226_a(KiteEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public Vector3d designColor = Vector3d.field_186680_a;
    public SimpleMotion forwardMotion;
    public SimpleMotion retrayMotion;
    public SimpleMotion stopMotion;
    @OnlyIn(value=Dist.CLIENT)
    KiteLoopSound fooooo;
    public float prevDifference;
    public float difference;
    public float prevRenderDifference;
    public float renderDifference;
    public float kiteYaw;
    public float prevKiteYaw;
    public float kitePitch;
    public float prevKitePitch;
    public float tickOffset;
    public float avgDistance;
    public float angleOffset;

    public KiteEntity(EntityType<? extends KiteEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
        float f0 = 5.25f + this.field_70146_Z.nextFloat() * 0.5f;
        float f1 = (float)(4.0 * this.field_70146_Z.nextGaussian());
        float f2 = this.field_70146_Z.nextFloat() * 20000.0f;
        this.avgDistance = f0;
        this.sendClientManagerMsg(0, f0);
        this.angleOffset = f1;
        this.sendClientManagerMsg(1, f1);
        this.tickOffset = f2;
        this.sendClientManagerMsg(2, f2);
        this.forwardMotion = new SimpleMotion(0.9f);
        this.retrayMotion = new SimpleMotion(0.84f);
        this.stopMotion = new SimpleMotion(3, 0.995f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(DYABLE_DESIGN, (Object)false);
        this.func_184212_Q().func_187214_a(DESIGN_COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(KITE_ITEM, (Object)ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(DESIGN, (Object)"none");
    }

    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT compoundnbt = compound.func_74775_l("Stack");
        if (!compoundnbt.isEmpty()) {
            this.setItemId(ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
        this.setDyableDesign(compound.func_74767_n("DyableDesign"));
        this.setColor(MathHelper.func_76125_a((int)compound.func_74762_e("Color"), (int)0, (int)15));
        this.setDesignColor(MathHelper.func_76125_a((int)compound.func_74762_e("DesignColor"), (int)0, (int)15));
        this.setDesign(compound.func_74779_i("Design"));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_218657_a("Stack", (INBT)this.getItemstack().func_77955_b(new CompoundNBT()));
        compound.func_74757_a("DyableDesign", this.hasDyableDesign());
        compound.func_74768_a("Color", this.getColor());
        compound.func_74768_a("DesignColor", this.getDesignColor());
        compound.func_74778_a("Design", this.getDesign());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        DannyWorldCap capability = (DannyWorldCap)this.field_70170_p.getCapability(DannyWorldCap.WORLD_WIND).orElse(null);
        float customTicksExisted = (float)this.field_70173_aa + this.tickOffset;
        float kiteAngle = MathHelper.func_76142_g((float)capability.getWindDirection()) + this.angleOffset;
        this.forwardMotion.tick();
        this.retrayMotion.tick();
        this.stopMotion.tick();
        if (!this.field_70170_p.func_201670_d()) {
            this.setRotations(kiteAngle, 0.0f);
            this.sendClientManagerMsg(3);
        }
        this.prevDifference = this.difference;
        this.difference = MathUtil.getDistance(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70169_q, this.field_70167_r, this.field_70166_s);
        this.prevRenderDifference = this.renderDifference;
        this.renderDifference += (this.difference - this.renderDifference) / 15.0f;
        if (this.func_184187_bx() instanceof KiteKnotEntity) {
            KiteKnotEntity knot = (KiteKnotEntity)this.func_184187_bx();
            Vector3d knotForward = MathUtil.fromPitchYaw(MathUtil.getTargetPitch(knot, this), MathUtil.getTargetYaw(knot, this));
            Vector3d windForward = MathUtil.fromPitchYaw(0.0f, this.kiteYaw);
            if (knot.func_70032_d(this) < this.avgDistance * 2.0f) {
                float forwardVec = -(knot.func_70032_d(this) - this.avgDistance * 2.0f);
                this.forwardMotion.setMotion(windForward.field_72450_a * 0.1 * (double)forwardVec, (double)MathHelper.func_76126_a((float)(customTicksExisted * 0.04f)) * 0.05 + 0.18, windForward.field_72449_c * 0.1 * (double)forwardVec);
            }
            if (knot.func_70032_d(this) > this.avgDistance) {
                float retrayVec = knot.func_70032_d(this) - this.avgDistance;
                this.retrayMotion.setMotion(-knotForward.field_72450_a * 0.1 * (double)retrayVec, -knotForward.field_72448_b * 0.1 * (double)retrayVec, -knotForward.field_72449_c * 0.1 * (double)retrayVec);
            }
            if (capability.isWindStop()) {
                this.stopMotion.setMotion(-windForward.field_72450_a * 0.05 * (double)capability.windStopMagnitude, 0.026 * (double)capability.windStopMagnitude, -windForward.field_72449_c * 0.05 * (double)capability.windStopMagnitude);
            }
        } else if (!this.field_70170_p.func_201670_d()) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getItemstack());
            this.field_70170_p.func_217376_c((Entity)itementity);
            this.func_70106_y();
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci().func_178787_e(this.forwardMotion.getAcceleratedMotion()).func_178787_e(this.retrayMotion.getAcceleratedMotion()).func_178787_e(this.stopMotion.getAcceleratedMotion()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        if (flag == 0) {
            this.avgDistance = abstractVal;
        } else if (flag == 1) {
            this.angleOffset = abstractVal;
        } else if (flag == 2) {
            this.tickOffset = abstractVal;
        } else if (flag == 3 && ClientInstance.player() != null && (this.fooooo == null || this.fooooo.func_147667_k() && Minecraft.func_71410_x().field_71439_g.func_70032_d((Entity)this) < 20.0f)) {
            this.fooooo = new KiteLoopSound(this);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.fooooo);
        }
    }

    public void sendClientManagerMsg(int flag, float abst) {
        DENetwork.triggerEntityClientAction(this, flag, abst);
    }

    public void sendClientManagerMsg(int flag) {
        DENetwork.triggerEntityClientAction(this, flag, 0.0f);
    }

    public void setRotations(float yaw, float pitch) {
        this.kiteYaw = yaw;
        this.kitePitch = pitch;
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        DENetwork.setCustomRotation(this, yaw, pitch, false);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_242281_f(x, y, z);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.kiteYaw = yaw % 360.0f;
        this.kitePitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.prevKiteYaw = this.kiteYaw;
        this.prevKitePitch = this.kitePitch;
    }

    public KiteKnotEntity getKnot() {
        if (this.func_184187_bx() instanceof KiteKnotEntity) {
            return (KiteKnotEntity)this.func_184187_bx();
        }
        return null;
    }

    public void setItemId(ItemStack i) {
        this.func_184212_Q().func_187227_b(KITE_ITEM, (Object)i);
    }

    public void setDyableDesign(boolean bool) {
        this.func_184212_Q().func_187227_b(DYABLE_DESIGN, (Object)bool);
    }

    public void setColor(int i) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)i);
    }

    public void setDesignColor(int i) {
        this.func_184212_Q().func_187227_b(DESIGN_COLOR, (Object)i);
    }

    public void setDesign(String s) {
        this.func_184212_Q().func_187227_b(DESIGN, (Object)s);
    }

    public ItemStack getItemstack() {
        return (ItemStack)this.func_184212_Q().func_187225_a(KITE_ITEM);
    }

    public boolean hasDyableDesign() {
        return (Boolean)this.func_184212_Q().func_187225_a(DYABLE_DESIGN);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public int getDesignColor() {
        return (Integer)this.func_184212_Q().func_187225_a(DESIGN_COLOR);
    }

    public String getDesign() {
        return (String)this.func_184212_Q().func_187225_a(DESIGN);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (!this.hasDyableDesign()) {
            this.designColor = new Vector3d(255.0, 255.0, 255.0);
            return;
        }
        switch (this.getDesignColor()) {
            case 0: {
                this.designColor = new Vector3d(240.0, 240.0, 255.0);
                break;
            }
            case 1: {
                this.designColor = new Vector3d(240.0, 172.0, 55.0);
                break;
            }
            case 2: {
                this.designColor = new Vector3d(222.0, 53.0, 231.0);
                break;
            }
            case 3: {
                this.designColor = new Vector3d(71.0, 169.0, 246.0);
                break;
            }
            case 4: {
                this.designColor = new Vector3d(255.0, 231.0, 31.0);
                break;
            }
            case 5: {
                this.designColor = new Vector3d(71.0, 223.0, 71.0);
                break;
            }
            case 6: {
                this.designColor = new Vector3d(230.0, 90.0, 160.0);
                break;
            }
            case 7: {
                this.designColor = new Vector3d(91.0, 96.0, 102.0);
                break;
            }
            case 8: {
                this.designColor = new Vector3d(158.0, 168.0, 173.0);
                break;
            }
            case 9: {
                this.designColor = new Vector3d(0.0, 209.0, 185.0);
                break;
            }
            case 10: {
                this.designColor = new Vector3d(138.0, 71.0, 209.0);
                break;
            }
            case 11: {
                this.designColor = new Vector3d(39.0, 59.0, 171.0);
                break;
            }
            case 12: {
                this.designColor = new Vector3d(110.0, 55.0, 0.0);
                break;
            }
            case 13: {
                this.designColor = new Vector3d(20.0, 115.0, 37.0);
                break;
            }
            case 14: {
                this.designColor = new Vector3d(199.0, 28.0, 39.0);
                break;
            }
            default: {
                this.designColor = new Vector3d(5.0, 3.0, 12.0);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

