/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Schedule;
import com.bottomtextdanny.dannys_expansion.core.Util.SimpleMotion;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IAmbientAnimation;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IAttachEntities;
import com.bottomtextdanny.dannys_expansion.core.interfaces.IClientManager;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public abstract class DannyEntity
extends CreatureEntity
implements IAttachEntities,
IClientManager,
IAmbientAnimation {
    protected List<Entity> attachedEntities = Arrays.asList(new Entity[100]);
    private final List<AmbientAnimation> ambientAnimations = Arrays.asList(new AmbientAnimation[100]);
    private Animation mainAnimation;
    protected Set<SimpleMotion> customMotions = new HashSet<SimpleMotion>();
    public boolean isDead;
    public float limbSwingLoop;
    public float prevLimbSwingLoop;
    public float prevRenderLimbSwingAmount;
    public float renderLimbSwingAmount;
    private int animationTick;
    public Schedule sleepPathSchedule = new Schedule();
    public Timer livingSoundTimer;
    public Timer meleeTimer;
    public Timer rangedTimer;
    public final LoopStepSoundPlayer LSP_DEFAULT = (blockpos, blockstate, lSLoop) -> {
        if (lSLoop > MathUtil.loop(lSLoop, 0.0f, 1.0f, this.renderLimbSwingAmount * this.getLimbSwingMultiplier())) {
            this.playLoopStepSound(blockpos, blockstate);
        }
    };
    public final LoopStepSoundPlayer LSP_DOUBLE = (blockpos, blockstate, lSLoop) -> {
        lSLoop = MathUtil.loop(lSLoop, 0.0f, 0.5f, 0.0f);
        if (MathUtil.loop(this.prevLimbSwingLoop, 0.0f, 0.5f, 0.0f) > lSLoop) {
            this.playLoopStepSound(blockpos, blockstate);
        }
    };

    public DannyEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.mainAnimation = Animation.NO_ANIMATION;
        this.livingSoundTimer = new Timer(1000, baseBound -> MathUtil.getRandomOffset(baseBound, 0.8f));
        this.meleeTimer = new Timer(10);
        this.rangedTimer = new Timer(10);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.meleeTimer.tryUp();
        this.rangedTimer.tryUp();
        this.sleepPathSchedule.tryDown();
        if (this.getLimbSwingType() == LimbSwingType.LOOP) {
            float limbSwingDistance = MathUtil.getHorizontalDistance(this.func_226277_ct_(), this.func_226281_cx_(), this.field_70169_q, this.field_70166_s);
            BlockPos blockpos = this.func_226268_ag_();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            this.prevRenderLimbSwingAmount = this.renderLimbSwingAmount;
            this.renderLimbSwingAmount = (float)((double)this.renderLimbSwingAmount + (limbSwingDistance - this.renderLimbSwingAmount > 0.0f ? (double)(limbSwingDistance - this.renderLimbSwingAmount) / 1.5 : (double)((limbSwingDistance - this.renderLimbSwingAmount) / 4.0f)));
            this.prevLimbSwingLoop = BigDecimal.valueOf(this.limbSwingLoop).floatValue();
            this.limbSwingLoop = MathUtil.loop(this.limbSwingLoop, 0.0f, 1.0f, this.renderLimbSwingAmount * this.getLimbSwingMultiplier());
            this.lSSPlayer().getLogic(blockpos, blockstate, this.limbSwingLoop);
        }
        this.ambientAnimations.forEach(ambientAnimation -> {
            if (ambientAnimation != null && ambientAnimation.isWoke()) {
                if (ambientAnimation.getTick() <= ambientAnimation.getDuration()) {
                    ambientAnimation.setTick(ambientAnimation.getTick() + ambientAnimation.progress(ambientAnimation.getTick()));
                } else {
                    ambientAnimation.resetInstanceValues();
                    ambientAnimation.sleep();
                }
            }
        });
        if (this.getMainAnimationTick() <= this.mainAnimation.getDuration()) {
            this.animationTick += this.mainAnimation.progress(this.animationTick);
        } else {
            this.mainAnimation.resetInstanceValues();
            this.playMainAnimation(this.onAnimationEnd(this.mainAnimation));
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (this.func_70613_aW() && !this.isDead) {
                if (this.getDeathAnimation() != null) {
                    this.playMainAnimation(this.getDeathAnimation());
                    this.onDeathUpdate(this.getDeathAnimation().getDuration());
                }
                this.onDeathStart();
                this.isDead = true;
            } else if (this.getDeathAnimation() != null) {
                this.onDeathUpdate(this.getDeathAnimation().getDuration());
            } else {
                this.onDeathUpdate(20.0f);
            }
        }
        if (!this.field_70170_p.func_201670_d()) {
            AtomicReference<Vector3d> aVec0 = new AtomicReference<Vector3d>(Vector3d.field_186680_a);
            this.customMotions.forEach(m -> aVec0.set(((Vector3d)aVec0.get()).func_178787_e(m.getAcceleratedMotion())));
            if (!aVec0.get().equals((Object)Vector3d.field_186680_a)) {
                this.func_213315_a(MoverType.SELF, aVec0.get());
            }
            this.customMotions.forEach(SimpleMotion::tick);
            if (this.getLivingSoundTimer().hasEnded()) {
                DENetwork.trivialEntityActions((Entity)this, DENetwork.TEA_SYNC_LIVING_SOUND);
                this.doLivingSound();
                this.getLivingSoundTimer().reset();
            } else {
                this.getLivingSoundTimer().tryUp();
            }
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() || this.func_184186_bw()) {
            double d0 = 0.08;
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
            d0 = gravity.func_111126_e();
            FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d8 = this.func_226278_cu_();
                float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
                float f6 = 0.02f;
                float f7 = EnchantmentHelper.func_185294_d((LivingEntity)this);
                if (f7 > 3.0f) {
                    f7 = 3.0f;
                }
                if (!this.field_70122_E) {
                    f7 *= 0.5f;
                }
                if (f7 > 0.0f) {
                    f5 += (0.54600006f - f5) * f7 / 3.0f;
                    f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
                }
                if (this.func_70644_a(Effects.field_206827_D)) {
                    f5 = 0.96f;
                }
                this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), travelVector);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                Vector3d vector3d6 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70617_f_()) {
                    vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
                }
                this.func_213317_d(vector3d6.func_216372_d((double)f5, (double)0.8f, (double)f5));
                Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d2);
                if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                    this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
                }
            } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
                double d7 = this.func_226278_cu_();
                this.func_213309_a(0.02f, travelVector);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.func_233571_b_((ITag)FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                    Vector3d vector3d3 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                    this.func_213317_d(vector3d3);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
                }
                if (!this.func_189652_ae()) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
                }
                Vector3d vector3d4 = this.func_213322_ci();
                if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                    this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
                }
            } else if (this.func_184613_cA()) {
                double d10;
                double d6;
                float f2;
                Vector3d vector3d = this.func_213322_ci();
                if (vector3d.field_72448_b > -0.5) {
                    this.field_70143_R = 1.0f;
                }
                Vector3d vector3d1 = this.func_70040_Z();
                float f = this.field_70125_A * ((float)Math.PI / 180);
                double d1 = Math.sqrt(vector3d1.field_72450_a * vector3d1.field_72450_a + vector3d1.field_72449_c * vector3d1.field_72449_c);
                double d3 = Math.sqrt(DannyEntity.func_213296_b((Vector3d)vector3d));
                double d4 = vector3d1.func_72433_c();
                float f1 = MathHelper.func_76134_b((float)f);
                f1 = (float)((double)f1 * (double)f1 * Math.min(1.0, d4 / 0.4));
                vector3d = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f1 * 0.75), 0.0);
                if (vector3d.field_72448_b < 0.0 && d1 > 0.0) {
                    double d5 = vector3d.field_72448_b * -0.1 * (double)f1;
                    vector3d = vector3d.func_72441_c(vector3d1.field_72450_a * d5 / d1, d5, vector3d1.field_72449_c * d5 / d1);
                }
                if (f < 0.0f && d1 > 0.0) {
                    double d9 = d3 * (double)(-MathHelper.func_76126_a((float)f)) * 0.04;
                    vector3d = vector3d.func_72441_c(-vector3d1.field_72450_a * d9 / d1, d9 * 3.2, -vector3d1.field_72449_c * d9 / d1);
                }
                if (d1 > 0.0) {
                    vector3d = vector3d.func_72441_c((vector3d1.field_72450_a / d1 * d3 - vector3d.field_72450_a) * 0.1, 0.0, (vector3d1.field_72449_c / d1 * d3 - vector3d.field_72449_c) * 0.1);
                }
                this.func_213317_d(vector3d.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (this.field_70123_F && !this.field_70170_p.field_72995_K && (f2 = (float)((d6 = d3 - (d10 = Math.sqrt(DannyEntity.func_213296_b((Vector3d)this.func_213322_ci())))) * 10.0 - 3.0)) > 0.0f) {
                    this.func_184185_a(this.func_184588_d((int)f2), 1.0f, 1.0f);
                    this.func_70097_a(DamageSource.field_188406_j, f2);
                }
                if (this.field_70122_E && !this.field_70170_p.field_72995_K) {
                    this.func_70052_a(7, false);
                }
            } else {
                BlockPos blockpos = this.func_226270_aj_();
                float f3 = this.field_70170_p.func_180495_p(this.func_226270_aj_()).getSlipperiness((IWorldReader)this.field_70170_p, this.func_226270_aj_(), (Entity)this);
                float f4 = this.field_70122_E ? f3 * 0.91f : 0.91f;
                Vector3d vector3d5 = this.func_233633_a_(travelVector, f3);
                double d2 = vector3d5.field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d2 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - vector3d5.field_72448_b) * 0.2;
                    this.field_70143_R = 0.0f;
                } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                    d2 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
                } else if (!this.func_189652_ae()) {
                    d2 -= d0;
                }
                this.func_213293_j(vector3d5.field_72450_a * (double)f4, d2 * (double)0.98f, vector3d5.field_72449_c * (double)f4);
            }
        }
        this.func_233629_a_((LivingEntity)this, this instanceof IFlyingAnimal);
    }

    public static Vector3d getAbsoluteMotion(Vector3d relative, float p_213299_1_, float facing) {
        double d0 = relative.func_189985_c();
        if (d0 < 1.0E-7) {
            return Vector3d.field_186680_a;
        }
        Vector3d vector3d = (d0 > 1.0 ? relative.func_72432_b() : relative).func_186678_a((double)p_213299_1_);
        float f = MathHelper.func_76126_a((float)(facing * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(facing * ((float)Math.PI / 180)));
        return new Vector3d(vector3d.field_72450_a * (double)f1 - vector3d.field_72449_c * (double)f, vector3d.field_72448_b, vector3d.field_72449_c * (double)f1 + vector3d.field_72450_a * (double)f);
    }

    public Vector3d func_233633_a_(Vector3d travelVector, float p_233633_2_) {
        this.func_213317_d(this.handleOnClimbable(this.func_213322_ci()).func_178787_e(DannyEntity.getAbsoluteMotion(travelVector, this.getRelevantMoveFactor(p_233633_2_), this.field_70177_z)));
        if (!this.sleepPathSchedule.isWoke()) {
            this.func_213317_d(this.func_213322_ci().func_178788_d(DannyEntity.getAbsoluteMotion(travelVector, this.getRelevantMoveFactor(p_233633_2_), this.field_70177_z)));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        Vector3d vector3d = this.func_213322_ci();
        if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
            vector3d = new Vector3d(vector3d.field_72450_a, 0.2, vector3d.field_72449_c);
        }
        return vector3d;
    }

    private Vector3d handleOnClimbable(Vector3d p_213362_1_) {
        if (this.func_70617_f_()) {
            this.field_70143_R = 0.0f;
            double d0 = MathHelper.func_151237_a((double)p_213362_1_.field_72450_a, (double)-0.15f, (double)0.15f);
            double d1 = MathHelper.func_151237_a((double)p_213362_1_.field_72449_c, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(p_213362_1_.field_72448_b, (double)-0.15f);
            p_213362_1_ = new Vector3d(d0, d2, d1);
        }
        return p_213362_1_;
    }

    private float getRelevantMoveFactor(float p_213335_1_) {
        return this.field_70122_E ? this.func_70689_ay() * (0.21600002f / (p_213335_1_ * p_213335_1_ * p_213335_1_)) : this.field_70747_aH;
    }

    public void playMainAnimation(Animation mainAnimation) {
        this.mainAnimation = mainAnimation;
        DENetwork.setAnimation(this, mainAnimation);
        this.setAnimationTick(0);
    }

    public void wakeAmbientAnimation(int index) {
        DENetwork.setAmbientAnimation(this, index);
        this.ambientAnimations.get(index).wake();
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public boolean isAnimationPlaying(Animation animation) {
        return this.mainAnimation == animation;
    }

    public int getMainAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public Animation getMainAnimation() {
        return this.mainAnimation;
    }

    @Nullable
    public Animation getDeathAnimation() {
        return null;
    }

    public Animation onAnimationEnd(Animation animation) {
        return Animation.NO_ANIMATION;
    }

    protected void func_70609_aI() {
    }

    protected void onDeathUpdate(float duration) {
        ++this.field_70725_aQ;
        if ((float)this.field_70725_aQ >= duration) {
            this.onDeathEnd();
            this.func_70106_y();
        }
    }

    protected void onDeathStart() {
    }

    protected void onDeathEnd() {
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226282_d_(1.0), this.func_226279_cv_(), this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
    }

    public abstract boolean func_213397_c(double var1);

    public void sendClientManagerMsg(int flag) {
        DENetwork.triggerEntityClientAction((Entity)this, flag);
    }

    public void sendClientManagerMsg(int flag, float abstractVal) {
        DENetwork.triggerEntityClientAction((Entity)this, flag, abstractVal);
    }

    @Nullable
    public SoundEvent getLivingSound() {
        return super.func_184639_G();
    }

    public void playLivingSound() {
        SoundEvent soundevent = this.getLivingSound();
        if (soundevent != null) {
            this.func_184185_a(soundevent, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        if (this.getLimbSwingType() == LimbSwingType.DEFAULT) {
            super.func_180429_a(pos, blockIn);
        }
    }

    public Timer getLivingSoundTimer() {
        return this.livingSoundTimer;
    }

    protected void playLoopStepSound(BlockPos pos, BlockState blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    protected LoopStepSoundPlayer lSSPlayer() {
        return this.LSP_DEFAULT;
    }

    @ParametersAreNonnullByDefault
    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public Entity getAttachedEntity(int index) {
        return this.attachedEntities.get(index);
    }

    public List<AmbientAnimation> getAmbientAnimations() {
        return this.ambientAnimations;
    }

    @Override
    public AmbientAnimation getAmbientAnimation(int index) {
        return this.ambientAnimations.get(index);
    }

    public int getAmbientAnimationTick(int index) {
        return this.ambientAnimations.get(index).getTick();
    }

    @Override
    public void setAttachedEntity(Entity entity, int index) {
        this.attachedEntities.set(index, entity);
    }

    public void setAmbientAnimation(AmbientAnimation ambientAnimation, int index) {
        this.ambientAnimations.set(index, ambientAnimation);
    }

    public float getLimbSwingMultiplier() {
        return 0.25f;
    }

    public LimbSwingType getLimbSwingType() {
        return LimbSwingType.DEFAULT;
    }

    public void doLivingSound() {
        this.playLivingSound();
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new DannyGroundNavigator(this, worldIn);
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public boolean hasAttackTarget() {
        return this.func_70638_az() != null;
    }

    public void whenAttackTarget(Consumer<LivingEntity> target) {
        if (this.hasAttackTarget()) {
            target.accept(this.func_70638_az());
        }
    }

    public boolean ifAttackTargetAnd(Predicate<LivingEntity> target) {
        return this.hasAttackTarget() && target.test(this.func_70638_az());
    }

    public boolean ifAttackMeleeParamsAnd(Predicate<LivingEntity> target) {
        return this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.meleeTimer.hasEnded() && target.test(this.func_70638_az());
    }

    public boolean ifAttackRangedParamsAnd(Predicate<LivingEntity> target) {
        return this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.rangedTimer.hasEnded() && target.test(this.func_70638_az());
    }

    public static void disableShield(Entity entity, int ticks) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && (player = (PlayerEntity)entity).func_184607_cu().func_77973_b() instanceof ShieldItem) {
            player.func_184811_cZ().func_185145_a(player.func_184607_cu().func_77973_b(), ticks);
            player.func_184602_cy();
            player.field_70170_p.func_72960_a(entity, (byte)30);
        }
    }

    public float reachTo(Entity entity) {
        return Math.max(this.func_70032_d(entity) - entity.func_213311_cf() / 2.0f, 0.0f);
    }

    public void mayDisableShield(Entity entity, int ticks, float possibility) {
        PlayerEntity player;
        if (entity instanceof PlayerEntity && this.field_70146_Z.nextFloat() < possibility && (player = (PlayerEntity)entity).func_184607_cu().func_77973_b() instanceof ShieldItem) {
            player.func_184811_cZ().func_185145_a(player.func_184607_cu().func_77973_b(), ticks);
            player.func_184602_cy();
            player.field_70170_p.func_72960_a(entity, (byte)30);
        }
    }

    public float targetDistance(float distance) {
        return distance + this.func_70638_az().func_213311_cf() / 2.0f;
    }

    public boolean InFluid() {
        return this.func_70090_H() || this.func_180799_ab();
    }

    protected void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public void attackWithMultiplier(LivingEntity livingEntity, float mult) {
        livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_) * mult);
    }

    public SimpleMotion registerMotion(SimpleMotion motion) {
        this.customMotions.add(motion);
        return motion;
    }

    @FunctionalInterface
    protected static interface LoopStepSoundPlayer {
        public void getLogic(BlockPos var1, BlockState var2, float var3);
    }

    protected static enum LimbSwingType {
        DEFAULT,
        LOOP;

    }

    public class DannyGroundNavigator
    extends GroundPathNavigator {
        public DannyGroundNavigator(DannyEntity entityIn, World worldIn) {
            super((MobEntity)entityIn, worldIn);
        }

        public boolean func_75497_a(Entity entityIn, double speedIn) {
            if (!DannyEntity.this.sleepPathSchedule.isWoke()) {
                this.func_75499_g();
                this.field_75515_a.field_191988_bg = 0.0f;
                this.field_75515_a.field_70702_br = 0.0f;
                return false;
            }
            return super.func_75497_a(entityIn, speedIn);
        }

        public boolean func_75492_a(double x, double y, double z, double speedIn) {
            if (!DannyEntity.this.sleepPathSchedule.isWoke()) {
                this.func_75499_g();
                this.field_75515_a.field_191988_bg = 0.0f;
                this.field_75515_a.field_70702_br = 0.0f;
                return false;
            }
            return super.func_75492_a(x, y, z, speedIn);
        }

        public void func_75501_e() {
            super.func_75501_e();
            if (!DannyEntity.this.sleepPathSchedule.isWoke()) {
                this.func_75499_g();
                this.field_75515_a.field_191988_bg = 0.0f;
                this.field_75515_a.field_70702_br = 0.0f;
            }
        }
    }
}

