/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.PlayAnimationGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.projectile.VomitEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class GhoulEntity
extends DannyEntity
implements IMob {
    public static final Animation VOMIT = new Animation(24);
    public static final Animation GRAB = new Animation(26);
    public Timer respirationTimer;

    public GhoulEntity(EntityType<? extends GhoulEntity> type, World worldIn) {
        super(type, worldIn);
        this.getLivingSoundTimer().setBoundBase(340);
        this.rangedTimer.setBoundBase(160);
        this.respirationTimer = new Timer(600, o -> MathUtil.getRandomOffset(o, 0.7f));
        this.setAmbientAnimation(new AmbientAnimation(22), 0);
        this.setAmbientAnimation(new AmbientAnimation(16), 1);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PlayAnimationGoal(this, GRAB, o -> this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.meleeTimer.hasEnded() && this.reachTo((Entity)this.func_70638_az()) < 1.0f, dannyEntity -> this.meleeTimer.reset()));
        this.field_70714_bg.func_75776_a(1, (Goal)new PlayAnimationGoal(this, VOMIT, o -> this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.rangedTimer.hasEnded() && this.func_70685_l((Entity)this.func_70638_az()), dannyEntity -> this.rangedTimer.reset()));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowTargetGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, true, null));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, 10, true, true, null));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.22).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233823_f_, 8.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isAnimationPlaying(GRAB)) {
            if (this.getMainAnimationTick() == 10) {
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_SWOOSH.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_GHOUL_PUNCH.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            if (this.getMainAnimationTick() == 14 && this.hasAttackTarget() && this.reachTo((Entity)this.func_70638_az()) < 2.0f) {
                this.attackWithMultiplier(this.func_70638_az(), 1.0f);
            }
        } else if (this.isAnimationPlaying(VOMIT)) {
            this.func_70661_as().func_75499_g();
            if (this.getMainAnimationTick() == 1) {
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_GHOUL_VOMIT.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            if (this.hasAttackTarget()) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                if (this.getMainAnimationTick() == 12 && this.func_70613_aW()) {
                    VomitEntity vomit = new VomitEntity((EntityType<? extends VomitEntity>)((EntityType)DannyEntities.VOMIT.get()), this.field_70170_p, (LivingEntity)this);
                    vomit.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.65, this.func_226281_cx_());
                    vomit.func_234612_a_((Entity)this, this.field_70125_A, this.field_70759_as, -2.0f, 2.0f, 0.0f);
                    this.field_70170_p.func_217376_c((Entity)vomit);
                }
            }
        }
        if (this.func_70613_aW()) {
            if (this.respirationTimer.hasEnded()) {
                this.wakeAmbientAnimation(0);
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_GHOUL_RESPIRATION.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                this.respirationTimer.reset();
            } else {
                this.respirationTimer.tryUp();
            }
        }
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        if (effectInstanceIn.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        return super.func_195064_c(effectInstanceIn);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_GHOUL_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DannySounds.ENTITY_GHOUL_DEATH.get();
    }

    @Override
    @Nullable
    public SoundEvent getLivingSound() {
        return (SoundEvent)DannySounds.ENTITY_GHOUL_IDLE.get();
    }

    @Override
    public void playLivingSound() {
        super.playLivingSound();
        this.wakeAmbientAnimation(1);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{VOMIT, GRAB};
    }
}

