/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.PlayAnimationGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.PlayShuffledAnimationsGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.GolemDroneEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class JungleGolemEntity
extends DannyEntity
implements IMob {
    public static final Animation SLAM = new Animation(15);
    public static final Animation PUNCH = new Animation(15);
    public static final Animation HEAVY_PUNCH = new Animation(23);
    public static final Animation DRONE_FRONT = new Animation(28);
    public Timer heavyTimer;

    public JungleGolemEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.meleeTimer = new Timer(30);
        this.rangedTimer = new Timer(280);
        this.heavyTimer = new Timer(70, i -> MathUtil.getRandomOffset(i, 0.3f));
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.func_70024_g(0.1, 0.0, 0.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PlayAnimationGoal(this, HEAVY_PUNCH, o -> this.hasAttackTarget() && this.heavyTimer.hasEnded() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.func_70685_l((Entity)this.func_70638_az()) && this.reachTo((Entity)this.func_70638_az()) < 1.65f, o -> this.heavyTimer.reset()));
        this.field_70714_bg.func_75776_a(0, (Goal)new PlayShuffledAnimationsGoal((DannyEntity)this, Arrays.asList(SLAM, PUNCH), o -> this.hasAttackTarget() && this.meleeTimer.hasEnded() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.func_70685_l((Entity)this.func_70638_az()) && this.reachTo((Entity)this.func_70638_az()) < 1.65f, o -> this.meleeTimer.reset()));
        this.field_70714_bg.func_75776_a(1, (Goal)new PlayAnimationGoal(this, DRONE_FRONT, o -> this.hasAttackTarget() && this.isAnimationPlaying(Animation.NO_ANIMATION) && this.func_70685_l((Entity)this.func_70638_az()) && this.rangedTimer.hasEnded(), o -> this.rangedTimer.reset()));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowTargetGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 90.0).func_233815_a_(Attributes.field_233819_b_, 30.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 7.0);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70613_aW()) {
            if (this.isAnimationPlaying(SLAM)) {
                this.heavyTimer.tryUp();
                this.sleepPathSchedule.sleepForNow();
                if (this.getMainAnimationTick() == 4) {
                    this.func_184185_a(SoundEvents.field_232687_ak_, 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
                } else if (this.hasAttackTarget() && this.getMainAnimationTick() == 7 && this.reachTo((Entity)this.func_70638_az()) < 2.0f) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            } else if (this.isAnimationPlaying(PUNCH)) {
                this.heavyTimer.tryUp();
                this.sleepPathSchedule.sleepForNow();
                if (this.getMainAnimationTick() == 8) {
                    this.func_184185_a(SoundEvents.field_232687_ak_, 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
                } else if (this.hasAttackTarget() && this.getMainAnimationTick() == 7 && this.reachTo((Entity)this.func_70638_az()) < 2.0f) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            } else if (this.isAnimationPlaying(HEAVY_PUNCH)) {
                this.sleepPathSchedule.sleepForNow();
                if (!this.field_70170_p.func_201670_d()) {
                    if (this.getMainAnimationTick() == 10) {
                        this.field_70177_z = this.field_70759_as;
                        this.func_184185_a((SoundEvent)DannySounds.ENTITY_SWOOSH.get(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
                    }
                    if (this.hasAttackTarget()) {
                        this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                        if (this.hasAttackTarget() && this.getMainAnimationTick() == 12 && (double)this.reachTo((Entity)this.func_70638_az()) < 2.5) {
                            this.func_184185_a((SoundEvent)DannySounds.ENTITY_JUNGLE_GOLEM_HEAVY_HIT.get(), 1.0f, 0.6f + this.field_70146_Z.nextFloat() * 0.4f);
                            this.attackWithMultiplier(this.func_70638_az(), 1.75f);
                            JungleGolemEntity.disableShield((Entity)this.func_70638_az(), 60);
                        }
                    }
                }
            } else if (this.isAnimationPlaying(DRONE_FRONT)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
                    if (this.getMainAnimationTick() == 12) {
                        Vector3d vec = MathUtil.fromPitchYaw(0.0f, this.field_70761_aq);
                        Vector3d vecCounterClockwise90 = Vector3d.func_189986_a((float)0.0f, (float)(MathHelper.func_76142_g((float)this.field_70761_aq) + 270.0f));
                        GolemDroneEntity golemDroneEntity = (GolemDroneEntity)((EntityType)DannyEntities.GOLEM_DRONE.get()).func_200721_a(this.field_70170_p);
                        float yaw = MathUtil.getTargetYaw(golemDroneEntity, (Entity)this.func_70638_az());
                        float pitch = MathUtil.getTargetPitch(golemDroneEntity, (Entity)this.func_70638_az());
                        double x = 0.1 * vecCounterClockwise90.field_72450_a;
                        double y = 1.5;
                        double z = 0.1 * vecCounterClockwise90.field_72449_c;
                        double x1 = 0.8 * vec.field_72450_a;
                        double z1 = 0.8 * vec.field_72449_c;
                        golemDroneEntity.setCaster((LivingEntity)this);
                        golemDroneEntity.func_70107_b(this.func_226277_ct_() + x + x1, this.func_226278_cu_() + y, this.func_226281_cx_() + z + z1);
                        golemDroneEntity.setRotations(yaw, pitch);
                        this.field_70170_p.func_217376_c((Entity)golemDroneEntity);
                        this.func_184185_a((SoundEvent)DannySounds.ENTITY_JUNGLE_GOLEM_RELEASE.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
                    }
                }
            }
        }
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_JUNGLE_GOLEM_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DannySounds.ENTITY_JUNGLE_GOLEM_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DannySounds.ENTITY_JUNGLE_GOLEM_STEP.get();
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.35f, 0.5f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{SLAM, PUNCH, HEAVY_PUNCH, DRONE_FRONT};
    }
}

