/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.AridAbominationEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.AbstractSpellEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.BarrenOrbEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.DeserticFangEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.MummySoulEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.spell.SandScarabEggEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MummyEntity
extends DannyEntity
implements IMob {
    private static final DataParameter<ItemStack> FOREHEAD_ITEM = EntityDataManager.func_187226_a(MummyEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final Animation RISE_SPIKE = new Animation(26);
    public static final Animation THROW_ORB = new Animation(26);
    public static final Animation THROW_EGG = new Animation(26);
    public static final Animation SUMMON_ABOMINATION = new Animation(30);
    public Vector3d rightHandVec = Vector3d.field_186680_a;
    public Vector3d leftHandVec = Vector3d.field_186680_a;
    public Timer riseSpikeTimer;
    public Timer mummySoulTimer;
    public Timer eggTimer;
    public Timer summonTimer;

    public MummyEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        if (this.getForeheadItem() == ItemStack.field_190927_a) {
            float f = this.field_70146_Z.nextFloat();
            if (f < 0.003f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_196166_dX));
            } else if (f < 0.01f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151045_i));
            } else if (f < 0.015f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_205158_fa));
            } else if (f < 0.03f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151166_bC));
            } else if (f < 0.04f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_221696_bj));
            } else if (f < 0.12f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151043_k));
            } else if (f < 0.16f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151113_aN));
            } else if (f < 0.2f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151128_bU));
            } else if (f < 0.3f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_196128_bn));
            } else if (f < 0.35f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151103_aS));
            } else if (f < 0.4f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_222078_li));
            } else if (f < 0.45f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151016_H));
            } else if (f < 0.5f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151008_G));
            } else if (f < 0.55f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151145_ak));
            } else if (f < 0.6f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151044_h));
            } else if (f < 0.65f) {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151119_aD));
            } else {
                this.setForeheadItem(new ItemStack((IItemProvider)Items.field_151074_bl));
            }
        }
        this.rangedTimer.setBoundBase(60);
        this.riseSpikeTimer = new Timer(170, baseBound -> baseBound + (int)(this.field_70146_Z.nextGaussian() * (double)baseBound * (double)0.3f));
        this.mummySoulTimer = new Timer(80);
        this.eggTimer = new Timer(700);
        this.summonTimer = new Timer(250);
        this.summonTimer.setTimer(70);
        this.eggTimer.setTimer(200);
    }

    @Override
    protected void onDeathStart() {
        if (this.getForeheadItem() != ItemStack.field_190927_a) {
            ItemEntity item = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getForeheadItem());
            this.field_70170_p.func_217376_c((Entity)item);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SummonAbominationGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowEggGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new RiseSpikeGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new ThrowOrbGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowTargetGoal(this, 1.2, 100.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 120.0).func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233820_c_, 0.8).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FOREHEAD_ITEM, (Object)ItemStack.field_190927_a);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        CompoundNBT compoundnbt = compound.func_74775_l("ForeheadItem");
        if (!compoundnbt.isEmpty()) {
            this.setForeheadItem(ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("ForeheadItem", (INBT)this.getForeheadItem().func_77955_b(new CompoundNBT()));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70613_aW()) {
            if (this.func_70638_az() != null) {
                LivingEntity livingEntity = this.func_70638_az();
                this.mummySoulTimer.tryUp();
                this.riseSpikeTimer.tryUp();
                this.eggTimer.tryUp();
                this.summonTimer.tryUp();
                if (this.func_110143_aJ() < this.func_110138_aP() * 0.75f && this.reachTo((Entity)livingEntity) < 2.0f && this.mummySoulTimer.getTimer() >= 50) {
                    MummySoulEntity mummySoulEntity = new MummySoulEntity((EntityType<? extends AbstractSpellEntity>)((EntityType)DannyEntities.MUMMY_SOUL.get()), this.field_70170_p);
                    float yawToTarget = MathUtil.getTargetYaw((Entity)this, (Entity)this.func_70638_az());
                    float f0 = MathHelper.func_76126_a((float)(yawToTarget * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(yawToTarget * ((float)Math.PI / 180)));
                    float f2 = MathHelper.func_76126_a((float)((MathHelper.func_76142_g((float)yawToTarget) + -90.0f) * ((float)Math.PI / 180)));
                    float f3 = MathHelper.func_76134_b((float)((MathHelper.func_76142_g((float)yawToTarget) + -90.0f) * ((float)Math.PI / 180)));
                    mummySoulEntity.func_70080_a(this.func_226277_ct_() - 0.9 * (double)(-f0) - 0.5 * (double)(-f2), this.func_226278_cu_() + 1.0, this.func_226281_cx_() - 0.9 * (double)f1 - 0.5 * (double)f3, yawToTarget, 0.0f);
                    mummySoulEntity.setCaster((LivingEntity)this);
                    this.field_70170_p.func_217376_c((Entity)mummySoulEntity);
                    this.mummySoulTimer.reset();
                }
            }
            if (this.isAnimationPlaying(SUMMON_ABOMINATION) && this.getMainAnimationTick() == 2) {
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_MUMMY_SUMMON_ABOMINATION.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            }
        } else if (this.isAnimationPlaying(SUMMON_ABOMINATION)) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, Blocks.field_196662_n.func_176223_P()), this.rightHandVec.field_72450_a, this.rightHandVec.field_72448_b, this.rightHandVec.field_72449_c, 0.0, -0.1, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, Blocks.field_196662_n.func_176223_P()), this.leftHandVec.field_72450_a, this.leftHandVec.field_72448_b, this.leftHandVec.field_72449_c, 0.0, -0.1, 0.0);
        }
        if (this.isAnimationPlaying(THROW_EGG)) {
            if (!this.field_70170_p.func_201670_d() && this.hasAttackTarget()) {
                this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 999.0f, 30.0f);
                if (this.getMainAnimationTick() == 6) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_SWOOSH.get(), 1.0f, 0.6f);
                }
            }
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
    }

    public void setForeheadItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(FOREHEAD_ITEM, (Object)stack);
    }

    public ItemStack getForeheadItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(FOREHEAD_ITEM);
    }

    @Override
    @Nullable
    public SoundEvent getLivingSound() {
        return (SoundEvent)DannySounds.ENTITY_MUMMY_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_MUMMY_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)DannySounds.ENTITY_MUMMY_DEATH.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{RISE_SPIKE, THROW_ORB, THROW_EGG, SUMMON_ABOMINATION};
    }

    class SummonAbominationGoal
    extends Goal {
        SummonAbominationGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            MummyEntity.this.playMainAnimation(SUMMON_ABOMINATION);
            MummyEntity.this.summonTimer.reset();
            MummyEntity.this.sleepPathSchedule.setSleep(MummyEntity.this.getMainAnimation().getDuration());
        }

        public void func_75246_d() {
            AridAbominationEntity abomination;
            super.func_75246_d();
            if (MummyEntity.this.getMainAnimationTick() == 10 && MummyEntity.this.hasAttackTarget() && (abomination = (AridAbominationEntity)((EntityType)DannyEntities.ARID_ABOMINATION.get()).func_200721_a(MummyEntity.this.field_70170_p)) != null) {
                Vector3d vec0 = MathUtil.fromPitchYaw(-15.0f, MummyEntity.this.field_70177_z).func_216372_d(0.6, 0.6, 0.6);
                float yaw = MummyEntity.this.hasAttackTarget() ? MathUtil.getTargetYaw((Entity)abomination, (Entity)MummyEntity.this.func_70638_az()) : MummyEntity.this.field_70177_z;
                float pitch = MathUtil.getTargetPitch((Entity)abomination, (Entity)MummyEntity.this.func_70638_az());
                abomination.setTamed(true);
                abomination.setSummoner(MummyEntity.this);
                abomination.func_70080_a(MummyEntity.this.func_226277_ct_(), MummyEntity.this.func_226278_cu_(), MummyEntity.this.func_226281_cx_(), yaw, pitch);
                abomination.func_70024_g(vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c);
                MummyEntity.this.field_70170_p.func_217376_c((Entity)abomination);
            }
        }

        public boolean func_75253_b() {
            return MummyEntity.this.isAnimationPlaying(SUMMON_ABOMINATION);
        }

        public boolean func_75250_a() {
            return MummyEntity.this.hasAttackTarget() && MummyEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && MummyEntity.this.func_70685_l((Entity)MummyEntity.this.func_70638_az()) && MummyEntity.this.summonTimer.hasEnded();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class ThrowEggGoal
    extends Goal {
        ThrowEggGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            MummyEntity.this.playMainAnimation(THROW_EGG);
            MummyEntity.this.eggTimer.reset();
            MummyEntity.this.sleepPathSchedule.setSleep(MummyEntity.this.getMainAnimation().getDuration());
        }

        public void func_75246_d() {
            SandScarabEggEntity egg;
            super.func_75246_d();
            if (MummyEntity.this.getMainAnimationTick() == 9 && MummyEntity.this.hasAttackTarget() && (egg = (SandScarabEggEntity)((EntityType)DannyEntities.SAND_SCARAB_EGG.get()).func_200721_a(MummyEntity.this.field_70170_p)) != null) {
                Vector3d vec0 = MathUtil.fromPitchYaw(-15.0f, MummyEntity.this.field_70177_z).func_216372_d(0.6, 0.6, 0.6);
                egg.func_70107_b(MummyEntity.this.func_226277_ct_(), MummyEntity.this.func_226278_cu_() + (double)1.1f, MummyEntity.this.func_226281_cx_());
                float yaw = MummyEntity.this.hasAttackTarget() ? MathUtil.getTargetYaw(egg, (Entity)MummyEntity.this.func_70638_az()) : MummyEntity.this.field_70177_z;
                float pitch = MathUtil.getTargetPitch(egg, (Entity)MummyEntity.this.func_70638_az());
                egg.setRotations(yaw, pitch);
                egg.setCaster((LivingEntity)MummyEntity.this);
                egg.func_70024_g(vec0.field_72450_a, vec0.field_72448_b, vec0.field_72449_c);
                MummyEntity.this.field_70170_p.func_217376_c((Entity)egg);
            }
        }

        public boolean func_75253_b() {
            return MummyEntity.this.isAnimationPlaying(THROW_EGG);
        }

        public boolean func_75250_a() {
            return MummyEntity.this.hasAttackTarget() && MummyEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && MummyEntity.this.func_70685_l((Entity)MummyEntity.this.func_70638_az()) && MummyEntity.this.eggTimer.hasEnded();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }

    class RiseSpikeGoal
    extends Goal {
        double lastTickPozX;
        double lastTickPozZ;

        RiseSpikeGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            MummyEntity.this.playMainAnimation(RISE_SPIKE);
            MummyEntity.this.riseSpikeTimer.reset();
            MummyEntity.this.sleepPathSchedule.setSleep(MummyEntity.this.getMainAnimation().getDuration());
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (MummyEntity.this.hasAttackTarget()) {
                DeserticFangEntity deserticFangEntity;
                if (MummyEntity.this.getMainAnimationTick() == 11) {
                    this.lastTickPozX = MummyEntity.this.func_70638_az().field_70142_S;
                    this.lastTickPozZ = MummyEntity.this.func_70638_az().field_70136_U;
                }
                if (MummyEntity.this.getMainAnimationTick() == 12 && (deserticFangEntity = (DeserticFangEntity)((EntityType)DannyEntities.DESERTIC_FANG.get()).func_200721_a(MummyEntity.this.field_70170_p)) != null) {
                    double lastTickDifX = MathHelper.func_151237_a((double)(MummyEntity.this.func_70638_az().func_226277_ct_() - this.lastTickPozX), (double)-0.5, (double)0.5);
                    double lastTickDifZ = MathHelper.func_151237_a((double)(MummyEntity.this.func_70638_az().func_226281_cx_() - this.lastTickPozZ), (double)-0.5, (double)0.5);
                    BlockPos blockpos = new BlockPos(MummyEntity.this.func_70638_az().func_226277_ct_() + lastTickDifX * 6.0, MummyEntity.this.func_70638_az().func_226278_cu_(), MummyEntity.this.func_70638_az().func_226281_cx_() + lastTickDifZ * 6.0);
                    boolean flag = false;
                    double d0 = 0.0;
                    deserticFangEntity.setCaster((LivingEntity)MummyEntity.this);
                    do {
                        BlockState blockstate1;
                        VoxelShape voxelshape;
                        BlockPos blockpos1;
                        BlockState blockstate;
                        if (!(blockstate = MummyEntity.this.field_70170_p.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_224755_d((IBlockReader)MummyEntity.this.field_70170_p, blockpos1, Direction.UP)) continue;
                        if (!MummyEntity.this.field_70170_p.func_175623_d(blockpos) && !(voxelshape = (blockstate1 = MummyEntity.this.field_70170_p.func_180495_p(blockpos)).func_196952_d((IBlockReader)MummyEntity.this.field_70170_p, blockpos)).func_197766_b()) {
                            d0 = voxelshape.func_197758_c(Direction.Axis.Y);
                        }
                        flag = true;
                        break;
                    } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)d0) - 1);
                    if (flag) {
                        deserticFangEntity.func_70080_a(MummyEntity.this.func_70638_az().func_226277_ct_() + lastTickDifX * 6.0, (double)blockpos.func_177956_o() + d0, MummyEntity.this.func_70638_az().func_226281_cx_() + lastTickDifZ * 6.0, MathUtil.getTargetYaw(deserticFangEntity, (Entity)MummyEntity.this), 0.0f);
                        MummyEntity.this.field_70170_p.func_217376_c((Entity)deserticFangEntity);
                    }
                }
            }
        }

        public boolean func_75253_b() {
            return MummyEntity.this.isAnimationPlaying(RISE_SPIKE);
        }

        public boolean func_75250_a() {
            return MummyEntity.this.hasAttackTarget() && MummyEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && MummyEntity.this.func_70685_l((Entity)MummyEntity.this.func_70638_az()) && MummyEntity.this.riseSpikeTimer.hasEnded();
        }

        public void func_75251_c() {
            super.func_75251_c();
            MummyEntity.this.sleepPathSchedule.wake();
            MummyEntity.this.playMainAnimation(Animation.NO_ANIMATION);
        }
    }

    class ThrowOrbGoal
    extends Goal {
        ThrowOrbGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            MummyEntity.this.playMainAnimation(THROW_ORB);
            MummyEntity.this.rangedTimer.reset();
            MummyEntity.this.sleepPathSchedule.setSleep(MummyEntity.this.getMainAnimation().getDuration());
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (MummyEntity.this.hasAttackTarget()) {
                MummyEntity.this.func_70671_ap().func_75651_a((Entity)MummyEntity.this.func_70638_az(), 30.0f, 30.0f);
                if (MummyEntity.this.getMainAnimationTick() == 5) {
                    BarrenOrbEntity barrenOrbEntity = (BarrenOrbEntity)((EntityType)DannyEntities.BARREN_ORB.get()).func_200721_a(MummyEntity.this.field_70170_p);
                    if (barrenOrbEntity != null) {
                        barrenOrbEntity.func_70107_b(MummyEntity.this.func_226277_ct_(), MummyEntity.this.func_226278_cu_() + 2.5, MummyEntity.this.func_226281_cx_());
                        float yaw = MathUtil.getTargetYaw(barrenOrbEntity, (Entity)MummyEntity.this.func_70638_az());
                        float pitch = MathUtil.getTargetPitch(barrenOrbEntity, (Entity)MummyEntity.this.func_70638_az());
                        barrenOrbEntity.setRotations(yaw, pitch);
                        barrenOrbEntity.setCaster((LivingEntity)MummyEntity.this);
                        MummyEntity.this.field_70170_p.func_217376_c((Entity)barrenOrbEntity);
                    }
                    if (MummyEntity.this.getMainAnimationTick() == 16) {
                        MummyEntity.this.func_184185_a((SoundEvent)DannySounds.ENTITY_SWOOSH.get(), 0.6f, 1.0f + MummyEntity.this.field_70146_Z.nextFloat() * 0.1f);
                    }
                }
            }
        }

        public boolean func_75253_b() {
            return MummyEntity.this.isAnimationPlaying(THROW_ORB);
        }

        public boolean func_75250_a() {
            return MummyEntity.this.hasAttackTarget() && MummyEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && MummyEntity.this.func_70685_l((Entity)MummyEntity.this.func_70638_az()) && MummyEntity.this.rangedTimer.hasEnded();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }
    }
}

