/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.client.sound.EntityMovingSound;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.ai.goals.PlayShuffledAnimationsGoal;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PossessedArmorEntity
extends DannyEntity
implements IMob {
    private static final DataParameter<Boolean> HEALING_USED = EntityDataManager.func_187226_a(PossessedArmorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation BLUNT = new Animation(17);
    public static final Animation SLASH = new Animation(21);
    public static final Animation SWING = new Animation(20);
    public static final Animation DOUBLE_SWING = new Animation(21);
    public static final Animation IMPALE = new Animation(26);
    public static final Animation HEAL = new Animation(28);
    public static final Animation DASH = new Animation(40);
    public static final Animation DEATH = new Animation(24);
    public Timer dashTimer = new Timer(160);

    public PossessedArmorEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.2f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new HealGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new DashGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PlayShuffledAnimationsGoal((DannyEntity)this, Arrays.asList(BLUNT, SLASH, SWING, DOUBLE_SWING, IMPALE), o -> this.ifAttackMeleeParamsAnd(target -> this.reachTo((Entity)target) < 2.3f)));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowTargetGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233820_c_, 0.9).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233818_a_, 36.0).func_233815_a_(Attributes.field_233821_d_, 0.29).func_233815_a_(Attributes.field_233826_i_, 15.0).func_233815_a_(Attributes.field_233823_f_, 5.5);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEALING_USED, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setHealingUsed(compound.func_74767_n("HealingUsed"));
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("HealingUsed", this.getHealingUsed());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.func_201670_d()) {
            LivingEntity target = this.func_70638_az();
            if (this.hasAttackTarget()) {
                this.dashTimer.tryUp();
            }
            if (this.isAnimationPlaying(BLUNT)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    if (this.getMainAnimationTick() == 9 && this.reachTo((Entity)target) < 2.0f) {
                        this.attackWithMultiplier(target, 1.0f);
                        this.mayDisableShield((Entity)this.func_70638_az(), 20, 0.25f);
                    }
                    this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                this.field_70177_z = this.field_70759_as;
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 6) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 7) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_MODERATED.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 8) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(SLASH)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    if (this.getMainAnimationTick() == 10 && this.reachTo((Entity)target) < 2.0f) {
                        this.attackWithMultiplier(target, 1.1f);
                        this.mayDisableShield((Entity)this.func_70638_az(), 20, 0.25f);
                    }
                    this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                this.field_70177_z = this.field_70759_as;
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 7) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 8) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(SWING)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    if (this.getMainAnimationTick() == 8 && this.reachTo((Entity)target) < 2.0f) {
                        this.attackWithMultiplier(target, 1.15f);
                        this.mayDisableShield((Entity)this.func_70638_az(), 20, 0.25f);
                    }
                    this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                this.field_70177_z = this.field_70759_as;
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 4) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 7) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_MODERATED.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(DOUBLE_SWING)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    if (this.reachTo((Entity)target) < 2.0f) {
                        if (this.getMainAnimationTick() == 10) {
                            this.attackWithMultiplier(target, 1.0f);
                            this.mayDisableShield((Entity)this.func_70638_az(), 20, 0.25f);
                            target.field_70172_ad = 0;
                        } else if (this.getMainAnimationTick() == 14) {
                            this.attackWithMultiplier(target, 1.0f);
                            PossessedArmorEntity.disableShield((Entity)this.func_70638_az(), 20);
                        }
                    }
                    this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                this.field_70177_z = this.field_70759_as;
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 6 || this.getMainAnimationTick() == 12) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_SMALL.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 7) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_LOW_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(IMPALE)) {
                this.sleepPathSchedule.sleepForNow();
                if (this.hasAttackTarget()) {
                    if (this.getMainAnimationTick() == 16 && this.reachTo((Entity)target) < 2.75f) {
                        this.attackWithMultiplier(target, 1.4f);
                        PossessedArmorEntity.disableShield((Entity)this.func_70638_az(), 40);
                    }
                    this.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                this.field_70177_z = this.field_70759_as;
                if (this.getMainAnimationTick() == 4) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_HEAVY_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 7) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_HARD_STEP.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 16) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_THIN_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 14) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 15) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            } else if (this.isAnimationPlaying(DASH)) {
                if (this.getMainAnimationTick() == 4) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_HEAVY_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 19) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_SWISH.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_BLADE_SWING_LARGE.get(), 1.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                    this.sendClientManagerMsg(0);
                }
            } else if (this.isAnimationPlaying(HEAL)) {
                this.sleepPathSchedule.sleepForNow();
                for (int drinkTicks = 0; drinkTicks < 3; ++drinkTicks) {
                    if (this.getMainAnimationTick() != 12 + drinkTicks * 2) continue;
                    this.func_184185_a(SoundEvents.field_187664_bz, 1.0f, 1.0f);
                }
                if (this.getMainAnimationTick() == 18) {
                    this.func_70606_j(this.func_110138_aP());
                }
            } else if (this.isAnimationPlaying(DEATH)) {
                if (this.getMainAnimationTick() == 1) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_DEATH.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 2) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_DEEP_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                } else if (this.getMainAnimationTick() == 12) {
                    this.func_184185_a((SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                }
            }
        } else if (this.isAnimationPlaying(DASH) && this.getMainAnimationTick() < 27) {
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        super.dannyClientManager(flag, abstractVal);
        if (flag == 0) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new EntityMovingSound((Entity)this, (SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_DASH.get(), SoundCategory.HOSTILE));
        }
    }

    public boolean func_195064_c(EffectInstance effectInstanceIn) {
        if (effectInstanceIn.func_188419_a() == Effects.field_76436_u) {
            return false;
        }
        if (effectInstanceIn.func_188419_a() == Effects.field_76438_s) {
            return false;
        }
        return super.func_195064_c(effectInstanceIn);
    }

    protected boolean func_241208_cS_() {
        return false;
    }

    @Override
    protected void onDeathStart() {
        super.onDeathStart();
        this.func_184185_a((SoundEvent)DannySounds.ENTITY_BODYFALL.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean getHealingUsed() {
        return (Boolean)this.func_184212_Q().func_187225_a(HEALING_USED);
    }

    public void setHealingUsed(boolean bool) {
        this.func_184212_Q().func_187227_b(HEALING_USED, (Object)bool);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)DannySounds.ENTITY_ARMOR_HIT.get();
    }

    @Override
    @Nullable
    public SoundEvent getLivingSound() {
        return (SoundEvent)DannySounds.ENTITY_ARMOR_CREAK.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_STEP.get();
    }

    @Override
    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.25f, 1.0f);
        this.func_184185_a((SoundEvent)DannySounds.ENTITY_POSSESSED_ARMOR_JIGGLES.get(), 0.15f, 1.0f);
    }

    @Override
    protected DannyEntity.LoopStepSoundPlayer lSSPlayer() {
        return this.LSP_DOUBLE;
    }

    @Override
    public float getLimbSwingMultiplier() {
        return 0.33f;
    }

    @Override
    public DannyEntity.LimbSwingType getLimbSwingType() {
        return DannyEntity.LimbSwingType.LOOP;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{DEATH, BLUNT, SLASH, SWING, DOUBLE_SWING, IMPALE, DASH, HEAL};
    }

    @Override
    public Animation getDeathAnimation() {
        return DEATH;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected float func_189749_co() {
        return 1.0f;
    }

    @Override
    protected void playLoopStepSound(BlockPos pos, BlockState blockIn) {
        super.playLoopStepSound(pos, blockIn);
    }

    class HealGoal
    extends Goal {
        HealGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            PossessedArmorEntity.this.playMainAnimation(HEAL);
            PossessedArmorEntity.this.setHealingUsed(true);
        }

        public boolean func_75250_a() {
            return PossessedArmorEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && !PossessedArmorEntity.this.getHealingUsed() && PossessedArmorEntity.this.func_110143_aJ() < PossessedArmorEntity.this.func_110138_aP() / 2.0f;
        }
    }

    class DashGoal
    extends Goal {
        boolean didDamage;

        DashGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            PossessedArmorEntity.this.playMainAnimation(DASH);
            PossessedArmorEntity.this.dashTimer.reset();
            this.didDamage = false;
        }

        public void func_75246_d() {
            float distance;
            super.func_75246_d();
            Vector3d vecToTarget = Vector3d.field_186680_a;
            PossessedArmorEntity.this.sleepPathSchedule.sleepForNow();
            if (PossessedArmorEntity.this.hasAttackTarget()) {
                distance = Math.max(PossessedArmorEntity.this.func_70032_d((Entity)PossessedArmorEntity.this.func_70638_az()), 3.5f);
                PossessedArmorEntity.this.func_70671_ap().func_75651_a((Entity)PossessedArmorEntity.this.func_70638_az(), 30.0f, 30.0f);
                if (PossessedArmorEntity.this.getMainAnimationTick() == 19) {
                    vecToTarget = MathUtil.fromPitchYaw(0.0f, MathUtil.getTargetYaw((Entity)PossessedArmorEntity.this, (Entity)PossessedArmorEntity.this.func_70638_az()));
                }
                if (PossessedArmorEntity.this.getMainAnimationTick() >= 20 && PossessedArmorEntity.this.getMainAnimationTick() <= 32 && !this.didDamage && distance < 5.0f) {
                    PossessedArmorEntity.this.attackWithMultiplier(PossessedArmorEntity.this.func_70638_az(), 1.2f);
                    DannyEntity.disableShield((Entity)PossessedArmorEntity.this.func_70638_az(), 30);
                    this.didDamage = true;
                }
            } else {
                if (PossessedArmorEntity.this.getMainAnimationTick() == 19) {
                    vecToTarget = MathUtil.fromPitchYaw(0.0f, PossessedArmorEntity.this.field_70759_as);
                }
                distance = 0.0f;
            }
            if (PossessedArmorEntity.this.getMainAnimationTick() == 19) {
                PossessedArmorEntity.this.func_213315_a(MoverType.SELF, vecToTarget.func_216372_d((double)distance, 0.0, (double)distance));
            }
        }

        public boolean func_75253_b() {
            return PossessedArmorEntity.this.isAnimationPlaying(DASH);
        }

        public boolean func_75250_a() {
            if (PossessedArmorEntity.this.hasAttackTarget()) {
                float distance = PossessedArmorEntity.this.func_70032_d((Entity)PossessedArmorEntity.this.func_70638_az());
                return PossessedArmorEntity.this.dashTimer.hasEnded() && PossessedArmorEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && PossessedArmorEntity.this.func_70638_az().func_233580_cy_().func_177956_o() == PossessedArmorEntity.this.func_233580_cy_().func_177956_o() && distance > 6.0f && distance < 11.0f && PossessedArmorEntity.this.func_70635_at().func_75522_a((Entity)PossessedArmorEntity.this.func_70638_az());
            }
            return false;
        }
    }
}

