/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.common.Entities.living.OldFloatingEntity;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class RangedAvoidingEntity
extends OldFloatingEntity {
    public RangedAvoidingEntity(EntityType<? extends RangedAvoidingEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new HoveringMovementController(this);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public class HoveringMovementController
    extends MovementController {
        final RangedAvoidingEntity iceElement;
        boolean outOfBounds;
        boolean isAvoidingTarget;
        boolean isFollowingTarget;
        int randomAngleTimer;
        int angleTransTicks;
        int f0;
        double r0;
        double r1;
        double boost;

        public HoveringMovementController(RangedAvoidingEntity mob) {
            super((MobEntity)mob);
            this.randomAngleTimer = 0;
            this.iceElement = mob;
        }

        public void func_75641_c() {
            super.func_75641_c();
            float speed = 1.0f;
            float verticalAir = MathUtil.verticalNonSolid((IBlockReader)this.iceElement.field_70170_p, new BlockPos(this.iceElement.func_213303_ch()), -1, 15);
            if (verticalAir > 6.0f || verticalAir <= 1.0f) {
                this.outOfBounds = true;
            }
            if (this.iceElement.field_70123_F || this.iceElement.field_70124_G) {
                this.iceElement.func_213317_d(RangedAvoidingEntity.this.func_213322_ci().func_72441_c(0.0, (double)0.05f, 0.0));
            }
            if (this.iceElement.func_70638_az() != null) {
                Vector3d forward = Vector3d.func_189986_a((float)RangedAvoidingEntity.this.field_70125_A, (float)RangedAvoidingEntity.this.field_70759_as);
                this.isFollowingTarget = false;
                double distance = this.iceElement.func_70068_e((Entity)this.iceElement.func_70638_az());
                verticalAir = (float)(this.iceElement.func_226278_cu_() - this.iceElement.func_70638_az().func_226280_cw_());
                if (distance > 120.0) {
                    this.boost *= 3.0;
                }
                if (distance > 80.0) {
                    this.iceElement.addMotion((double)2.0E-4f * (distance / 2.0 - 80.0) / 2.0 * forward.field_72450_a + 0.005, (double)2.0E-4f * (distance / 2.0 - 80.0) / 2.0 * forward.field_72448_b + 0.005, (double)2.0E-4f * (distance / 2.0 - 80.0) / 2.0 * forward.field_72449_c + 0.005);
                    this.isAvoidingTarget = false;
                    this.isFollowingTarget = true;
                } else if (distance < 40.0) {
                    this.isAvoidingTarget = true;
                    this.iceElement.addMotion(MathHelper.func_151237_a((double)((double)0.006f * (distance - 40.0) / 1.4), (double)0.0, (double)0.1) * forward.field_72450_a, MathHelper.func_151237_a((double)((double)0.01f * (-distance + 40.0) / 1.2), (double)0.0, (double)1.5), MathHelper.func_151237_a((double)((double)0.006f * (distance - 40.0)), (double)0.0, (double)0.1) * forward.field_72449_c);
                }
                if (--this.randomAngleTimer <= 0) {
                    int r2;
                    this.angleTransTicks = r2 = MathHelper.func_76136_a((Random)RangedAvoidingEntity.this.field_70146_Z, (int)30, (int)70);
                    this.f0 = r2;
                    this.randomAngleTimer = r2;
                    this.r0 = RangedAvoidingEntity.this.field_70146_Z.nextGaussian() * 1.0;
                    this.r1 = verticalAir >= 4.0f ? (double)(RangedAvoidingEntity.this.field_70146_Z.nextFloat() * -2.0f - verticalAir / 4.0f) : (verticalAir < 2.0f ? (double)(RangedAvoidingEntity.this.field_70146_Z.nextFloat() * 1.7f + 1.0f) : RangedAvoidingEntity.this.field_70146_Z.nextGaussian() * 1.25);
                }
                if (--this.angleTransTicks > 0) {
                    Vector3d counterClockwise90 = Vector3d.func_189986_a((float)(MathHelper.func_76142_g((float)RangedAvoidingEntity.this.field_70125_A) + 270.0f), (float)(MathHelper.func_76142_g((float)RangedAvoidingEntity.this.field_70759_as) + 270.0f));
                    this.iceElement.addMotion(this.r0 / (double)this.f0 * counterClockwise90.field_72450_a, this.r1 / (double)this.f0 * counterClockwise90.field_72448_b + 0.1 * this.r1 / (double)this.f0, this.r0 / (double)this.f0 * counterClockwise90.field_72449_c);
                }
                this.iceElement.func_70671_ap().func_75651_a((Entity)this.iceElement.func_70638_az(), 30.0f, 90.0f);
                this.iceElement.field_70177_z = MathUtil.getTargetYaw((Entity)this.iceElement, (Entity)this.iceElement.func_70638_az());
                this.iceElement.field_70761_aq = MathUtil.getTargetYaw((Entity)this.iceElement, (Entity)this.iceElement.func_70638_az());
            } else if (this.outOfBounds) {
                if (verticalAir > 3.0f) {
                    this.iceElement.addMotion(0.0, -0.1f * speed, 0.0);
                } else if (verticalAir < 3.0f) {
                    this.iceElement.addMotion(0.0, 0.1f * speed, 0.0);
                } else {
                    this.outOfBounds = false;
                }
            }
        }
    }
}

