/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.SandScarabEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.slime.AbstractSlimeEntity;
import com.bottomtextdanny.dannys_expansion.core.Packets.DENetwork;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class SlimeSummonEntity
extends AbstractSlimeEntity {
    protected static final DataParameter<Optional<UUID>> SUMMONER_UUID = EntityDataManager.func_187226_a(SandScarabEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> TAMED = EntityDataManager.func_187226_a(SandScarabEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public DannyEntity summoner;
    protected int lifeTicks;
    protected int maxLifeTicks = 100;
    protected Timer uselessTimer = new Timer(100);

    public SlimeSummonEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(TAMED, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("Summoner")) {
            this.func_184212_Q().func_187227_b(SUMMONER_UUID, Optional.of(compound.func_186857_a("Summoner")));
        }
        this.setTamed(compound.func_74767_n("Tamed"));
        this.lifeTicks = compound.func_74762_e("LifeTicks");
        this.maxLifeTicks = compound.func_74762_e("MaxLifeTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Optional)this.func_184212_Q().func_187225_a(SUMMONER_UUID)).isPresent()) {
            compound.func_186854_a("Summoner", (UUID)((Optional)this.func_184212_Q().func_187225_a(SUMMONER_UUID)).get());
        }
        compound.func_74757_a("Tamed", this.isTamed());
        compound.func_74768_a("LifeTicks", this.lifeTicks);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (key == SUMMONER_UUID) {
            DENetwork.attachEntity(0, (Entity)this, ((Optional)this.func_184212_Q().func_187225_a(SUMMONER_UUID)).orElse(null));
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isTamed() && !this.field_70170_p.func_201670_d() && this.func_70089_S()) {
            if (this.lifeTicks < this.maxLifeTicks) {
                ++this.lifeTicks;
            } else if (this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                this.func_70097_a(DamageSource.field_76376_m, this.func_110138_aP());
            }
            if (this.getSummoner() == null || !this.getSummoner().func_70089_S()) {
                if (this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                    this.func_70097_a(DamageSource.field_76376_m, this.func_110138_aP());
                }
            } else if (this.getSummoner().hasAttackTarget()) {
                this.func_70624_b(this.getSummoner().func_70638_az());
            } else {
                if (this.hasAttackTarget()) {
                    this.func_70624_b(null);
                }
                this.uselessTimer.tryUp();
                if (this.uselessTimer.hasEnded() && this.isAnimationPlaying(Animation.NO_ANIMATION)) {
                    this.func_70097_a(DamageSource.field_76376_m, this.func_110138_aP());
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.sendClientManagerMsg(0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void dannyClientManager(int flag, float abstractVal) {
        super.dannyClientManager(flag, abstractVal);
        if (flag == 0 && this.getDeathParticle() != null) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02 + (double)0.05f;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a(this.getDeathParticle(), this.func_226282_d_(0.1), this.func_226279_cv_(), this.func_226287_g_(0.1), d0, d1, d2);
            }
        }
    }

    public abstract IParticleData getDeathParticle();

    public void setSummoner(DannyEntity livingEntity) {
        this.func_184212_Q().func_187227_b(SUMMONER_UUID, Optional.of(livingEntity.func_110124_au()));
    }

    public void setTamed(boolean v) {
        this.func_184212_Q().func_187227_b(TAMED, (Object)v);
    }

    @Nullable
    public DannyEntity getSummoner() {
        if (this.summoner == null && this.getAttachedEntity(0) instanceof DannyEntity && this.getAttachedEntity(0).func_70089_S()) {
            this.summoner = (DannyEntity)this.getAttachedEntity(0);
        }
        return this.summoner;
    }

    public boolean isTamed() {
        return (Boolean)this.func_184212_Q().func_187225_a(TAMED);
    }
}

