/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.AmbientAnimation;
import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.core.Util.MathUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class SnaithEntity
extends DannyEntity {
    private static final DataParameter<Boolean> IS_RESTING = EntityDataManager.func_187226_a(SnaithEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CRACK_LEVEL = EntityDataManager.func_187226_a(SnaithEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static Animation WAKE_UP = new Animation(40);
    public static Animation REST = new Animation(40);
    public Timer toRestTimer;
    public Timer nextAttackTimer;

    public SnaithEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.setAmbientAnimation(new AmbientAnimation(5), 0);
        this.toRestTimer = new Timer(80);
        this.nextAttackTimer = new Timer(120, baseBound -> MathUtil.getRandomOffset(baseBound, 0.3f));
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233819_b_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233820_c_, 0.0).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_RESTING, (Object)true);
        this.func_184212_Q().func_187214_a(CRACK_LEVEL, (Object)0);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setResting(compound.func_74767_n("IsResting"));
        this.setCrackLevel(compound.func_74762_e("CrackLevel"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsResting", this.isResting());
        compound.func_74768_a("CrackLevel", this.getCrackLevel());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.wakeAmbientAnimation(0);
        return false;
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
        Vector3d yawToPredicate = MathUtil.fromPitchYaw(0.0f, MathUtil.getTargetYaw((Entity)this, entityIn));
        entityIn.func_213315_a(MoverType.SELF, yawToPredicate.func_216372_d(0.05, 0.0, 0.05));
    }

    public boolean func_230279_az_() {
        return true;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{WAKE_UP, REST};
    }

    public void setResting(boolean value) {
        this.func_184212_Q().func_187227_b(IS_RESTING, (Object)value);
    }

    public void setCrackLevel(int value) {
        this.func_184212_Q().func_187227_b(CRACK_LEVEL, (Object)value);
    }

    public boolean isResting() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_RESTING);
    }

    public int getCrackLevel() {
        return (Integer)this.func_184212_Q().func_187225_a(CRACK_LEVEL);
    }

    class WakeUpGoal
    extends Goal {
        WakeUpGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            SnaithEntity.this.playMainAnimation(WAKE_UP);
        }

        public boolean func_75253_b() {
            return false;
        }

        public boolean func_75250_a() {
            return SnaithEntity.this.isResting() && SnaithEntity.this.hasAttackTarget() && SnaithEntity.this.func_70032_d((Entity)SnaithEntity.this.func_70638_az()) < 5.0f;
        }
    }
}

