/*
 * Decompiled with CFR 0.152.
 */
package com.bottomtextdanny.dannys_expansion.common.Entities.living;

import com.bottomtextdanny.dannys_expansion.client.animation.types.Animation;
import com.bottomtextdanny.dannys_expansion.common.Entities.living.DannyEntity;
import com.bottomtextdanny.dannys_expansion.common.Entities.projectile.SporeEntity;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyEntities;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannyParticles;
import com.bottomtextdanny.dannys_expansion.core.Registries.DannySounds;
import com.bottomtextdanny.dannys_expansion.core.Util.EntityUtil;
import com.bottomtextdanny.dannys_expansion.core.Util.Timer;
import com.bottomtextdanny.dannys_expansion.core.interfaces.ISummoner;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;

public class SporerEntity
extends DannyEntity
implements ISummoner {
    public static final Animation BOING = new Animation(30);
    public Timer sporeTimer = new Timer(150, baseBound -> baseBound + MathHelper.func_76128_c((double)(this.field_70146_Z.nextGaussian() * 0.2 * (double)baseBound)));

    public SporerEntity(EntityType<? extends SporerEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BoingGoal());
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 60.0).func_233815_a_(Attributes.field_233820_c_, 0.9);
    }

    @Override
    public boolean func_213397_c(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{BOING};
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.sporeTimer.tryUp();
        if (this.isAnimationPlaying(BOING) && this.getMainAnimationTick() >= 6) {
            EntityUtil.particleAt(this.field_70170_p, (IParticleData)ParticleTypes.field_197596_G, 1, this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_(), 0.0, 0.0, 0.0, 0.0);
            if (this.getMainAnimationTick() == 6) {
                this.func_184185_a((SoundEvent)DannySounds.ENTITY_SPORER_SQUISH.get(), 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            }
        }
    }

    @Override
    public void func_213352_e(Vector3d p_213352_1_) {
        super.func_213352_e(p_213352_1_);
        if (this.func_70613_aW()) {
            ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double d0 = gravity.func_111126_e();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, d0 * 0.9424, 0.0));
        }
        this.field_70143_R = 0.0f;
    }

    @Override
    public IParticleData getDespawnParticle() {
        return (IParticleData)DannyParticles.DEATH_SPORER.get();
    }

    class BoingGoal
    extends Goal {
        BoingGoal() {
        }

        public void func_75249_e() {
            super.func_75249_e();
            SporerEntity.this.playMainAnimation(BOING);
        }

        public void func_75246_d() {
            float prog;
            super.func_75246_d();
            if (SporerEntity.this.getMainAnimationTick() >= 0 && SporerEntity.this.getMainAnimationTick() < 6) {
                prog = (float)SporerEntity.this.getMainAnimationTick() / 6.0f;
                SporerEntity.this.func_213293_j(0.0, -0.1 * (double)prog, 0.0);
            }
            if (SporerEntity.this.getMainAnimationTick() >= 6 && SporerEntity.this.getMainAnimationTick() < 10) {
                prog = (float)(SporerEntity.this.getMainAnimationTick() - 6) / 4.0f;
                float invProg = (float)(1.0 - (double)prog);
                Random rand = new Random();
                SporerEntity.this.func_213293_j(0.0, 0.7 * (double)invProg, 0.0);
                if (SporerEntity.this.getMainAnimationTick() == 6) {
                    SporeEntity sporeEntity = new SporeEntity((EntityType<? extends SporeEntity>)((EntityType)DannyEntities.SPORE.get()), SporerEntity.this.field_70170_p, (LivingEntity)SporerEntity.this);
                    sporeEntity.func_70107_b(SporerEntity.this.func_226277_ct_(), SporerEntity.this.func_226278_cu_() + 0.5, SporerEntity.this.func_226281_cx_());
                    sporeEntity.func_234612_a_((Entity)SporerEntity.this, SporerEntity.this.field_70125_A - 50.0f + rand.nextFloat() * -30.0f, rand.nextFloat() * 360.0f, 0.0f, 0.5f, 1.0f);
                    SporerEntity.this.field_70170_p.func_217376_c((Entity)sporeEntity);
                }
            }
        }

        public boolean func_75253_b() {
            return SporerEntity.this.isAnimationPlaying(BOING);
        }

        public boolean func_75250_a() {
            return SporerEntity.this.isAnimationPlaying(Animation.NO_ANIMATION) && (this.airBelow((IBlockReader)SporerEntity.this.field_70170_p, new BlockPos(SporerEntity.this.func_226277_ct_(), SporerEntity.this.func_226278_cu_(), SporerEntity.this.func_226281_cx_())) < 5 || SporerEntity.this.field_70124_G);
        }

        protected int airBelow(IBlockReader worldIn, BlockPos pos) {
            int i;
            for (i = 0; i < 5 && worldIn.func_180495_p(pos.func_177979_c(i)).func_196958_f(); ++i) {
            }
            return i;
        }
    }
}

